/*     */ package com.arjuna.ats.jta.utils;
/*     */ 
/*     */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.naming.ConfigurationException;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ 
/*     */ public class JNDIManager
/*     */ {
/*     */   private static final String DEFAULT_TM_JNDI_CONTEXT = "java:/TransactionManager";
/*     */   private static final String DEFAULT_UT_JNDI_CONTEXT = "java:/UserTransaction";
/*     */   private static final String DEFAULT_TSR_JNDI_CONTEXT = "java:/TransactionSynchronizationRegistry";
/*     */   private static final String DEFAULT_UT_IMPLEMENTATION = "com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple";
/*     */   private static final String DEFAULT_TM_IMPLEMENTATION = "com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple";
/*     */   private static final String DEFAULT_TSR_IMPLEMENTATION = "com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple";
/*     */ 
/*     */   public static void bindJTAImplementations(InitialContext ctx)
/*     */     throws NamingException
/*     */   {
/*  54 */     bindJTATransactionManagerImplementation(ctx);
/*  55 */     bindJTAUserTransactionImplementation(ctx);
/*  56 */     bindJTATransactionSynchronizationRegistryImplementation(ctx);
/*     */   }
/*     */ 
/*     */   public static void bindJTAImplementation()
/*     */     throws NamingException
/*     */   {
/*  65 */     bindJTATransactionManagerImplementation();
/*  66 */     bindJTAUserTransactionImplementation();
/*  67 */     bindJTATransactionSynchronizationRegistryImplementation();
/*     */   }
/*     */ 
/*     */   public static String getTransactionManagerImplementationClassname()
/*     */   {
/*  72 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.jtaTMImplementation", "com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple");
/*     */   }
/*     */ 
/*     */   public static String getUserTransactionImplementationClassname()
/*     */   {
/*  77 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.jtaUTImplementation", "com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple");
/*     */   }
/*     */ 
/*     */   public static String getTransactionSynchronizationRegistryImplementationClassname()
/*     */   {
/*  82 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.jtaTSRImplementation", "com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple");
/*     */   }
/*     */ 
/*     */   public static void bindJTATransactionManagerImplementation()
/*     */     throws NamingException
/*     */   {
/*  92 */     bindJTATransactionManagerImplementation(new InitialContext());
/*     */   }
/*     */ 
/*     */   public static void bindJTATransactionManagerImplementation(InitialContext initialContext)
/*     */     throws NamingException
/*     */   {
/* 104 */     String tmImplementation = getTransactionManagerImplementationClassname();
/*     */ 
/* 107 */     Reference ref = new Reference(tmImplementation, tmImplementation, null);
/* 108 */     initialContext.rebind(getTransactionManagerJNDIName(), ref);
/*     */   }
/*     */ 
/*     */   public static void bindJTAUserTransactionImplementation()
/*     */     throws NamingException
/*     */   {
/* 118 */     bindJTAUserTransactionImplementation(new InitialContext());
/*     */   }
/*     */ 
/*     */   public static void bindJTAUserTransactionImplementation(InitialContext initialContext)
/*     */     throws NamingException
/*     */   {
/* 130 */     String utImplementation = getUserTransactionImplementationClassname();
/*     */ 
/* 133 */     Reference ref = new Reference(utImplementation, utImplementation, null);
/* 134 */     initialContext.rebind(getUserTransactionJNDIName(), ref);
/*     */   }
/*     */ 
/*     */   public static void bindJTATransactionSynchronizationRegistryImplementation()
/*     */     throws NamingException
/*     */   {
/* 144 */     bindJTATransactionSynchronizationRegistryImplementation(new InitialContext());
/*     */   }
/*     */ 
/*     */   public static void bindJTATransactionSynchronizationRegistryImplementation(InitialContext initialContext)
/*     */     throws NamingException
/*     */   {
/* 158 */     String tsrImplementation = getTransactionSynchronizationRegistryImplementationClassname();
/* 159 */     Object tsr = null;
/*     */     try {
/* 161 */       tsr = Class.forName(tsrImplementation).newInstance();
/*     */     } catch (Exception e) {
/* 163 */       NamingException namingException = new ConfigurationException(jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.JNDIManager.tsr1"));
/* 164 */       namingException.setRootCause(e);
/* 165 */       throw namingException;
/*     */     }
/*     */ 
/* 169 */     initialContext.rebind(getTransactionSynchronizationRegistryJNDIName(), tsr);
/*     */   }
/*     */ 
/*     */   public static final String getTransactionManagerJNDIName()
/*     */   {
/* 174 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.utils.TMJNDIContext", "java:/TransactionManager");
/*     */   }
/*     */ 
/*     */   public static final String getUserTransactionJNDIName()
/*     */   {
/* 179 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.utils.UTJNDIContext", "java:/UserTransaction");
/*     */   }
/*     */ 
/*     */   private static final String getTransactionSynchronizationRegistryJNDIName()
/*     */   {
/* 184 */     return jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.utils.TSRJNDIContext", "java:/TransactionSynchronizationRegistry");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jta.utils.JNDIManager
 * JD-Core Version:    0.6.0
 */