/*     */ package com.arjuna.ats.internal.txoj.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class TORecoveryModule
/*     */   implements RecoveryModule
/*     */ {
/*     */   private Hashtable _uncommittedTOTable;
/* 287 */   private static ObjectStore _objectStore = null;
/*     */ 
/*     */   public TORecoveryModule()
/*     */   {
/*  77 */     if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */     {
/*  79 */       txojLogger.aitLoggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_1");
/*     */     }
/*     */ 
/*  88 */     _objectStore = new ObjectStore(13);
/*     */   }
/*     */ 
/*     */   public TORecoveryModule(ObjectName objName)
/*     */   {
/* 101 */     if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */     {
/* 103 */       txojLogger.aitLoggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_2", new Object[] { objName });
/*     */     }
/*     */ 
/* 109 */     _objectStore = new ObjectStore(objName);
/*     */   }
/*     */ 
/*     */   public void periodicWorkFirstPass()
/*     */   {
/* 114 */     if (txojLogger.aitLoggerI18N.isInfoEnabled())
/*     */     {
/* 116 */       txojLogger.aitLoggerI18N.info("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_3");
/*     */     }
/*     */ 
/* 120 */     this._uncommittedTOTable = new Hashtable();
/*     */     try
/*     */     {
/* 124 */       InputObjectState types = new InputObjectState();
/*     */ 
/* 127 */       if (_objectStore.allTypes(types)) {
/* 128 */         String theName = null;
/*     */         try
/*     */         {
/* 131 */           boolean endOfList = false;
/*     */ 
/* 133 */           while (!endOfList)
/*     */           {
/* 135 */             theName = types.unpackString();
/*     */ 
/* 137 */             if (theName.compareTo("") == 0) {
/* 138 */               endOfList = true; continue;
/*     */             }
/* 140 */             InputObjectState uids = new InputObjectState();
/*     */ 
/* 143 */             if (_objectStore.allObjUids(theName, uids, 2))
/*     */             {
/* 145 */               Uid theUid = new Uid(Uid.nullUid());
/*     */               try
/*     */               {
/* 149 */                 boolean endOfUids = false;
/*     */ 
/* 151 */                 while (!endOfUids)
/*     */                 {
/* 153 */                   theUid.unpack(uids);
/*     */ 
/* 155 */                   if (theUid.equals(Uid.nullUid())) {
/* 156 */                     endOfUids = true; continue;
/*     */                   }
/* 158 */                   String newTypeString = new String(theName);
/* 159 */                   Uid newUid = new Uid(theUid);
/* 160 */                   this._uncommittedTOTable.put(newUid, newTypeString);
/* 161 */                   if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */                   {
/* 163 */                     txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_4", new Object[] { newUid, newTypeString });
/*     */                   }
/*     */ 
/*     */                 }
/*     */ 
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 185 */           if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */           {
/* 187 */             txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_5", e);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 194 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */       {
/* 196 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_5", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void periodicWorkSecondPass()
/*     */   {
/* 204 */     if (txojLogger.aitLoggerI18N.isInfoEnabled())
/*     */     {
/* 206 */       txojLogger.aitLoggerI18N.info("com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_6");
/*     */     }
/*     */ 
/* 209 */     Enumeration uncommittedObjects = this._uncommittedTOTable.keys();
/*     */ 
/* 211 */     while (uncommittedObjects.hasMoreElements())
/*     */     {
/* 213 */       Uid objUid = (Uid)uncommittedObjects.nextElement();
/* 214 */       String objType = (String)this._uncommittedTOTable.get(objUid);
/*     */       try
/*     */       {
/* 218 */         if (_objectStore.currentState(objUid, objType) == 2)
/*     */         {
/* 220 */           recoverObject(objUid, objType);
/*     */         }
/* 223 */         else if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */         {
/* 225 */           txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_7", new Object[] { objUid, objType });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ObjectStoreException ose)
/*     */       {
/* 234 */         if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */         {
/* 236 */           txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.TORecoveryModule_8", new Object[] { objUid, objType });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initialise()
/*     */   {
/* 251 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 253 */       txojLogger.aitLogger.debug(16L, 2L, 2048L, "TORecoveryModule.initialise()");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void recoverObject(Uid objUid, String objType)
/*     */   {
/* 261 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 263 */       txojLogger.aitLogger.debug(16L, 1L, 2048L, "TORecoveryModule.recoverObject(" + objUid + ", " + objType + ")");
/*     */     }
/*     */ 
/* 274 */     RecoveredTransactionalObject recoveredTO = new RecoveredTransactionalObject(objUid, objType, _objectStore);
/*     */ 
/* 282 */     recoveredTO.replayPhase2();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.recovery.TORecoveryModule
 * JD-Core Version:    0.6.0
 */