/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.AtomicAction;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.transaction.InvalidTransactionException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ 
/*     */ public class TransactionManagerImple extends BaseTransaction
/*     */   implements TransactionManager, ObjectFactory
/*     */ {
/*     */   public Transaction getTransaction()
/*     */     throws SystemException
/*     */   {
/*  53 */     return TransactionImple.getTransaction();
/*     */   }
/*     */ 
/*     */   public Transaction suspend()
/*     */     throws SystemException
/*     */   {
/*  62 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  64 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImpleManager.suspend");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  72 */       TransactionImple tx = TransactionImple.getTransaction();
/*     */ 
/*  74 */       if (tx != null)
/*     */       {
/*  76 */         tx.getAtomicAction(); AtomicAction.suspend();
/*     */       }
/*     */ 
/*  79 */       return tx;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  83 */     throw new SystemException(e.toString());
/*     */   }
/*     */ 
/*     */   public void resume(Transaction which)
/*     */     throws InvalidTransactionException, IllegalStateException, SystemException
/*     */   {
/*  95 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  97 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImpleManager.resume");
/*     */     }
/*     */ 
/* 103 */     super.checkTransactionState();
/*     */ 
/* 110 */     if (which != null)
/*     */     {
/* 112 */       if ((which instanceof TransactionImple))
/*     */       {
/* 114 */         TransactionImple theTransaction = (TransactionImple)which;
/*     */         try
/*     */         {
/* 118 */           if (!AtomicAction.resume(theTransaction.getAtomicAction())) {
/* 119 */             throw new InvalidTransactionException();
/*     */           }
/* 121 */           theTransaction = null;
/*     */         }
/*     */         catch (Exception e2)
/*     */         {
/* 125 */           throw new SystemException();
/*     */         }
/*     */       }
/*     */       else {
/* 129 */         throw new InvalidTransactionException("Illegal type is: " + which);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 151 */     return this;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple
 * JD-Core Version:    0.6.0
 */