/*     */ package com.arjuna.ats.internal.jta.resources.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*     */ import com.arjuna.ats.jta.xa.XidImple;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.sql.SQLException;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class XAOnePhaseResource
/*     */   implements OnePhaseResource
/*     */ {
/*     */   private XAResource xaResource;
/*     */   private RecoverableXAConnection recoverableXAConnection;
/*     */   private Xid xid;
/*     */ 
/*     */   public XAOnePhaseResource()
/*     */   {
/*     */   }
/*     */ 
/*     */   public XAOnePhaseResource(XAResource xaResource, Xid xid, Object[] params)
/*     */   {
/*  92 */     this.xaResource = xaResource;
/*  93 */     this.xid = xid;
/*  94 */     if ((params != null) && (params.length >= 0))
/*     */     {
/*  96 */       Object param = params[0];
/*  97 */       if ((param instanceof RecoverableXAConnection))
/*  98 */         this.recoverableXAConnection = ((RecoverableXAConnection)param);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int commit()
/*     */   {
/*     */     try
/*     */     {
/* 110 */       this.xaResource.commit(this.xid, true);
/* 111 */       return 7;
/*     */     }
/*     */     catch (XAException xae)
/*     */     {
/* 115 */       if (jtaLogger.logger.isDebugEnabled())
/*     */       {
/* 117 */         jtaLogger.logger.debug(1024L, 4L, 1L, "XAOnePhaseResource.commit(" + this.xid + ") " + xae.getMessage());
/*     */       }
/*     */ 
/* 121 */       if ((xae.errorCode >= 100) && (xae.errorCode <= 107))
/*     */       {
/* 124 */         return 3;
/*     */       }
/*     */     }
/* 126 */     return 8;
/*     */   }
/*     */ 
/*     */   public int rollback()
/*     */   {
/*     */     try
/*     */     {
/* 138 */       this.xaResource.rollback(this.xid);
/* 139 */       return 7;
/*     */     }
/*     */     catch (XAException xae)
/*     */     {
/* 143 */       if (jtaLogger.logger.isWarnEnabled())
/*     */       {
/* 145 */         jtaLogger.logger.warn("XAOnePhaseResource.rollback(" + this.xid + ") " + xae.getMessage());
/*     */       }
/*     */     }
/* 147 */     return 8;
/*     */   }
/*     */ 
/*     */   public void pack(OutputObjectState os)
/*     */     throws IOException
/*     */   {
/* 161 */     XidImple.pack(os, this.xid);
/* 162 */     if (this.recoverableXAConnection != null)
/*     */     {
/* 164 */       os.packInt(0);
/* 165 */       os.packString(this.recoverableXAConnection.getClass().getName());
/*     */ 
/* 167 */       this.recoverableXAConnection.packInto(os);
/*     */     }
/*     */     else {
/* 171 */       os.packInt(1);
/*     */       byte[] data;
/*     */       try {
/* 175 */         ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 176 */         ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 177 */         oos.writeObject(this.xaResource);
/* 178 */         oos.flush();
/* 179 */         oos.close();
/* 180 */         data = baos.toByteArray();
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 184 */         String message = "XAOnePhaseResource.pack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.pack", new Object[] { ioe });
/*     */ 
/* 186 */         if (jtaLogger.logger.isWarnEnabled())
/*     */         {
/* 188 */           jtaLogger.logger.warn(message);
/*     */         }
/* 190 */         throw new IOException(message);
/*     */       }
/* 192 */       os.packBytes(data);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unpack(InputObjectState is)
/*     */     throws IOException
/*     */   {
/* 209 */     XidImple.unpack(is);
/* 210 */     int recoveryType = is.unpackInt();
/* 211 */     switch (recoveryType) {
/*     */     case 0:
/* 214 */       String recoverableXAConnectionClassName = is.unpackString();
/* 215 */       ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
/*     */       Class recoverableXAConnectionClass;
/*     */       try { recoverableXAConnectionClass = contextClassLoader.loadClass(recoverableXAConnectionClassName);
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/* 223 */         throw generateUnpackError(cnfe);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 228 */         this.recoverableXAConnection = ((RecoverableXAConnection)recoverableXAConnectionClass.newInstance());
/*     */       }
/*     */       catch (InstantiationException ie)
/*     */       {
/* 232 */         throw generateUnpackError(ie);
/*     */       }
/*     */       catch (IllegalAccessException iae)
/*     */       {
/* 236 */         throw generateUnpackError(iae);
/*     */       }
/*     */ 
/* 239 */       this.recoverableXAConnection.unpackFrom(is);
/*     */       try
/*     */       {
/* 242 */         this.xaResource = this.recoverableXAConnection.getResource();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 246 */         throw generateUnpackError(sqle);
/*     */       }
/*     */ 
/*     */     case 1:
/* 250 */       byte[] data = is.unpackBytes();
/*     */       try
/*     */       {
/* 253 */         ByteArrayInputStream bais = new ByteArrayInputStream(data);
/* 254 */         ObjectInputStream ois = new ObjectInputStream(bais);
/* 255 */         this.xaResource = ((XAResource)ois.readObject());
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/* 259 */         throw generateUnpackError(cnfe);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 263 */         throw generateUnpackError(ioe);
/*     */       }
/*     */       catch (ClassCastException cce)
/*     */       {
/* 267 */         throw generateUnpackError(cce);
/*     */       }
/*     */ 
/*     */     default:
/* 271 */       String message = "XAOnePhaseResource.unpack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpackType", new Object[] { new Integer(recoveryType) });
/*     */ 
/* 274 */       if (jtaLogger.logger.isWarnEnabled())
/*     */       {
/* 276 */         jtaLogger.logger.warn(message);
/*     */       }
/* 278 */       throw new IOException(message);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static IOException generateUnpackError(Exception ex)
/*     */   {
/* 289 */     String message = "XAOnePhaseResource.unpack() " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource.unpack", new Object[] { ex });
/*     */ 
/* 291 */     if (jtaLogger.logger.isWarnEnabled())
/*     */     {
/* 293 */       jtaLogger.logger.warn(message);
/*     */     }
/* 295 */     return new IOException(message);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource
 * JD-Core Version:    0.6.0
 */