/*     */ package com.arjuna.ats.internal.jta.resources.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.SynchronizationRecord;
/*     */ import com.arjuna.ats.internal.jta.utils.arjunacore.StatusConverter;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import javax.transaction.Synchronization;
/*     */ 
/*     */ public class SynchronizationImple
/*     */   implements SynchronizationRecord, Comparable
/*     */ {
/*     */   private Synchronization _theSynch;
/*     */   private Uid _theUid;
/*     */   private boolean _isInterposed;
/*     */ 
/*     */   public SynchronizationImple(Synchronization ptr)
/*     */   {
/*  76 */     this._theSynch = ptr;
/*  77 */     this._theUid = new Uid();
/*     */   }
/*     */ 
/*     */   public SynchronizationImple(Synchronization ptr, boolean isInterposed) {
/*  81 */     this._theSynch = ptr;
/*  82 */     this._theUid = new Uid();
/*  83 */     this._isInterposed = isInterposed;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  88 */     this._theSynch = null;
/*     */     try
/*     */     {
/*  92 */       super.finalize();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Uid get_uid()
/*     */   {
/* 101 */     return this._theUid;
/*     */   }
/*     */ 
/*     */   public boolean beforeCompletion()
/*     */   {
/* 106 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 108 */       jtaLogger.logger.debug(16L, 4L, 1L, "SynchronizationImple.beforeCompletion");
/*     */     }
/*     */ 
/* 112 */     if (this._theSynch != null)
/*     */     {
/* 114 */       this._theSynch.beforeCompletion();
/* 115 */       return true;
/*     */     }
/*     */ 
/* 119 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean afterCompletion(int status)
/*     */   {
/* 124 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 126 */       jtaLogger.logger.debug(16L, 4L, 1L, "SynchronizationImple.afterCompletion");
/*     */     }
/*     */ 
/* 130 */     if (this._theSynch != null)
/*     */     {
/* 132 */       int s = StatusConverter.convert(status);
/*     */       try
/*     */       {
/* 136 */         this._theSynch.afterCompletion(s);
/*     */ 
/* 138 */         return true;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 142 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 146 */     return false;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object object)
/*     */   {
/* 161 */     SynchronizationImple other = (SynchronizationImple)object;
/*     */ 
/* 163 */     if ((this._isInterposed) && (!other._isInterposed))
/*     */     {
/* 165 */       return 1;
/*     */     }
/* 167 */     if ((!this._isInterposed) && (other._isInterposed))
/*     */     {
/* 169 */       return -1;
/*     */     }
/* 171 */     if (this._theUid.equals(other._theUid))
/*     */     {
/* 173 */       return 0;
/*     */     }
/*     */ 
/* 177 */     return this._theUid.lessThan(other._theUid) ? -1 : 1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple
 * JD-Core Version:    0.6.0
 */