/*     */ package com.arjuna.ats.internal.jdbc.recovery;
/*     */ 
/*     */ import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.recovery.XAResourceRecovery;
/*     */ import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.sql.ConnectionEvent;
/*     */ import javax.sql.ConnectionEventListener;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import oracle.jdbc.xa.client.OracleXADataSource;
/*     */ 
/*     */ public class OracleXARecovery
/*     */   implements XAResourceRecovery
/*     */ {
/*     */   public static final String DATABASE_URL = "DatabaseURL";
/*     */   public static final String USER_NAME = "UserName";
/*     */   public static final String PASSWORD = "Password";
/*     */   private XAConnection _connection;
/*     */   private XADataSource _dataSource;
/*     */   private LocalConnectionEventListener _connectionEventListener;
/*     */   private Properties _props;
/*     */   private String _dbURL;
/*     */   private String _user;
/*     */   private String _password;
/*     */   private boolean _hasMoreResources;
/*     */ 
/*     */   public OracleXARecovery()
/*     */     throws SQLException
/*     */   {
/*  67 */     if (jdbcLogger.logger.isDebugEnabled()) {
/*  68 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery()");
/*     */     }
/*  70 */     this._props = null;
/*  71 */     this._hasMoreResources = false;
/*  72 */     this._connectionEventListener = new LocalConnectionEventListener(null);
/*     */   }
/*     */ 
/*     */   public boolean initialise(String parameter)
/*     */     throws SQLException
/*     */   {
/*  87 */     if (jdbcLogger.logger.isDebugEnabled()) {
/*  88 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery.initialise(" + parameter + ")");
/*     */     }
/*  90 */     if (parameter == null) {
/*  91 */       return false;
/*     */     }
/*     */     try
/*     */     {
/*  95 */       jdbcPropertyManager.propertyManager.load(XMLFilePlugin.class.getName(), parameter);
/*     */ 
/*  97 */       this._props = jdbcPropertyManager.propertyManager.getProperties();
/*     */ 
/*  99 */       this._dbURL = this._props.getProperty("DatabaseURL");
/* 100 */       this._user = this._props.getProperty("UserName");
/* 101 */       this._password = this._props.getProperty("Password");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 105 */       if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */       {
/* 107 */         jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.oracle.initexp", new Object[] { e });
/*     */ 
/* 109 */         e.printStackTrace();
/*     */       }
/*     */ 
/* 112 */       return false;
/*     */     }
/*     */ 
/* 115 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized XAResource getXAResource()
/*     */     throws SQLException
/*     */   {
/* 126 */     createConnection();
/*     */ 
/* 128 */     return this._connection.getXAResource();
/*     */   }
/*     */ 
/*     */   public boolean hasMoreResources()
/*     */   {
/* 133 */     if (this._dataSource == null) {
/*     */       try
/*     */       {
/* 136 */         createDataSource();
/*     */       }
/*     */       catch (SQLException sqlException)
/*     */       {
/* 140 */         return false;
/*     */       }
/*     */     }
/* 143 */     if (this._dataSource != null)
/*     */     {
/* 145 */       this._hasMoreResources = (!this._hasMoreResources);
/*     */ 
/* 147 */       return this._hasMoreResources;
/*     */     }
/*     */ 
/* 150 */     return false;
/*     */   }
/*     */ 
/*     */   private final void createDataSource()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 166 */       if (this._dataSource == null)
/*     */       {
/* 168 */         OracleXADataSource dataSource = new OracleXADataSource();
/* 169 */         dataSource.setURL(this._dbURL);
/*     */ 
/* 171 */         this._dataSource = dataSource;
/*     */ 
/* 173 */         if (this._dataSource == null)
/* 174 */           throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.oracle.recjndierror"));
/*     */       }
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 179 */       ex.printStackTrace();
/*     */ 
/* 181 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 185 */       e.printStackTrace();
/*     */ 
/* 187 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void createConnection()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 200 */       if (this._dataSource == null) {
/* 201 */         createDataSource();
/*     */       }
/* 203 */       if (this._connection == null)
/*     */       {
/* 205 */         if ((this._user == null) && (this._password == null))
/* 206 */           this._connection = this._dataSource.getXAConnection();
/*     */         else {
/* 208 */           this._connection = this._dataSource.getXAConnection(this._user, this._password);
/*     */         }
/* 210 */         this._connection.addConnectionEventListener(this._connectionEventListener);
/*     */       }
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 215 */       ex.printStackTrace();
/*     */ 
/* 217 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 221 */       e.printStackTrace();
/*     */ 
/* 223 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private class LocalConnectionEventListener implements ConnectionEventListener {
/*     */     private LocalConnectionEventListener() {
/*     */     }
/*     */ 
/*     */     public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
/* 231 */       OracleXARecovery.this._connection.removeConnectionEventListener(OracleXARecovery.this._connectionEventListener);
/* 232 */       OracleXARecovery.access$202(OracleXARecovery.this, null);
/*     */     }
/*     */ 
/*     */     public void connectionClosed(ConnectionEvent connectionEvent)
/*     */     {
/* 237 */       OracleXARecovery.this._connection.removeConnectionEventListener(OracleXARecovery.this._connectionEventListener);
/* 238 */       OracleXARecovery.access$202(OracleXARecovery.this, null);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.recovery.OracleXARecovery
 * JD-Core Version:    0.6.0
 */