/*     */ package com.arjuna.ats.internal.jdbc.recovery;
/*     */ 
/*     */ import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.recovery.XAResourceRecovery;
/*     */ import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.ConnectionEvent;
/*     */ import javax.sql.ConnectionEventListener;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import javax.transaction.xa.XAResource;
/*     */ 
/*     */ public class JDBCXARecovery
/*     */   implements XAResourceRecovery
/*     */ {
/*     */   public static final String DATABASE_JNDI_NAME = "DatabaseJNDIName";
/*     */   public static final String USER_NAME = "UserName";
/*     */   public static final String PASSWORD = "Password";
/*     */   private XAConnection _connection;
/*     */   private XADataSource _dataSource;
/*     */   private LocalConnectionEventListener _connectionEventListener;
/*     */   private Properties _props;
/*     */   private String _dbName;
/*     */   private String _user;
/*     */   private String _password;
/*     */   private boolean _hasMoreResources;
/*     */ 
/*     */   public JDBCXARecovery()
/*     */     throws SQLException
/*     */   {
/*  72 */     if (jdbcLogger.logger.isDebugEnabled()) {
/*  73 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery()");
/*     */     }
/*  75 */     this._props = null;
/*  76 */     this._hasMoreResources = false;
/*  77 */     this._connectionEventListener = new LocalConnectionEventListener(null);
/*     */   }
/*     */ 
/*     */   public boolean initialise(String parameter)
/*     */     throws SQLException
/*     */   {
/*  92 */     if (jdbcLogger.logger.isDebugEnabled()) {
/*  93 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "JDBCXARecovery.initialise(" + parameter + ")");
/*     */     }
/*  95 */     if (parameter == null) {
/*  96 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 100 */       jdbcPropertyManager.propertyManager.load(XMLFilePlugin.class.getName(), parameter);
/*     */ 
/* 102 */       this._props = jdbcPropertyManager.propertyManager.getProperties();
/*     */ 
/* 104 */       this._dbName = this._props.getProperty("DatabaseJNDIName");
/* 105 */       this._user = this._props.getProperty("UserName");
/* 106 */       this._password = this._props.getProperty("Password");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 110 */       if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */       {
/* 112 */         jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.xa.initexp", new Object[] { e });
/*     */ 
/* 114 */         e.printStackTrace();
/*     */       }
/*     */ 
/* 117 */       return false;
/*     */     }
/*     */ 
/* 120 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized XAResource getXAResource()
/*     */     throws SQLException
/*     */   {
/* 131 */     createConnection();
/*     */ 
/* 133 */     return this._connection.getXAResource();
/*     */   }
/*     */ 
/*     */   public boolean hasMoreResources()
/*     */   {
/* 138 */     if (this._dataSource == null) {
/*     */       try
/*     */       {
/* 141 */         createDataSource();
/*     */       }
/*     */       catch (SQLException sqlException)
/*     */       {
/* 145 */         return false;
/*     */       }
/*     */     }
/* 148 */     if (this._dataSource != null)
/*     */     {
/* 150 */       this._hasMoreResources = (!this._hasMoreResources);
/*     */ 
/* 152 */       return this._hasMoreResources;
/*     */     }
/*     */ 
/* 155 */     return false;
/*     */   }
/*     */ 
/*     */   private final void createDataSource()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 171 */       if (this._dataSource == null)
/*     */       {
/* 173 */         Context context = new InitialContext();
/* 174 */         this._dataSource = ((XADataSource)context.lookup(this._dbName));
/*     */ 
/* 176 */         if (this._dataSource == null)
/* 177 */           throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.xa.recjndierror"));
/*     */       }
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 182 */       ex.printStackTrace();
/*     */ 
/* 184 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 188 */       e.printStackTrace();
/*     */ 
/* 190 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void createConnection()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 203 */       if (this._dataSource == null) {
/* 204 */         createDataSource();
/*     */       }
/* 206 */       if (this._connection == null)
/*     */       {
/* 208 */         if ((this._user == null) && (this._password == null))
/* 209 */           this._connection = this._dataSource.getXAConnection();
/*     */         else {
/* 211 */           this._connection = this._dataSource.getXAConnection(this._user, this._password);
/*     */         }
/* 213 */         this._connection.addConnectionEventListener(this._connectionEventListener);
/*     */       }
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 218 */       ex.printStackTrace();
/*     */ 
/* 220 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 224 */       e.printStackTrace();
/*     */ 
/* 226 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private class LocalConnectionEventListener implements ConnectionEventListener {
/*     */     private LocalConnectionEventListener() {
/*     */     }
/*     */ 
/*     */     public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
/* 234 */       JDBCXARecovery.this._connection.removeConnectionEventListener(JDBCXARecovery.this._connectionEventListener);
/* 235 */       JDBCXARecovery.access$202(JDBCXARecovery.this, null);
/*     */     }
/*     */ 
/*     */     public void connectionClosed(ConnectionEvent connectionEvent)
/*     */     {
/* 240 */       JDBCXARecovery.this._connection.removeConnectionEventListener(JDBCXARecovery.this._connectionEventListener);
/* 241 */       JDBCXARecovery.access$202(JDBCXARecovery.this, null);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.recovery.JDBCXARecovery
 * JD-Core Version:    0.6.0
 */