/*     */ package com.arjuna.ats.internal.jdbc.drivers.modifiers;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class ModifierFactory
/*     */ {
/*  98 */   private static Hashtable _modifiers = new Hashtable();
/*     */ 
/*     */   public static synchronized void putModifier(String dbName, int major, int minor, String modclass)
/*     */   {
/*     */     try
/*     */     {
/*  57 */       Object mod = Thread.currentThread().getContextClassLoader().loadClass(modclass).newInstance();
/*  58 */       _modifiers.put(dbName + "_" + major + "_" + minor, mod);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public static synchronized Object getModifier(String dbName, int major, int minor)
/*     */   {
/*  69 */     String exactMatch = null;
/*  70 */     String majorMatch = null;
/*  71 */     String driverMatch = null;
/*  72 */     Enumeration e = _modifiers.keys();
/*     */ 
/*  74 */     dbName = dbName.toLowerCase();
/*     */ 
/*  76 */     while (e.hasMoreElements())
/*     */     {
/*  78 */       String s = (String)e.nextElement();
/*     */ 
/*  80 */       if (s.equalsIgnoreCase(dbName + "_" + major + "_" + minor))
/*  81 */         exactMatch = s;
/*  82 */       if (s.equalsIgnoreCase(dbName + "_" + major + "_-1"))
/*  83 */         majorMatch = s;
/*  84 */       if (s.equalsIgnoreCase(dbName + "_-1_-1")) {
/*  85 */         driverMatch = s;
/*     */       }
/*     */     }
/*  88 */     if (exactMatch != null)
/*  89 */       return _modifiers.get(exactMatch);
/*  90 */     if (majorMatch != null)
/*  91 */       return _modifiers.get(majorMatch);
/*  92 */     if (driverMatch != null) {
/*  93 */       return _modifiers.get(driverMatch);
/*     */     }
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 102 */     Object o = new list();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.drivers.modifiers.ModifierFactory
 * JD-Core Version:    0.6.0
 */