/*     */ package com.arjuna.ats.internal.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
/*     */ import com.arjuna.ats.internal.jdbc.drivers.modifiers.jndi;
/*     */ import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.xa.XAResource;
/*     */ 
/*     */ public class IndirectRecoverableConnection
/*     */   implements RecoverableXAConnection, ConnectionControl
/*     */ {
/*     */   private String _dbName;
/*     */   private String _user;
/*     */   private String _passwd;
/*     */   private XAConnection _theConnection;
/*     */   private XADataSource _theDataSource;
/*     */   private XAResource _theXAResource;
/*     */   private Transaction _theTransaction;
/*     */   private ConnectionImple _theArjunaConnection;
/*     */   private ConnectionModifier _theModifier;
/*     */ 
/*     */   public IndirectRecoverableConnection()
/*     */     throws SQLException
/*     */   {
/*  72 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  74 */       jdbcLogger.logger.debug(1L, 4L, 1L, "IndirectRecoverableConnection.IndirectRecoverableConnection ()");
/*     */     }
/*     */ 
/*  78 */     this._dbName = null;
/*  79 */     this._user = null;
/*  80 */     this._passwd = null;
/*  81 */     this._theConnection = null;
/*  82 */     this._theDataSource = null;
/*  83 */     this._theXAResource = null;
/*  84 */     this._theTransaction = null;
/*  85 */     this._theArjunaConnection = null;
/*     */ 
/*  95 */     jndi jndiModifier = new jndi();
/*     */ 
/*  97 */     this._dbName = jndiModifier.initialise(this._dbName);
/*  98 */     this._theModifier = null;
/*     */ 
/* 100 */     createDataSource();
/*     */   }
/*     */ 
/*     */   public IndirectRecoverableConnection(String dbName, String user, String passwd, ConnectionImple conn)
/*     */     throws SQLException
/*     */   {
/* 107 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 109 */       jdbcLogger.logger.debug(1L, 4L, 1L, "IndirectRecoverableConnection.IndirectRecoverableConnection ( " + dbName + ", " + user + ", " + passwd + " )");
/*     */     }
/*     */ 
/* 113 */     this._dbName = dbName;
/* 114 */     this._user = user;
/* 115 */     this._passwd = passwd;
/* 116 */     this._theConnection = null;
/* 117 */     this._theDataSource = null;
/* 118 */     this._theXAResource = null;
/* 119 */     this._theTransaction = null;
/* 120 */     this._theArjunaConnection = conn;
/*     */ 
/* 128 */     jndi jndiModifier = new jndi();
/*     */ 
/* 130 */     this._dbName = jndiModifier.initialise(this._dbName);
/* 131 */     this._theModifier = null;
/*     */ 
/* 133 */     createDataSource();
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*     */     try
/*     */     {
/* 144 */       if (this._theConnection != null)
/*     */       {
/* 146 */         this._theConnection.close();
/* 147 */         this._theConnection = null;
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 152 */       if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */       {
/* 154 */         jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.drcdest", new Object[] { e });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean packInto(OutputObjectState os)
/*     */   {
/* 162 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 164 */       jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.packInto ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 170 */       os.packString(this._dbName);
/* 171 */       os.packString(this._user);
/* 172 */       os.packString(this._passwd);
/*     */ 
/* 174 */       return true;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 178 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean unpackFrom(InputObjectState os)
/*     */   {
/* 184 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 186 */       jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.unpackFrom ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 192 */       this._dbName = os.unpackString();
/* 193 */       this._user = os.unpackString();
/* 194 */       this._passwd = os.unpackString();
/*     */ 
/* 196 */       return true;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 200 */     return false;
/*     */   }
/*     */ 
/*     */   public String getDatabaseName()
/*     */   {
/* 206 */     return this._dbName;
/*     */   }
/*     */ 
/*     */   public XAResource getResource() throws SQLException
/*     */   {
/* 211 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 213 */       jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getResource ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 219 */       if (this._theXAResource == null) {
/* 220 */         this._theXAResource = getConnection().getXAResource();
/*     */       }
/* 222 */       return this._theXAResource;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 226 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   public final void close()
/*     */   {
/* 236 */     reset();
/*     */ 
/* 238 */     synchronized (this)
/*     */     {
/* 240 */       if (this._theConnection != null)
/*     */       {
/* 242 */         this._theArjunaConnection.reset();
/*     */       }
/*     */ 
/* 247 */       if (this._theModifier != null)
/*     */       {
/*     */         try
/*     */         {
/* 251 */           this._theConnection = this._theModifier.getConnection(this._theConnection);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 255 */           this._theConnection = null;
/*     */         }
/*     */       }
/*     */       else
/* 259 */         this._theConnection = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final void reset()
/*     */   {
/* 265 */     this._theXAResource = null;
/* 266 */     this._theTransaction = null;
/*     */   }
/*     */ 
/*     */   public boolean setTransaction(Transaction tx)
/*     */   {
/* 271 */     synchronized (this)
/*     */     {
/* 273 */       if (this._theTransaction == null)
/*     */       {
/* 275 */         this._theTransaction = tx;
/*     */ 
/* 277 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 285 */     return validTransaction(tx);
/*     */   }
/*     */ 
/*     */   public boolean validTransaction(Transaction tx)
/*     */   {
/* 290 */     boolean valid = true;
/*     */ 
/* 292 */     if (this._theTransaction != null) {
/* 293 */       valid = this._theTransaction.equals(tx);
/*     */     }
/* 295 */     return valid;
/*     */   }
/*     */ 
/*     */   public XAConnection getCurrentConnection()
/*     */     throws SQLException
/*     */   {
/* 305 */     return this._theConnection;
/*     */   }
/*     */ 
/*     */   public XAConnection getConnection() throws SQLException
/*     */   {
/* 310 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 312 */       jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getConnection ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 318 */       synchronized (this)
/*     */       {
/* 320 */         if (this._theConnection == null)
/*     */         {
/* 322 */           createConnection();
/*     */         }
/*     */       }
/*     */ 
/* 326 */       return this._theConnection;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 330 */       e.printStackTrace();
/*     */     }
/* 332 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   public XADataSource getDataSource()
/*     */     throws SQLException
/*     */   {
/* 338 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 340 */       jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getDataSource ()");
/*     */     }
/*     */ 
/* 344 */     return this._theDataSource;
/*     */   }
/*     */ 
/*     */   public boolean inuse()
/*     */   {
/* 349 */     return this._theXAResource != null;
/*     */   }
/*     */ 
/*     */   public String user()
/*     */   {
/* 354 */     return this._user;
/*     */   }
/*     */ 
/*     */   public String password()
/*     */   {
/* 359 */     return this._passwd;
/*     */   }
/*     */ 
/*     */   public String url()
/*     */   {
/* 364 */     return this._dbName;
/*     */   }
/*     */ 
/*     */   public String dynamicClass()
/*     */   {
/* 369 */     return "";
/*     */   }
/*     */ 
/*     */   public String dataSourceName()
/*     */   {
/* 374 */     if (this._theDataSource != null) {
/* 375 */       return this._theDataSource.toString();
/*     */     }
/* 377 */     return "";
/*     */   }
/*     */ 
/*     */   public Transaction transaction()
/*     */   {
/* 382 */     return this._theTransaction;
/*     */   }
/*     */ 
/*     */   public void setModifier(ConnectionModifier cm)
/*     */   {
/* 387 */     this._theModifier = cm;
/*     */ 
/* 389 */     if (this._theModifier != null)
/* 390 */       this._dbName = this._theModifier.initialise(this._dbName);
/*     */   }
/*     */ 
/*     */   private final void createDataSource()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 401 */       if (this._theDataSource == null)
/*     */       {
/* 403 */         Hashtable env = new Hashtable();
/* 404 */         Enumeration e = jdbcPropertyManager.propertyManager.propertyNames();
/*     */ 
/* 411 */         while (e.hasMoreElements())
/*     */         {
/* 413 */           String name = (String)e.nextElement();
/*     */ 
/* 415 */           if (name.startsWith("Context.")) {
/* 416 */             env.put(translate(name), jdbcPropertyManager.propertyManager.getProperty(name));
/*     */           }
/*     */         }
/* 419 */         if (env.size() > 0)
/*     */         {
/* 421 */           Context ctx = new InitialContext(env);
/* 422 */           this._theDataSource = ((XADataSource)ctx.lookup(this._dbName));
/*     */         }
/*     */         else {
/* 425 */           this._theDataSource = null;
/*     */         }
/* 427 */         if (this._theDataSource == null)
/* 428 */           throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.jndierror"));
/*     */       }
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 433 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 437 */       e.printStackTrace();
/*     */ 
/* 439 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void createConnection() throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 447 */       if (this._theDataSource == null) {
/* 448 */         createDataSource();
/*     */       }
/* 450 */       if ((this._user == null) && (this._passwd == null))
/* 451 */         this._theConnection = this._theDataSource.getXAConnection();
/*     */       else
/* 453 */         this._theConnection = this._theDataSource.getXAConnection(this._user, this._passwd);
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 457 */       throw ex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 461 */       e.printStackTrace();
/*     */ 
/* 463 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private final String translate(String name)
/*     */   {
/*     */     try
/*     */     {
/* 480 */       if (name.equals("Context.APPLET"))
/* 481 */         return "java.naming.applet";
/* 482 */       if (name.equals("Context.AUTHORITATIVE"))
/* 483 */         return "java.naming.authoritative";
/* 484 */       if (name.equals("Context.BATCHSIZE"))
/* 485 */         return "java.naming.batchsize";
/* 486 */       if (name.equals("Context.DNS_URL"))
/* 487 */         return "java.naming.dns.url";
/* 488 */       if (name.equals("Context.INITIAL_CONTEXT_FACTORY"))
/* 489 */         return "java.naming.factory.initial";
/* 490 */       if (name.equals("Context.LANGUAGE"))
/* 491 */         return "java.naming.language";
/* 492 */       if (name.equals("Context.OBJECT_FACTORIES"))
/* 493 */         return "java.naming.factory.object";
/* 494 */       if (name.equals("Context.PROVIDER_URL"))
/* 495 */         return "java.naming.provider.url";
/* 496 */       if (name.equals("Context.REFERRAL"))
/* 497 */         return "java.naming.referral";
/* 498 */       if (name.equals("Context.SECURITY_AUTHENTICATION"))
/* 499 */         return "java.naming.security.authentication";
/* 500 */       if (name.equals("Context.SECURITY_CREDENTIALS"))
/* 501 */         return "java.naming.security.credentials";
/* 502 */       if (name.equals("Context.SECURITY_PRINCIPAL"))
/* 503 */         return "java.naming.security.principal";
/* 504 */       if (name.equals("Context.SECURITY_PROTOCOL"))
/* 505 */         return "java.naming.security.protocol";
/* 506 */       if (name.equals("Context.STATE_FACTORIES"))
/* 507 */         return "java.naming.factory.state";
/* 508 */       if (name.equals("Context.URL_PKG_PREFIXES")) {
/* 509 */         return "java.naming.factory.url.pkgs";
/*     */       }
/*     */     }
/*     */     catch (NullPointerException ex)
/*     */     {
/*     */     }
/*     */ 
/* 516 */     return name;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.IndirectRecoverableConnection
 * JD-Core Version:    0.6.0
 */