/*     */ package com.arjuna.ats.internal.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.xa.XAResource;
/*     */ 
/*     */ public class DirectRecoverableConnection
/*     */   implements RecoverableXAConnection, ConnectionControl
/*     */ {
/*     */   private String _dbName;
/*     */   private String _user;
/*     */   private String _passwd;
/*     */   private String _dynamic;
/*     */   private XAConnection _theConnection;
/*     */   private XADataSource _theDataSource;
/*     */   private DynamicClass _dynamicConnection;
/*     */   private XAResource _theXAResource;
/*     */   private Transaction _theTransaction;
/*     */   private ConnectionImple _theArjunaConnection;
/*     */   private ConnectionModifier _theModifier;
/*     */ 
/*     */   public DirectRecoverableConnection()
/*     */     throws SQLException
/*     */   {
/*  70 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  72 */       jdbcLogger.logger.debug(1L, 4L, 1L, "DirectRecoverableConnection.DirectRecoverableConnection()");
/*     */     }
/*     */ 
/*  76 */     this._dbName = null;
/*  77 */     this._user = null;
/*  78 */     this._passwd = null;
/*  79 */     this._dynamic = null;
/*  80 */     this._theConnection = null;
/*  81 */     this._theDataSource = null;
/*  82 */     this._dynamicConnection = null;
/*  83 */     this._theXAResource = null;
/*  84 */     this._theTransaction = null;
/*  85 */     this._theArjunaConnection = null;
/*  86 */     this._theModifier = null;
/*     */   }
/*     */ 
/*     */   public DirectRecoverableConnection(String dbName, String user, String passwd, String dynamic, ConnectionImple conn)
/*     */     throws SQLException
/*     */   {
/*  93 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  95 */       jdbcLogger.logger.debug(1L, 4L, 1L, "DirectRecoverableConnection.DirectRecoverableConnection( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )");
/*     */     }
/*     */ 
/*  99 */     this._dbName = dbName;
/* 100 */     this._user = user;
/* 101 */     this._passwd = passwd;
/* 102 */     this._dynamic = dynamic;
/* 103 */     this._theConnection = null;
/* 104 */     this._theDataSource = null;
/* 105 */     this._dynamicConnection = null;
/* 106 */     this._theXAResource = null;
/* 107 */     this._theTransaction = null;
/* 108 */     this._theArjunaConnection = conn;
/* 109 */     this._theModifier = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*     */     try
/*     */     {
/* 120 */       if (this._theConnection != null)
/*     */       {
/* 122 */         this._theConnection.close();
/* 123 */         this._theConnection = null;
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 128 */       if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */       {
/* 130 */         jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.drcdest", new Object[] { e });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean packInto(OutputObjectState os)
/*     */   {
/* 138 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 140 */       jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.packInto ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 146 */       os.packString(this._dbName);
/* 147 */       os.packString(this._user);
/* 148 */       os.packString(this._passwd);
/* 149 */       os.packString(this._dynamic);
/*     */ 
/* 151 */       return true;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 155 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean unpackFrom(InputObjectState os)
/*     */   {
/* 161 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 163 */       jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.unpackFrom ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 169 */       this._dbName = os.unpackString();
/* 170 */       this._user = os.unpackString();
/* 171 */       this._passwd = os.unpackString();
/* 172 */       this._dynamic = os.unpackString();
/*     */ 
/* 174 */       return true;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 178 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean setTransaction(Transaction tx)
/*     */   {
/* 184 */     synchronized (this)
/*     */     {
/* 186 */       if (this._theTransaction == null)
/*     */       {
/* 188 */         this._theTransaction = tx;
/*     */ 
/* 190 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 198 */     return validTransaction(tx);
/*     */   }
/*     */ 
/*     */   public boolean validTransaction(Transaction tx)
/*     */   {
/* 203 */     boolean valid = true;
/*     */ 
/* 205 */     if (this._theTransaction != null) {
/* 206 */       valid = this._theTransaction.equals(tx);
/*     */     }
/* 208 */     return valid;
/*     */   }
/*     */ 
/*     */   public XAResource getResource()
/*     */     throws SQLException
/*     */   {
/* 217 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 219 */       jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getResource ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 225 */       if (this._theXAResource == null) {
/* 226 */         this._theXAResource = getConnection().getXAResource();
/*     */       }
/* 228 */       return this._theXAResource;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 232 */       e.printStackTrace();
/*     */     }
/* 234 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   public final void close()
/*     */   {
/* 244 */     reset();
/*     */ 
/* 246 */     synchronized (this)
/*     */     {
/* 248 */       if (this._theConnection != null)
/*     */       {
/* 250 */         this._theArjunaConnection.reset();
/*     */       }
/*     */ 
/* 255 */       if (this._theModifier != null)
/*     */       {
/*     */         try
/*     */         {
/* 259 */           this._theConnection = this._theModifier.getConnection(this._theConnection);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 263 */           this._theConnection = null;
/*     */         }
/*     */       }
/*     */       else
/* 267 */         this._theConnection = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final void reset()
/*     */   {
/* 273 */     this._theXAResource = null;
/* 274 */     this._theTransaction = null;
/*     */   }
/*     */ 
/*     */   public XAConnection getCurrentConnection()
/*     */     throws SQLException
/*     */   {
/* 284 */     return this._theConnection;
/*     */   }
/*     */ 
/*     */   public XAConnection getConnection() throws SQLException
/*     */   {
/* 289 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 291 */       jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getConnection ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 297 */       synchronized (this)
/*     */       {
/* 299 */         if (this._theConnection == null)
/*     */         {
/* 301 */           createConnection();
/*     */         }
/*     */       }
/*     */ 
/* 305 */       return this._theConnection;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 309 */       e.printStackTrace();
/*     */     }
/* 311 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   public XADataSource getDataSource()
/*     */     throws SQLException
/*     */   {
/* 317 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 319 */       jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getDataSource ()");
/*     */     }
/*     */ 
/* 323 */     return this._theDataSource;
/*     */   }
/*     */ 
/*     */   public boolean inuse()
/*     */   {
/* 328 */     return this._theXAResource != null;
/*     */   }
/*     */ 
/*     */   public String user()
/*     */   {
/* 333 */     return this._user;
/*     */   }
/*     */ 
/*     */   public String password()
/*     */   {
/* 338 */     return this._passwd;
/*     */   }
/*     */ 
/*     */   public String url()
/*     */   {
/* 343 */     return this._dbName;
/*     */   }
/*     */ 
/*     */   public String dynamicClass()
/*     */   {
/* 348 */     return this._dynamic;
/*     */   }
/*     */ 
/*     */   public String dataSourceName()
/*     */   {
/* 353 */     return this._dbName;
/*     */   }
/*     */ 
/*     */   public Transaction transaction()
/*     */   {
/* 358 */     return this._theTransaction;
/*     */   }
/*     */ 
/*     */   public void setModifier(ConnectionModifier cm)
/*     */   {
/* 363 */     this._theModifier = cm;
/*     */ 
/* 365 */     if (this._theModifier != null)
/* 366 */       this._dbName = this._theModifier.initialise(this._dbName);
/*     */   }
/*     */ 
/*     */   private final void createConnection()
/*     */     throws SQLException
/*     */   {
/* 375 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 377 */       jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection.createConnection");
/*     */     }
/*     */ 
/* 381 */     if ((this._dynamic == null) || (this._dynamic.equals("")))
/*     */     {
/* 383 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.dynamicerror"));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 389 */       if (this._theDataSource == null)
/*     */       {
/* 391 */         Class c = Thread.currentThread().getContextClassLoader().loadClass(this._dynamic);
/*     */ 
/* 393 */         this._dynamicConnection = ((DynamicClass)c.newInstance());
/* 394 */         this._theDataSource = this._dynamicConnection.getDataSource(this._dbName);
/*     */       }
/*     */ 
/* 397 */       if ((this._user == null) && (this._passwd == null))
/*     */       {
/* 399 */         if (jdbcLogger.logger.isDebugEnabled())
/*     */         {
/* 401 */           jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection - getting connection with no user");
/*     */         }
/*     */ 
/* 406 */         this._theConnection = this._theDataSource.getXAConnection();
/*     */       }
/*     */       else
/*     */       {
/* 410 */         if (jdbcLogger.logger.isDebugEnabled())
/*     */         {
/* 412 */           jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection - getting connection for user " + this._user);
/*     */         }
/*     */ 
/* 416 */         this._theConnection = this._theDataSource.getXAConnection(this._user, this._passwd);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 421 */       e.printStackTrace();
/*     */ 
/* 423 */       throw new SQLException(e.toString());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.DirectRecoverableConnection
 * JD-Core Version:    0.6.0
 */