/*     */ package com.arjuna.ats.internal.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ 
/*     */ public class ConnectionManager
/*     */ {
/* 160 */   private static Hashtable _connections = new Hashtable();
/*     */ 
/*     */   public static synchronized ConnectionImple create(String dbUrl, Properties info)
/*     */     throws SQLException
/*     */   {
/*  62 */     String user = info.getProperty("user");
/*  63 */     String passwd = info.getProperty("password");
/*  64 */     String dynamic = info.getProperty("DYNAMIC_CLASS");
/*  65 */     Enumeration e = _connections.elements();
/*  66 */     ConnectionImple conn = null;
/*     */ 
/*  68 */     if (dynamic == null) {
/*  69 */       dynamic = "";
/*     */     }
/*  71 */     while (e.hasMoreElements())
/*     */     {
/*  73 */       conn = (ConnectionImple)e.nextElement();
/*     */ 
/*  75 */       ConnectionControl connControl = conn.connectionControl();
/*  76 */       javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/*  77 */       Transaction tx2 = null;
/*     */ 
/*  79 */       Transaction tx1 = connControl.transaction();
/*     */       try
/*     */       {
/*  82 */         tx2 = tm.getTransaction();
/*     */       }
/*     */       catch (SystemException se)
/*     */       {
/*     */       }
/*     */ 
/*  90 */       if ((tx1 != null) && (tx1.equals(tx2)) && (connControl.url().equals(dbUrl)) && (connControl.user().equals(user)) && (connControl.password().equals(passwd)) && (connControl.dynamicClass().equals(dynamic)))
/*     */       {
/*     */         try
/*     */         {
/* 102 */           if (!conn.isClosed())
/*     */           {
/* 104 */             return conn;
/*     */           }
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 109 */           ex.printStackTrace();
/* 110 */           throw new SQLException(ex.getMessage());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 115 */     conn = null;
/* 116 */     if (System.getProperty("java.specification.version").equals("1.5"))
/*     */     {
/*     */       try
/*     */       {
/* 122 */         Class clazz = Class.forName("com.arjuna.ats.internal.jdbc.ConnectionImpleJDBC3");
/* 123 */         Constructor ctor = clazz.getConstructor(new Class[] { String.class, Properties.class });
/* 124 */         conn = (ConnectionImple)ctor.newInstance(new Object[] { dbUrl, info });
/*     */       }
/*     */       catch (Exception exception)
/*     */       {
/* 129 */         if (jdbcLogger.logger.isDebugEnabled())
/*     */         {
/* 131 */           jdbcLogger.logger.warn(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.nojdbc3") + ": " + e.toString());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 136 */     if (conn == null)
/*     */     {
/* 141 */       conn = new ConnectionImple(dbUrl, info);
/*     */     }
/*     */ 
/* 150 */     _connections.put(conn, conn);
/*     */ 
/* 152 */     return conn;
/*     */   }
/*     */ 
/*     */   public static synchronized void remove(ConnectionImple conn)
/*     */   {
/* 157 */     _connections.remove(conn);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.ConnectionManager
 * JD-Core Version:    0.6.0
 */