/*     */ package com.arjuna.ats.internal.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
/*     */ import com.arjuna.ats.internal.jdbc.drivers.modifiers.ModifierFactory;
/*     */ import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*     */ import com.arjuna.ats.jta.xa.XAModifier;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLWarning;
/*     */ import java.sql.Savepoint;
/*     */ import java.sql.Statement;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ 
/*     */ public class ConnectionImple
/*     */   implements Connection
/*     */ {
/*     */   private RecoverableXAConnection _recoveryConnection;
/*     */   private Object _theModifier;
/*     */   private Connection _theConnection;
/*     */   private static final int defaultIsolationLevel = 8;
/* 829 */   private static int _currentIsolationLevel = 8;
/*     */ 
/*     */   public ConnectionImple(String dbName, Properties info)
/*     */     throws SQLException
/*     */   {
/*  81 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  83 */       jdbcLogger.logger.debug(1L, 4L, 1L, "ConnectionImple.ConnectionImple ( " + dbName + " )");
/*     */     }
/*     */ 
/*  87 */     String user = null;
/*  88 */     String passwd = null;
/*  89 */     String dynamic = null;
/*     */ 
/*  91 */     if (info != null)
/*     */     {
/*  93 */       user = info.getProperty("user");
/*  94 */       passwd = info.getProperty("password");
/*  95 */       dynamic = info.getProperty("DYNAMIC_CLASS");
/*     */     }
/*     */ 
/*  98 */     if ((dynamic == null) || (dynamic.equals("")))
/*     */     {
/* 100 */       this._recoveryConnection = new IndirectRecoverableConnection(dbName, user, passwd, this);
/*     */     }
/*     */     else
/*     */     {
/* 104 */       this._recoveryConnection = new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
/*     */     }
/*     */ 
/* 111 */     this._theModifier = null;
/* 112 */     this._theConnection = null;
/*     */   }
/*     */ 
/*     */   public ConnectionImple(String dbName, String user, String passwd) throws SQLException
/*     */   {
/* 117 */     this(dbName, user, passwd, null);
/*     */   }
/*     */ 
/*     */   public ConnectionImple(String dbName, String user, String passwd, String dynamic) throws SQLException
/*     */   {
/* 122 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 124 */       jdbcLogger.logger.debug(1L, 4L, 1L, "ConnectionImple.ConnectionImple ( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )");
/*     */     }
/*     */ 
/* 128 */     if ((dynamic == null) || (dynamic.equals("")))
/*     */     {
/* 130 */       this._recoveryConnection = new IndirectRecoverableConnection(dbName, user, passwd, this);
/*     */     }
/*     */     else
/*     */     {
/* 134 */       this._recoveryConnection = new DirectRecoverableConnection(dbName, user, passwd, dynamic, this);
/*     */     }
/*     */ 
/* 141 */     this._theModifier = null;
/* 142 */     this._theConnection = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 147 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 149 */       jdbcLogger.logger.debug(2L, 4L, 1L, "ConnectionImple.finalize ()");
/*     */     }
/*     */ 
/* 153 */     this._recoveryConnection = null;
/* 154 */     this._theConnection = null;
/*     */   }
/*     */ 
/*     */   public Statement createStatement() throws SQLException
/*     */   {
/* 159 */     checkTransaction();
/*     */ 
/* 161 */     registerDatabase();
/*     */ 
/* 163 */     return getConnection().createStatement();
/*     */   }
/*     */ 
/*     */   public Statement createStatement(int rs, int rc) throws SQLException
/*     */   {
/* 168 */     checkTransaction();
/*     */ 
/* 170 */     registerDatabase();
/*     */ 
/* 172 */     return getConnection().createStatement(rs, rc);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql) throws SQLException
/*     */   {
/* 177 */     checkTransaction();
/*     */ 
/* 179 */     registerDatabase();
/*     */ 
/* 181 */     return getConnection().prepareStatement(sql);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int rs, int rc) throws SQLException
/*     */   {
/* 186 */     checkTransaction();
/*     */ 
/* 188 */     registerDatabase();
/*     */ 
/* 190 */     return getConnection().prepareStatement(sql, rs, rc);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql) throws SQLException
/*     */   {
/* 195 */     checkTransaction();
/*     */ 
/* 197 */     registerDatabase();
/*     */ 
/* 199 */     return getConnection().prepareCall(sql);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql, int rs, int rc) throws SQLException
/*     */   {
/* 204 */     checkTransaction();
/*     */ 
/* 206 */     registerDatabase();
/*     */ 
/* 208 */     return getConnection().prepareCall(sql, rs, rc);
/*     */   }
/*     */ 
/*     */   public String nativeSQL(String sql) throws SQLException
/*     */   {
/* 213 */     checkTransaction();
/*     */ 
/* 215 */     registerDatabase();
/*     */ 
/* 217 */     return getConnection().nativeSQL(sql);
/*     */   }
/*     */ 
/*     */   public Map getTypeMap() throws SQLException
/*     */   {
/* 222 */     return getConnection().getTypeMap();
/*     */   }
/*     */ 
/*     */   public void setTypeMap(Map map) throws SQLException
/*     */   {
/* 227 */     getConnection().setTypeMap(map);
/*     */   }
/*     */ 
/*     */   public void setAutoCommit(boolean autoCommit)
/*     */     throws SQLException
/*     */   {
/* 238 */     if (transactionRunning())
/*     */     {
/* 240 */       if (autoCommit) {
/* 241 */         throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.autocommit"));
/*     */       }
/*     */     }
/*     */     else
/* 245 */       getConnection().setAutoCommit(autoCommit);
/*     */   }
/*     */ 
/*     */   public boolean getAutoCommit()
/*     */     throws SQLException
/*     */   {
/* 251 */     return getConnection().getAutoCommit();
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws SQLException
/*     */   {
/* 265 */     if (transactionRunning())
/*     */     {
/* 267 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.commiterror"));
/*     */     }
/*     */ 
/* 270 */     getConnection().commit();
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws SQLException
/*     */   {
/* 279 */     if (transactionRunning())
/*     */     {
/* 281 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.aborterror"));
/*     */     }
/*     */ 
/* 284 */     getConnection().rollback();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 306 */       if (!this._recoveryConnection.inuse())
/*     */       {
/* 308 */         ConnectionManager.remove(this);
/*     */       }
/*     */ 
/* 315 */       javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/* 316 */       javax.transaction.Transaction tx = tm.getTransaction();
/*     */ 
/* 324 */       if (tx != null)
/*     */       {
/* 326 */         if (this._recoveryConnection.validTransaction(tx))
/*     */         {
/* 328 */           XAResource xares = this._recoveryConnection.getResource();
/*     */ 
/* 330 */           if (!tx.delistResource(xares, 67108864)) {
/* 331 */             throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.delisterror"));
/*     */           }
/*     */ 
/* 337 */           getModifier();
/*     */ 
/* 339 */           if ((this._theModifier != null) && (((ConnectionModifier)this._theModifier).supportsMultipleConnections()))
/*     */           {
/* 341 */             tx.registerSynchronization(new ConnectionSynchronization(this._theConnection, this._recoveryConnection));
/* 342 */             this._theConnection = null;
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 348 */         this._recoveryConnection.close();
/* 349 */         this._theConnection = null;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IllegalStateException ex)
/*     */     {
/*     */     }
/*     */     catch (SQLException sqle)
/*     */     {
/* 360 */       throw sqle;
/*     */     }
/*     */     catch (Exception e1)
/*     */     {
/* 364 */       e1.printStackTrace();
/*     */ 
/* 366 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.closeerror") + e1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */     throws SQLException
/*     */   {
/* 377 */     checkTransaction();
/*     */ 
/* 379 */     if (this._theConnection == null) {
/* 380 */       return false;
/*     */     }
/* 382 */     return this._theConnection.isClosed();
/*     */   }
/*     */ 
/*     */   public DatabaseMetaData getMetaData() throws SQLException
/*     */   {
/* 387 */     return getConnection().getMetaData();
/*     */   }
/*     */ 
/*     */   public void setReadOnly(boolean ro)
/*     */     throws SQLException
/*     */   {
/* 399 */     if (!this._recoveryConnection.inuse())
/*     */     {
/* 401 */       getConnection().setReadOnly(ro);
/*     */     }
/*     */     else
/* 404 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setreadonly"));
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly() throws SQLException
/*     */   {
/* 409 */     return getConnection().isReadOnly();
/*     */   }
/*     */ 
/*     */   public void setCatalog(String cat) throws SQLException
/*     */   {
/* 414 */     checkTransaction();
/*     */ 
/* 416 */     registerDatabase();
/*     */ 
/* 418 */     getConnection().setCatalog(cat);
/*     */   }
/*     */ 
/*     */   public String getCatalog() throws SQLException
/*     */   {
/* 423 */     checkTransaction();
/*     */ 
/* 425 */     registerDatabase();
/*     */ 
/* 427 */     return getConnection().getCatalog();
/*     */   }
/*     */ 
/*     */   public void setTransactionIsolation(int iso)
/*     */     throws SQLException
/*     */   {
/* 436 */     checkTransaction();
/*     */ 
/* 443 */     getConnection().setTransactionIsolation(iso);
/*     */   }
/*     */ 
/*     */   public int getTransactionIsolation() throws SQLException
/*     */   {
/* 448 */     return getConnection().getTransactionIsolation();
/*     */   }
/*     */ 
/*     */   public SQLWarning getWarnings() throws SQLException
/*     */   {
/* 453 */     return getConnection().getWarnings();
/*     */   }
/*     */ 
/*     */   public void clearWarnings() throws SQLException
/*     */   {
/* 458 */     getConnection().clearWarnings();
/*     */   }
/*     */ 
/*     */   public final RecoverableXAConnection recoveryConnection()
/*     */   {
/* 468 */     return this._recoveryConnection;
/*     */   }
/*     */ 
/*     */   public void setHoldability(int holdability)
/*     */     throws SQLException
/*     */   {
/* 478 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public int getHoldability() throws SQLException {
/* 482 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint() throws SQLException {
/* 486 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint(String name) throws SQLException {
/* 490 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public void rollback(Savepoint savepoint) throws SQLException {
/* 494 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public void releaseSavepoint(Savepoint savepoint) throws SQLException {
/* 498 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException
/*     */   {
/* 503 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException
/*     */   {
/* 508 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException
/*     */   {
/* 513 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException
/*     */   {
/* 518 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException
/*     */   {
/* 523 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException
/*     */   {
/* 528 */     throw new SQLException("feature not supported");
/*     */   }
/*     */ 
/*     */   protected final XAResource getXAResource()
/*     */   {
/*     */     try
/*     */     {
/* 543 */       return this._recoveryConnection.getResource();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 547 */     return null;
/*     */   }
/*     */ 
/*     */   final void reset()
/*     */   {
/*     */     try
/*     */     {
/* 561 */       if (this._theConnection != null)
/* 562 */         this._theConnection.close();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/* 569 */       this._theConnection = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   final Connection getConnection()
/*     */     throws SQLException
/*     */   {
/* 581 */     if (this._theConnection != null) {
/* 582 */       return this._theConnection;
/*     */     }
/* 584 */     XAConnection xaConn = this._recoveryConnection.getConnection();
/*     */ 
/* 586 */     if (xaConn != null)
/*     */     {
/* 588 */       this._theConnection = xaConn.getConnection();
/*     */       try
/*     */       {
/* 592 */         getModifier();
/*     */ 
/* 594 */         if (this._theModifier != null)
/*     */         {
/* 596 */           ((ConnectionModifier)this._theModifier).setIsolationLevel(this._theConnection, _currentIsolationLevel);
/*     */         }
/*     */       }
/*     */       catch (SQLException ex)
/*     */       {
/* 601 */         throw ex;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 605 */         if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 607 */           jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.isolationlevelfailset", new Object[] { "ConnectionImple.getConnection", e });
/*     */         }
/*     */ 
/* 611 */         throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.conniniterror") + ":" + e);
/*     */       }
/*     */ 
/* 614 */       return this._theConnection;
/*     */     }
/*     */ 
/* 617 */     return null;
/*     */   }
/*     */ 
/*     */   final ConnectionControl connectionControl()
/*     */   {
/* 622 */     return (ConnectionControl)this._recoveryConnection;
/*     */   }
/*     */ 
/*     */   protected final boolean transactionRunning()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 631 */       return com.arjuna.ats.jta.TransactionManager.transactionManager().getTransaction() != null;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 640 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   protected final synchronized void registerDatabase()
/*     */     throws SQLException
/*     */   {
/* 662 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 664 */       jdbcLogger.logger.debug(16L, 1L, 1L, "ConnectionImple.registerDatabase ()");
/*     */     }
/*     */ 
/* 668 */     Connection theConnection = getConnection();
/*     */ 
/* 670 */     if (theConnection != null)
/*     */     {
/* 672 */       XAResource xares = null;
/*     */       try
/*     */       {
/* 676 */         javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/* 677 */         javax.transaction.Transaction tx = tm.getTransaction();
/*     */ 
/* 679 */         if (tx == null) {
/* 680 */           return;
/*     */         }
/*     */ 
/* 686 */         if (!this._recoveryConnection.setTransaction(tx))
/* 687 */           throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.alreadyassociated"));
/*     */         Object[] params;
/* 691 */         if (this._theModifier != null)
/* 692 */           params = new Object[2];
/*     */         else {
/* 694 */           params = new Object[1];
/*     */         }
/* 696 */         params[0] = this._recoveryConnection;
/*     */ 
/* 698 */         if (this._theModifier != null) {
/* 699 */           params[1] = ((XAModifier)this._theModifier);
/*     */         }
/*     */ 
/* 705 */         xares = this._recoveryConnection.getResource();
/*     */ 
/* 707 */         if (!((com.arjuna.ats.jta.transaction.Transaction)tx).enlistResource(xares, params))
/*     */         {
/*     */           try
/*     */           {
/* 715 */             tx.setRollbackOnly();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 719 */             if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */             {
/* 721 */               jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.rollbackerror", new Object[] { "ConnectionImple.registerDatabase" });
/*     */             }
/*     */ 
/* 725 */             throw new SQLException(e.toString());
/*     */           }
/*     */ 
/* 728 */           throw new SQLException("ConnectionImple.registerDatabase - " + jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.enlistfailed"));
/*     */         }
/*     */ 
/* 731 */         Object[] params = null;
/* 732 */         xares = null;
/* 733 */         tx = null;
/* 734 */         tm = null;
/*     */       }
/*     */       catch (RollbackException e1)
/*     */       {
/* 738 */         throw new SQLException("ConnectionImple.registerDatabase - " + e1);
/*     */       }
/*     */       catch (SystemException e2)
/*     */       {
/* 742 */         throw new SQLException("ConnectionImple.registerDatabase - " + e2);
/*     */       }
/*     */       catch (SQLException e3)
/*     */       {
/* 746 */         throw e3;
/*     */       }
/*     */       catch (Exception e4)
/*     */       {
/* 750 */         throw new SQLException(e4.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void checkTransaction()
/*     */     throws SQLException
/*     */   {
/* 762 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 764 */       jdbcLogger.logger.debug(16L, 1L, 1L, "ConnectionImple.checkTransaction ()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 770 */       javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/* 771 */       javax.transaction.Transaction tx = tm.getTransaction();
/*     */ 
/* 773 */       if (tx == null) {
/* 774 */         return;
/*     */       }
/*     */ 
/* 780 */       if (!this._recoveryConnection.validTransaction(tx))
/* 781 */         throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.alreadyassociatedcheck"));
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 785 */       throw ex;
/*     */     }
/*     */     catch (Exception e3)
/*     */     {
/* 789 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.infoerror"));
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void getModifier()
/*     */   {
/* 799 */     if (this._theModifier == null)
/*     */     {
/*     */       try
/*     */       {
/* 803 */         DatabaseMetaData md = this._theConnection.getMetaData();
/*     */ 
/* 805 */         String name = md.getDriverName();
/* 806 */         int major = md.getDriverMajorVersion();
/* 807 */         int minor = md.getDriverMinorVersion();
/*     */ 
/* 809 */         this._theModifier = ModifierFactory.getModifier(name, major, minor);
/*     */ 
/* 811 */         ((ConnectionControl)this._recoveryConnection).setModifier((ConnectionModifier)this._theModifier);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 815 */         if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 817 */           jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.getmoderror", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 837 */     String isolationLevel = jdbcPropertyManager.propertyManager.getProperty("com.arjuna.ats.jdbc.isolationLevel");
/*     */ 
/* 839 */     if (isolationLevel != null)
/*     */     {
/* 841 */       if (isolationLevel.equals("TRANSACTION_READ_COMMITTED")) {
/* 842 */         _currentIsolationLevel = 2;
/* 843 */       } else if (isolationLevel.equals("TRANSACTION_READ_UNCOMMITTED")) {
/* 844 */         _currentIsolationLevel = 1;
/* 845 */       } else if (isolationLevel.equals("TRANSACTION_REPEATABLE_READ")) {
/* 846 */         _currentIsolationLevel = 4;
/* 847 */       } else if (isolationLevel.equals("TRANSACTION_SERIALIZABLE")) {
/* 848 */         _currentIsolationLevel = 8;
/*     */       }
/*     */       else {
/* 851 */         if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 853 */           jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.isolationerror", new Object[] { isolationLevel });
/*     */         }
/*     */ 
/* 857 */         _currentIsolationLevel = 8;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.ConnectionImple
 * JD-Core Version:    0.6.0
 */