/*     */ package com.arjuna.ats.internal.jbossatx.jta.jca;
/*     */ 
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxWorkManager;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.WorkSynchronization;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
/*     */ import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkCompletedException;
/*     */ import javax.transaction.InvalidTransactionException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.tm.JBossXATerminator;
/*     */ import org.jboss.util.UnexpectedThrowable;
/*     */ 
/*     */ public class XATerminator extends XATerminatorImple
/*     */   implements JBossXATerminator
/*     */ {
/*     */   public void registerWork(Work work, Xid xid, long timeout)
/*     */     throws WorkCompletedException
/*     */   {
/*     */     try
/*     */     {
/* 108 */       TransactionImple tx = TxImporter.importTransaction(xid, (int)timeout);
/*     */ 
/* 110 */       switch (tx.getStatus())
/*     */       {
/*     */       case 5:
/*     */       case 6:
/* 114 */         throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.inactive"), "3");
/*     */       case 0:
/* 118 */         break;
/*     */       default:
/* 120 */         throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.completing"), "2");
/*     */       }
/*     */ 
/* 125 */       TxWorkManager.addWork(work, tx);
/*     */ 
/* 138 */       tx.registerSynchronization(new WorkSynchronization(tx));
/*     */     }
/*     */     catch (WorkCompletedException ex)
/*     */     {
/* 142 */       throw ex;
/*     */     }
/*     */     catch (XAException ex)
/*     */     {
/* 146 */       throw new WorkCompletedException(ex);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 150 */       ex.printStackTrace();
/*     */ 
/* 152 */       throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknown"), "-1");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startWork(Work work, Xid xid)
/*     */     throws WorkCompletedException
/*     */   {
/*     */     try
/*     */     {
/* 174 */       TransactionImple tx = TxImporter.importTransaction(xid);
/*     */ 
/* 178 */       if (!TxWorkManager.getWork(tx).equals(work))
/*     */       {
/* 180 */         throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknownwork"), "-1");
/*     */       }
/*     */ 
/* 184 */       com.arjuna.ats.jta.TransactionManager.transactionManager().resume(tx);
/*     */     }
/*     */     catch (XAException ex)
/*     */     {
/* 188 */       throw new WorkCompletedException(ex);
/*     */     }
/*     */     catch (InvalidTransactionException ex)
/*     */     {
/* 192 */       throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.inactive"), "3");
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 198 */       throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknown"), "-1");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endWork(Work work, Xid xid)
/*     */   {
/*     */     try
/*     */     {
/* 217 */       TransactionImple tx = TxImporter.importTransaction(xid);
/*     */ 
/* 219 */       com.arjuna.ats.jta.TransactionManager.transactionManager().suspend();
/*     */ 
/* 221 */       TxWorkManager.removeWork(work, tx);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 225 */       throw new UnexpectedThrowable(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cancelWork(Work work, Xid xid)
/*     */   {
/*     */     try
/*     */     {
/* 241 */       TransactionImple tx = TxImporter.importTransaction(xid);
/*     */ 
/* 243 */       TxWorkManager.removeWork(work, tx);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 247 */       throw new UnexpectedThrowable(ex);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jbossatx.jta.jca.XATerminator
 * JD-Core Version:    0.6.0
 */