/*     */ package com.arjuna.ats.internal.arjuna.utils;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.xa.XID;
/*     */ 
/*     */ public class XATxConverter
/*     */ {
/*     */   public static final int FORMAT_ID = 131075;
/*     */   public static final char NODE_SEPARATOR = '-';
/*     */ 
/*     */   public static XID getXid(Uid uid, boolean branch)
/*     */     throws IllegalStateException
/*     */   {
/*  52 */     return getXid(uid, branch, 131075);
/*     */   }
/*     */ 
/*     */   public static XID getXid(Uid uid, boolean branch, int formatId) throws IllegalStateException
/*     */   {
/*  57 */     if (branch) {
/*  58 */       return getXid(uid, new Uid(), formatId);
/*     */     }
/*  60 */     return getXid(uid, Uid.nullUid(), formatId);
/*     */   }
/*     */ 
/*     */   public static XID getXid(Uid uid, Uid branch, int formatId) throws IllegalStateException
/*     */   {
/*  65 */     if (uid == null) {
/*  66 */       throw new IllegalStateException();
/*     */     }
/*  68 */     byte[] nodeName = TxControl.getXANodeName();
/*  69 */     String s = uid.stringForm();
/*  70 */     int uidLen = s.length() + nodeName.length + 1;
/*     */ 
/*  72 */     if (uidLen > 64)
/*     */     {
/*  74 */       throw new IllegalStateException();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  80 */       XID xid = new XID();
/*     */ 
/*  82 */       xid.formatID = formatId;
/*  83 */       xid.gtrid_length = uidLen;
/*     */ 
/*  89 */       System.arraycopy(nodeName, 0, xid.data, 0, nodeName.length);
/*     */ 
/*  91 */       xid.data[nodeName.length] = 45;
/*     */ 
/*  93 */       byte[] b = s.getBytes();
/*     */ 
/*  99 */       System.arraycopy(b, 0, xid.data, nodeName.length + 1, b.length);
/*     */ 
/* 101 */       if (branch.notEquals(Uid.nullUid()))
/*     */       {
/* 103 */         String bs = branch.stringForm();
/* 104 */         int bsLen = bs.length();
/*     */ 
/* 106 */         b = bs.getBytes();
/*     */ 
/* 108 */         if (bsLen > 64) {
/* 109 */           throw new IllegalStateException();
/*     */         }
/*     */ 
/* 112 */         xid.bqual_length = bsLen;
/*     */ 
/* 114 */         System.arraycopy(b, 0, xid.data, xid.gtrid_length, bsLen);
/*     */ 
/* 117 */         bs = null;
/*     */       }
/*     */       else
/*     */       {
/* 129 */         xid.data[xid.gtrid_length] = 0;
/* 130 */         xid.bqual_length = 64;
/*     */       }
/*     */ 
/* 133 */       b = null;
/* 134 */       s = null;
/*     */ 
/* 136 */       return xid;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 140 */       e.printStackTrace();
/*     */     }
/* 142 */     throw new IllegalStateException(e.toString());
/*     */   }
/*     */ 
/*     */   public static Uid getUid(XID xid)
/*     */   {
/* 149 */     if (xid == null) {
/* 150 */       return Uid.nullUid();
/*     */     }
/* 152 */     if ((xid.formatID == -1) || (xid.gtrid_length <= 0)) {
/* 153 */       return Uid.nullUid();
/*     */     }
/*     */ 
/* 156 */     int nodeNameIndex = 0;
/*     */ 
/* 158 */     for (int i = 0; i < xid.gtrid_length; i++)
/*     */     {
/* 160 */       if (xid.data[i] != 45)
/*     */         continue;
/* 162 */       nodeNameIndex = i + 1;
/* 163 */       break;
/*     */     }
/*     */ 
/* 167 */     byte[] buff = new byte[xid.gtrid_length - nodeNameIndex];
/*     */ 
/* 169 */     System.arraycopy(xid.data, nodeNameIndex, buff, 0, buff.length);
/*     */ 
/* 171 */     Uid tx = new Uid(new String(buff), true);
/*     */ 
/* 173 */     buff = null;
/*     */ 
/* 175 */     return tx;
/*     */   }
/*     */ 
/*     */   public static Uid getBranch(XID xid)
/*     */   {
/* 181 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.utils.XATxConverter
 * JD-Core Version:    0.6.0
 */