/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.Service;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ 
/*     */ public class Listener extends Thread
/*     */ {
/*     */   private ServerSocket _listener_socket;
/*     */   private int _listener_port;
/* 164 */   private boolean _stop_listener = false;
/*     */ 
/* 167 */   private int _listener_socket_timeout_in_msecs = 1500;
/*     */   private Service _listener_service;
/* 172 */   private static boolean setTimeout = false;
/*     */ 
/*     */   public Listener(int port, Service service)
/*     */     throws IOException
/*     */   {
/*  56 */     super("Listener:" + port);
/*     */ 
/*  58 */     this._listener_port = port;
/*  59 */     this._listener_service = service;
/*     */ 
/*  61 */     this._listener_socket = new ServerSocket(this._listener_port);
/*     */ 
/*  63 */     if (setTimeout)
/*  64 */       this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
/*     */   }
/*     */ 
/*     */   public Listener(ServerSocket serverSocket, Service service)
/*     */     throws IOException
/*     */   {
/*  75 */     super("Listener:" + serverSocket.getLocalPort());
/*     */ 
/*  77 */     this._listener_port = serverSocket.getLocalPort();
/*  78 */     this._listener_service = service;
/*     */ 
/*  80 */     this._listener_socket = serverSocket;
/*     */ 
/*  82 */     if (setTimeout)
/*  83 */       this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  94 */     stopListener();
/*     */     try
/*     */     {
/*  98 */       this._listener_socket.close();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 102 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.Listener_1");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 115 */     while (!this._stop_listener)
/*     */     {
/*     */       try
/*     */       {
/* 119 */         Socket conn = this._listener_socket.accept();
/*     */ 
/* 121 */         Connection new_conn = new Connection(conn, this._listener_service);
/*     */ 
/* 123 */         if (tsLogger.arjLogger.debugAllowed())
/*     */         {
/* 125 */           tsLogger.arjLogger.debug(16L, 4L, 2048L, "Connected to " + conn.getInetAddress().getHostAddress() + " on port " + conn.getPort() + " on listener port " + conn.getLocalPort() + " for service " + this._listener_service.getClass().getName());
/*     */         }
/*     */ 
/* 135 */         new_conn.start();
/*     */       }
/*     */       catch (InterruptedIOException ex)
/*     */       {
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 143 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 144 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.Listener_2");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stopListener()
/*     */   {
/* 155 */     this._stop_listener = true;
/* 156 */     interrupt();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 176 */     String timeoutSocket = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.recovery.listener.timeoutsocket", "NO");
/*     */ 
/* 178 */     if (timeoutSocket.equals("YES"))
/*     */     {
/* 180 */       setTimeout = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.Listener
 * JD-Core Version:    0.6.0
 */