/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class ExpiredEntryMonitor extends Thread
/*     */ {
/* 350 */   private static boolean _started = false;
/*     */ 
/* 352 */   private static Vector _expiryScanners = new Vector();
/*     */ 
/* 354 */   private static int _scanIntervalSeconds = 43200;
/*     */ 
/* 356 */   private static SimpleDateFormat _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
/*     */ 
/* 358 */   private static boolean notSkipping = true;
/*     */ 
/* 360 */   private static ExpiredEntryMonitor _theInstance = null;
/*     */ 
/*     */   public static boolean startUp()
/*     */   {
/*  82 */     if (_started)
/*     */     {
/*  84 */       return false;
/*     */     }
/*     */ 
/*  91 */     String scanIntervalString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.expiryScanInterval");
/*     */ 
/*  94 */     if (scanIntervalString != null)
/*     */     {
/*     */       try
/*     */       {
/*  98 */         Integer scanIntervalInteger = new Integer(scanIntervalString);
/*     */ 
/* 100 */         _scanIntervalSeconds = scanIntervalInteger.intValue() * 60 * 60;
/*     */ 
/* 102 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 104 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_1", new Object[] { Integer.toString(_scanIntervalSeconds) });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 112 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 114 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_11", new Object[] { "com.arjuna.ats.arjuna.recovery.expiryScanInterval", scanIntervalString });
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 121 */     if (_scanIntervalSeconds == 0)
/*     */     {
/* 125 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */       {
/* 127 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_2");
/*     */       }
/*     */ 
/* 132 */       return false;
/*     */     }
/*     */ 
/* 136 */     if (_scanIntervalSeconds < 0)
/*     */     {
/* 138 */       notSkipping = false;
/* 139 */       _scanIntervalSeconds = -_scanIntervalSeconds;
/*     */     }
/*     */ 
/* 142 */     loadScanners();
/*     */ 
/* 144 */     if (_expiryScanners.size() == 0)
/*     */     {
/* 148 */       if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */       {
/* 150 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_3");
/*     */       }
/*     */ 
/* 155 */       return false;
/*     */     }
/*     */ 
/* 159 */     _theInstance = new ExpiredEntryMonitor();
/*     */ 
/* 161 */     return _started;
/*     */   }
/*     */ 
/*     */   public static void shutdown()
/*     */   {
/* 166 */     _started = false;
/* 167 */     _expiryScanners = new Vector();
/* 168 */     _scanIntervalSeconds = 43200;
/* 169 */     notSkipping = true;
/*     */ 
/* 171 */     _theInstance.interrupt();
/* 172 */     _theInstance = null;
/*     */   }
/*     */ 
/*     */   private ExpiredEntryMonitor()
/*     */   {
/* 177 */     if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */     {
/* 179 */       tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_4");
/*     */     }
/*     */ 
/* 184 */     _started = true;
/*     */ 
/* 186 */     setDaemon(true);
/*     */ 
/* 188 */     start();
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     while (true)
/*     */     {
/* 198 */       if (tsLogger.arjLogger.isInfoEnabled())
/*     */       {
/* 200 */         tsLogger.arjLogger.info("\n  --- ExpiredEntryMonitor ----" + _theTimestamper.format(new Date()) + "----");
/*     */       }
/*     */ 
/* 204 */       if (notSkipping)
/*     */       {
/* 206 */         Enumeration scanners = _expiryScanners.elements();
/*     */ 
/* 208 */         while (scanners.hasMoreElements())
/*     */         {
/* 210 */           ExpiryScanner m = (ExpiryScanner)scanners.nextElement();
/*     */ 
/* 212 */           m.scan();
/*     */ 
/* 214 */           if (tsLogger.arjLogger.isDebugEnabled())
/*     */           {
/* 216 */             tsLogger.arjLogger.debug(16L, 4L, 2048L, "  ");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 224 */         if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */         {
/* 226 */           tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_5");
/*     */         }
/*     */ 
/* 229 */         notSkipping = true;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 237 */         Thread.sleep(_scanIntervalSeconds * 1000);
/*     */       }
/*     */       catch (InterruptedException e1)
/*     */       {
/* 241 */         break;
/*     */       }
/*     */ 
/* 244 */       if (!_started)
/* 245 */         return;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadScanners()
/*     */   {
/* 252 */     Properties properties = arjPropertyManager.propertyManager.getProperties();
/*     */ 
/* 254 */     if (properties != null)
/*     */     {
/* 256 */       Enumeration names = properties.propertyNames();
/*     */ 
/* 258 */       while (names.hasMoreElements())
/*     */       {
/* 260 */         String propertyName = (String)names.nextElement();
/*     */ 
/* 262 */         if (propertyName.startsWith("com.arjuna.ats.arjuna.recovery.expiryScanner"))
/*     */         {
/* 264 */           loadScanner(properties.getProperty(propertyName));
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadScanner(String className)
/*     */   {
/* 272 */     if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */     {
/* 274 */       tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[] { className });
/*     */     }
/*     */ 
/* 280 */     if (className == null)
/*     */     {
/* 282 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 283 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_7");
/*     */       }
/* 285 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 291 */       Class c = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */       try
/*     */       {
/* 295 */         ExpiryScanner m = (ExpiryScanner)c.newInstance();
/*     */ 
/* 297 */         if (m.toBeUsed())
/*     */         {
/* 299 */           _expiryScanners.add(m);
/*     */         }
/* 303 */         else if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */         {
/* 305 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_8", new Object[] { className });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 314 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 316 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_9", new Object[] { className });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IllegalAccessException e1)
/*     */       {
/* 322 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 324 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[] { e1 });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (InstantiationException e2)
/*     */       {
/* 330 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 332 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_6", new Object[] { e2 });
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 337 */       c = null;
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 341 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 343 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor_10", new Object[] { className });
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor
 * JD-Core Version:    0.6.0
 */