/*    */ package com.arjuna.ats.internal.arjuna.recovery;
/*    */ 
/*    */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*    */ import com.arjuna.ats.arjuna.recovery.Service;
/*    */ import com.arjuna.common.util.logging.Logi18n;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.OutputStream;
/*    */ import java.net.InetAddress;
/*    */ import java.net.Socket;
/*    */ import java.net.SocketException;
/*    */ 
/*    */ public class Connection extends Thread
/*    */ {
/*    */   private Socket _server_socket;
/*    */   private Service _service;
/*    */ 
/*    */   public Connection(Socket server_socket, Service service)
/*    */   {
/* 52 */     super("Server.Connection:" + server_socket.getInetAddress().getHostAddress() + ":" + server_socket.getPort());
/*    */ 
/* 54 */     this._server_socket = server_socket;
/*    */     try
/*    */     {
/* 58 */       this._server_socket.setSoTimeout(0);
/*    */     }
/*    */     catch (SocketException ex)
/*    */     {
/* 62 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 63 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.Connection_2");
/*    */       }
/*    */     }
/* 66 */     this._service = service;
/*    */   }
/*    */ 
/*    */   public void run()
/*    */   {
/*    */     try
/*    */     {
/* 80 */       InputStream is = this._server_socket.getInputStream();
/* 81 */       OutputStream os = this._server_socket.getOutputStream();
/*    */ 
/* 83 */       this._service.doWork(is, os);
/*    */     }
/*    */     catch (IOException ex)
/*    */     {
/* 87 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 88 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.Connection_1");
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.Connection
 * JD-Core Version:    0.6.0
 */