/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.AtomicAction;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.ActionStatus;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoverAtomicAction;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*     */ import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class AtomicActionRecoveryModule
/*     */   implements RecoveryModule
/*     */ {
/* 309 */   private String _transactionType = new AtomicAction().type();
/*     */ 
/* 313 */   private Vector _transactionUidVector = null;
/*     */ 
/* 316 */   private static ObjectStore _transactionStore = null;
/*     */   private TransactionStatusConnectionManager _transactionStatusConnectionMgr;
/*     */ 
/*     */   public AtomicActionRecoveryModule()
/*     */   {
/*  68 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/*  70 */       tsLogger.arjLogger.debug(1L, 4L, 2048L, "AtomicActionRecoveryModule created");
/*     */     }
/*     */ 
/*  77 */     if (_transactionStore == null)
/*     */     {
/*  79 */       _transactionStore = TxControl.getStore();
/*     */     }
/*     */ 
/*  82 */     this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
/*     */   }
/*     */ 
/*     */   public void periodicWorkFirstPass()
/*     */   {
/*  91 */     boolean AtomicActions = false;
/*     */ 
/*  94 */     InputObjectState aa_uids = new InputObjectState();
/*     */     try
/*     */     {
/*  98 */       if (tsLogger.arjLogger.isInfoEnabled())
/*     */       {
/* 100 */         tsLogger.arjLogger.info("StatusModule: first pass ");
/*     */       }
/*     */ 
/* 103 */       AtomicActions = _transactionStore.allObjUids(this._transactionType, aa_uids);
/*     */     }
/*     */     catch (ObjectStoreException ex)
/*     */     {
/* 108 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 110 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_1", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 115 */     if (AtomicActions)
/*     */     {
/* 117 */       this._transactionUidVector = processTransactions(aa_uids);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void periodicWorkSecondPass()
/*     */   {
/* 123 */     if (tsLogger.arjLogger.isInfoEnabled())
/*     */     {
/* 125 */       tsLogger.arjLogger.info("AtomicActionRecoveryModule: Second pass ");
/*     */     }
/*     */ 
/* 128 */     processTransactionsStatus();
/*     */   }
/*     */ 
/*     */   protected AtomicActionRecoveryModule(String type)
/*     */   {
/* 133 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/* 135 */       tsLogger.arjLogger.debug(1L, 4L, 2048L, "AtomicActionRecoveryModule created");
/*     */     }
/*     */ 
/* 142 */     if (_transactionStore == null)
/*     */     {
/* 144 */       _transactionStore = TxControl.getStore();
/*     */     }
/*     */ 
/* 147 */     this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
/* 148 */     this._transactionType = type;
/*     */   }
/*     */ 
/*     */   private void doRecoverTransaction(Uid recoverUid)
/*     */   {
/* 154 */     boolean commitThisTransaction = true;
/*     */ 
/* 157 */     int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
/*     */ 
/* 159 */     boolean inFlight = isTransactionInMidFlight(theStatus);
/*     */ 
/* 161 */     String Status = ActionStatus.stringForm(theStatus);
/*     */ 
/* 163 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/* 165 */       tsLogger.arjLogger.debug(16L, 4L, 2048L, "transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status + " in flight is " + inFlight);
/*     */     }
/*     */ 
/* 174 */     if (!inFlight)
/*     */     {
/*     */       try
/*     */       {
/* 178 */         RecoverAtomicAction rcvAtomicAction = new RecoverAtomicAction(recoverUid, theStatus);
/*     */ 
/* 181 */         rcvAtomicAction.replayPhase2();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 185 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 187 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_2", new Object[] { recoverUid.toString(), ex });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isTransactionInMidFlight(int status)
/*     */   {
/* 196 */     boolean inFlight = false;
/*     */ 
/* 198 */     switch (status)
/*     */     {
/*     */     case 0:
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */     case 5:
/*     */     case 6:
/* 207 */       inFlight = true;
/* 208 */       break;
/*     */     case 4:
/*     */     case 7:
/*     */     case 11:
/*     */     case 12:
/*     */     case 13:
/*     */     case 14:
/* 218 */       inFlight = false;
/* 219 */       break;
/*     */     case 8:
/*     */     case 9:
/*     */     case 10:
/*     */     default:
/* 224 */       inFlight = false;
/*     */     }
/*     */ 
/* 227 */     return inFlight;
/*     */   }
/*     */ 
/*     */   private Vector processTransactions(InputObjectState uids)
/*     */   {
/* 232 */     Vector uidVector = new Vector();
/*     */ 
/* 234 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/* 236 */       tsLogger.arjLogger.debug(16L, 4L, 2048L, "processing " + this._transactionType + " transactions");
/*     */     }
/*     */ 
/* 243 */     Uid theUid = new Uid(Uid.nullUid());
/*     */ 
/* 245 */     boolean moreUids = true;
/*     */ 
/* 247 */     while (moreUids)
/*     */     {
/*     */       try
/*     */       {
/* 251 */         theUid.unpack(uids);
/*     */ 
/* 253 */         if (theUid.equals(Uid.nullUid()))
/*     */         {
/* 255 */           moreUids = false;
/*     */         }
/*     */         else
/*     */         {
/* 259 */           Uid newUid = new Uid(theUid);
/*     */ 
/* 261 */           if (tsLogger.arjLogger.isDebugEnabled())
/*     */           {
/* 263 */             tsLogger.arjLogger.debug(16L, 4L, 2048L, "found transaction " + newUid);
/*     */           }
/*     */ 
/* 270 */           uidVector.addElement(newUid);
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 275 */         moreUids = false;
/*     */       }
/*     */     }
/* 278 */     return uidVector;
/*     */   }
/*     */ 
/*     */   private void processTransactionsStatus()
/*     */   {
/* 284 */     Enumeration transactionUidEnum = this._transactionUidVector.elements();
/*     */ 
/* 286 */     while (transactionUidEnum.hasMoreElements())
/*     */     {
/* 288 */       Uid currentUid = (Uid)transactionUidEnum.nextElement();
/*     */       try
/*     */       {
/* 292 */         if (_transactionStore.currentState(currentUid, this._transactionType) != 0)
/*     */         {
/* 294 */           doRecoverTransaction(currentUid);
/*     */         }
/*     */       }
/*     */       catch (ObjectStoreException ex)
/*     */       {
/* 299 */         if (tsLogger.arjLogger.isWarnEnabled())
/*     */         {
/* 301 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule_3", new Object[] { currentUid.toString(), ex });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule
 * JD-Core Version:    0.6.0
 */