/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
/*     */ import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.sql.Connection;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.util.HashMap;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class JDBCStore extends ObjectStoreImple
/*     */ {
/*     */   protected boolean _isValid;
/*     */   protected JDBCImple _theImple;
/*     */   private JDBCAccess _jdbcAccess;
/*     */   private String _jdbcAccessClassName;
/*     */   private String _jdbcTableName;
/* 892 */   private static String _defaultTableName = "JBossTSTable";
/*     */ 
/* 898 */   protected static final HashMap _theImples = new HashMap();
/*     */ 
/* 900 */   protected static final HashMap _theAccesses = new HashMap();
/*     */ 
/*     */   public String getStoreName()
/*     */   {
/*  91 */     if (storeValid()) {
/*  92 */       return getAccessClassName() + ":" + getTableName();
/*     */     }
/*  94 */     return "Invalid";
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  99 */     return 15;
/*     */   }
/*     */ 
/*     */   public boolean commit_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 105 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 107 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.commit_state(" + objUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 114 */     if (!storeValid()) {
/* 115 */       return false;
/*     */     }
/* 117 */     return this._theImple.commit_state(objUid, tName, getTableName());
/*     */   }
/*     */ 
/*     */   public boolean hide_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 123 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 125 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.hide_state(" + objUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 132 */     if (storeValid()) {
/* 133 */       return this._theImple.hide_state(objUid, tName, getTableName());
/*     */     }
/* 135 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean reveal_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 141 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 143 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.reveal_state(" + objUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 149 */     if (storeValid()) {
/* 150 */       return this._theImple.reveal_state(objUid, tName, getTableName());
/*     */     }
/* 152 */     return false;
/*     */   }
/*     */ 
/*     */   public int currentState(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 163 */     if (storeValid()) {
/* 164 */       return this._theImple.currentState(objUid, tName, getTableName());
/*     */     }
/* 166 */     return 0;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid storeUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 177 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 179 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.read_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 186 */     return read_state(storeUid, tName, 1);
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid storeUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 192 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 194 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.read_uncommitted(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 200 */     return read_state(storeUid, tName, 2);
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid storeUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 206 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 208 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.remove_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 214 */     return remove_state(storeUid, tName, 1);
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid storeUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 220 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 222 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.remove_uncommitted(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 228 */     return remove_state(storeUid, tName, 2);
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid storeUid, String tName, OutputObjectState state)
/*     */     throws ObjectStoreException
/*     */   {
/* 234 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 236 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.write_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 242 */     return write_state(storeUid, tName, state, 1);
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state)
/*     */     throws ObjectStoreException
/*     */   {
/* 248 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 250 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")");
/*     */     }
/*     */ 
/* 256 */     return write_state(storeUid, tName, state, 2);
/*     */   }
/*     */ 
/*     */   public final boolean storeValid()
/*     */   {
/* 261 */     return this._isValid;
/*     */   }
/*     */ 
/*     */   public boolean allObjUids(String tName, InputObjectState state, int match)
/*     */     throws ObjectStoreException
/*     */   {
/* 272 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 274 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
/*     */     }
/*     */ 
/* 280 */     if (storeValid()) {
/* 281 */       return this._theImple.allObjUids(tName, state, match, getTableName());
/*     */     }
/* 283 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean allTypes(InputObjectState foundTypes)
/*     */     throws ObjectStoreException
/*     */   {
/* 289 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 291 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.allTypes(" + foundTypes + ")");
/*     */     }
/*     */ 
/* 296 */     if (storeValid()) {
/* 297 */       return this._theImple.allTypes(foundTypes, getTableName());
/*     */     }
/* 299 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized void packInto(OutputBuffer buff) throws IOException
/*     */   {
/* 304 */     buff.packString(getAccessClassName());
/* 305 */     buff.packString(getTableName());
/*     */   }
/*     */ 
/*     */   public synchronized void unpackFrom(InputBuffer buff) throws IOException
/*     */   {
/* 310 */     setAccessClassName(buff.unpackString());
/* 311 */     setTableName(buff.unpackString());
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 316 */     return ArjunaNames.Implementation_ObjectStore_JDBCStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 321 */     return ArjunaNames.Implementation_ObjectStore_JDBCStore();
/*     */   }
/*     */ 
/*     */   protected InputObjectState read_state(Uid objUid, String tName, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 327 */     if (!storeValid()) {
/* 328 */       return null;
/*     */     }
/* 330 */     return this._theImple.read_state(objUid, tName, ft, getTableName());
/*     */   }
/*     */ 
/*     */   protected boolean remove_state(Uid objUid, String name, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 340 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 342 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "JDBCStore.remove_state(" + objUid + ", " + name + ", " + ObjectStore.stateTypeString(ft) + ")");
/*     */     }
/*     */ 
/* 349 */     if (!storeValid()) {
/* 350 */       return false;
/*     */     }
/* 352 */     return this._theImple.remove_state(objUid, name, ft, getTableName());
/*     */   }
/*     */ 
/*     */   protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int s)
/*     */     throws ObjectStoreException
/*     */   {
/* 358 */     if (!storeValid()) {
/* 359 */       return false;
/*     */     }
/* 361 */     return this._theImple.write_state(objUid, tName, state, s, getTableName());
/*     */   }
/*     */ 
/*     */   public static JDBCStore create()
/*     */   {
/* 367 */     return new JDBCStore();
/*     */   }
/*     */ 
/*     */   public static JDBCStore create(Object[] param)
/*     */   {
/* 372 */     if (param == null) {
/* 373 */       return null;
/*     */     }
/* 375 */     return new JDBCStore((String)param[0]);
/*     */   }
/*     */ 
/*     */   public static JDBCStore create(ObjectName param)
/*     */   {
/* 383 */     if (param == null) {
/* 384 */       return null;
/*     */     }
/* 386 */     return new JDBCStore(param);
/*     */   }
/*     */ 
/*     */   protected JDBCStore()
/*     */   {
/* 391 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 393 */       tsLogger.arjLogger.debug(1L, 4L, 16L, getClass().getName() + "()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 400 */       initialise("");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 404 */       throw new ObjectStoreError();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected JDBCStore(String tableName)
/*     */   {
/* 410 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 412 */       tsLogger.arjLogger.debug(1L, 4L, 16L, getClass().getName() + "(" + tableName + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 419 */       initialise(tableName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 423 */       throw new ObjectStoreError();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected JDBCStore(ObjectName objName)
/*     */   {
/* 429 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 431 */       tsLogger.arjLogger.debug(1L, 4L, 16L, getClass().getName() + "(" + objName + " )");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 438 */       parseObjectName(objName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 442 */       throw new ObjectStoreError();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getAccessClassName()
/*     */   {
/* 453 */     if (this._jdbcAccessClassName == null) {
/* 454 */       this._jdbcAccessClassName = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcUserDbAccess");
/*     */     }
/* 456 */     return this._jdbcAccessClassName;
/*     */   }
/*     */ 
/*     */   protected void setAccessClassName(String jdbcAccessClassName)
/*     */   {
/* 467 */     this._jdbcAccessClassName = jdbcAccessClassName;
/*     */   }
/*     */ 
/*     */   protected String getDefaultTableName()
/*     */   {
/* 477 */     return _defaultTableName;
/*     */   }
/*     */ 
/*     */   protected String getAccessClassNameFromObject(ObjectName objName)
/*     */     throws IOException
/*     */   {
/* 490 */     return objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.jdbcUserDbAccess");
/*     */   }
/*     */ 
/*     */   protected String getTableNameFromObject(ObjectName objName)
/*     */     throws IOException
/*     */   {
/* 503 */     return objName.getStringAttribute(ArjunaNames.Implementation_ObjectStore_JDBC_tableName());
/*     */   }
/*     */ 
/*     */   protected JDBCAccess getJDBCAccess()
/*     */   {
/* 514 */     return this._jdbcAccess;
/*     */   }
/*     */ 
/*     */   protected void setJDBCAccess(JDBCAccess jdbcAccess)
/*     */   {
/* 525 */     this._jdbcAccess = jdbcAccess;
/*     */   }
/*     */ 
/*     */   protected String getTableName()
/*     */   {
/* 535 */     return this._jdbcTableName;
/*     */   }
/*     */ 
/*     */   protected void setTableName(String tableName)
/*     */   {
/* 546 */     this._jdbcTableName = tableName;
/*     */   }
/*     */ 
/*     */   protected void initialise(String tableName) throws Exception
/*     */   {
/* 551 */     String jdbcAccessClassName = getAccessClassName();
/*     */ 
/* 553 */     if (jdbcAccessClassName == null)
/*     */     {
/* 555 */       if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
/* 556 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_5");
/*     */       }
/*     */ 
/* 559 */       throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_5"));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 566 */       setupStore(jdbcAccessClassName, tableName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 570 */       if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */       {
/* 572 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[] { getJDBCAccess(), getTableName() });
/*     */       }
/*     */ 
/* 578 */       throw e;
/*     */     }
/*     */ 
/* 581 */     this._isValid = true;
/*     */   }
/*     */ 
/*     */   protected void parseObjectName(ObjectName objName)
/*     */     throws Exception
/*     */   {
/* 589 */     if (objName == null)
/*     */     {
/* 591 */       if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */       {
/* 593 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_4", new Object[] { "null" });
/*     */       }
/*     */ 
/* 599 */       throw new Exception();
/*     */     }String jdbcAccessClassName;
/*     */     String tableName;
/*     */     try { jdbcAccessClassName = getAccessClassNameFromObject(objName);
/* 605 */       tableName = getTableNameFromObject(objName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 609 */       if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */       {
/* 611 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_4", new Object[] { objName });
/*     */       }
/*     */ 
/* 617 */       throw e;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 622 */       setupStore(jdbcAccessClassName, tableName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 626 */       if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */       {
/* 628 */         tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[] { getJDBCAccess(), getTableName() });
/*     */       }
/*     */ 
/* 634 */       throw e;
/*     */     }
/*     */ 
/* 637 */     this._isValid = true;
/*     */   }
/*     */ 
/*     */   protected void setupStore(String jdbcAccessClassName, String tableName)
/*     */     throws Exception
/*     */   {
/* 647 */     if ((jdbcAccessClassName == null) || (jdbcAccessClassName.length() == 0))
/* 648 */       throw new ObjectStoreException();
/*     */     JDBCAccess jdbcAccess;
/* 651 */     synchronized (_theAccesses)
/*     */     {
/* 653 */       Object jdbcAccessObject = _theAccesses.get(jdbcAccessClassName);
/*     */       JDBCAccess jdbcAccess;
/* 655 */       if (jdbcAccessObject != null)
/*     */       {
/* 657 */         jdbcAccess = (JDBCAccess)jdbcAccessObject;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 663 */           Class jdbcAccessClass = Thread.currentThread().getContextClassLoader().loadClass(jdbcAccessClassName);
/*     */ 
/* 666 */           jdbcAccess = (JDBCAccess)jdbcAccessClass.newInstance();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 670 */           if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */           {
/* 672 */             tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[] { ex, jdbcAccessClassName });
/*     */           }
/*     */ 
/* 678 */           throw ex;
/*     */         }
/* 680 */         _theAccesses.put(jdbcAccessClassName, jdbcAccess);
/*     */       }
/*     */     }
/* 683 */     setJDBCAccess(jdbcAccess);
/*     */     String impleTableName;
/*     */     String impleTableName;
/* 686 */     if ((tableName != null) && (tableName.length() > 0))
/*     */     {
/* 688 */       impleTableName = tableName;
/*     */     }
/*     */     else
/*     */     {
/* 692 */       String jdbcAccessTableName = jdbcAccess.tableName();
/*     */       String impleTableName;
/* 693 */       if ((jdbcAccessTableName != null) && (jdbcAccessTableName.length() > 0))
/*     */       {
/* 696 */         impleTableName = jdbcAccessTableName;
/*     */       }
/*     */       else
/*     */       {
/* 700 */         impleTableName = getDefaultTableName();
/*     */       }
/*     */     }
/*     */ 
/* 704 */     setTableName(impleTableName);
/*     */ 
/* 706 */     String impleKey = jdbcAccessClassName + ":" + impleTableName;
/*     */ 
/* 708 */     synchronized (_theImples)
/*     */     {
/* 710 */       Object currentImple = _theImples.get(impleKey);
/* 711 */       if (currentImple != null)
/*     */       {
/* 713 */         this._theImple = ((JDBCImple)currentImple);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*     */           Connection connection;
/*     */           try
/*     */           {
/* 726 */             connection = jdbcAccess.getConnection();
/*     */           }
/*     */           catch (SQLException sqle)
/*     */           {
/* 730 */             if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */             {
/* 732 */               tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[] { sqle, "getConnection()" });
/*     */             }
/*     */ 
/* 738 */             throw sqle;
/*     */           }
/*     */ 
/* 741 */           if (connection == null)
/*     */           {
/* 743 */             if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */             {
/* 745 */               tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[] { getJDBCAccess(), getTableName() });
/*     */             }
/*     */ 
/* 751 */             throw new SQLException("getConnection returned null");
/*     */           }
/* 753 */           boolean success = false;
/*     */           try {
/* 756 */             connection.setAutoCommit(true);
/*     */             JDBCImple jdbcImple;
/*     */             try {
/* 760 */               Class jdbcImpleClass = getJDBCClass(connection);
/* 761 */               jdbcImple = (JDBCImple)jdbcImpleClass.newInstance();
/*     */ 
/* 763 */               jdbcImple.setShareStatus(this.shareStatus);
/*     */             }
/*     */             catch (Exception ex)
/*     */             {
/* 767 */               if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */               {
/* 769 */                 tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[] { ex, getJDBCAccess() });
/*     */               }
/*     */ 
/* 775 */               throw ex;
/*     */             }
/*     */ 
/* 778 */             if (!jdbcImple.initialise(connection, jdbcAccess, impleTableName))
/*     */             {
/* 781 */               if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 782 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_3");
/*     */               }
/* 784 */               throw new ObjectStoreException();
/*     */             }
/*     */ 
/* 788 */             _theImples.put(impleKey, jdbcImple);
/* 789 */             this._theImple = jdbcImple;
/* 790 */             success = true;
/*     */           }
/*     */           finally
/*     */           {
/* 795 */             if (!success)
/*     */             {
/*     */               try
/*     */               {
/* 799 */                 connection.close();
/*     */               }
/*     */               catch (SQLException sqle)
/*     */               {
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 809 */           tsLogger.arjLogger.warn(e.toString());
/* 810 */           throw e;
/*     */         }
/*     */       }
/* 813 */       this._isValid = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Class getJDBCClass(Connection conn)
/*     */     throws ClassNotFoundException, SQLException
/*     */   {
/* 833 */     DatabaseMetaData md = conn.getMetaData();
/*     */ 
/* 835 */     String name = md.getDriverName();
/* 836 */     int major = md.getDriverMajorVersion();
/* 837 */     int minor = md.getDriverMinorVersion();
/*     */ 
/* 844 */     int index = name.indexOf(' ');
/*     */ 
/* 846 */     if (index != -1) {
/* 847 */       name = name.substring(0, index);
/*     */     }
/* 849 */     name = name.toLowerCase();
/*     */ 
/* 851 */     ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 853 */     String packageName = getClass().getPackage().getName() + ".jdbc.";
/*     */     try
/*     */     {
/* 856 */       return classLoader.loadClass(packageName + name + "_" + major + "_" + minor + "_driver");
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/*     */       try
/*     */       {
/* 864 */         return classLoader.loadClass(packageName + name + "_" + major + "_driver");
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/*     */       }
/*     */     }
/* 870 */     return classLoader.loadClass(packageName + name + "_driver");
/*     */   }
/*     */ 
/*     */   protected boolean supressEntry(String name)
/*     */   {
/* 875 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.JDBCStore
 * JD-Core Version:    0.6.0
 */