/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class HashedActionStore extends HashedStore
/*     */ {
/* 237 */   private static boolean checkSync = false;
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  80 */     return 17;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  85 */     return ArjunaNames.Implementation_ObjectStore_HashedActionStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/*  90 */     return ArjunaNames.Implementation_ObjectStore_HashedActionStore();
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create()
/*     */   {
/* 100 */     return new HashedActionStore("");
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(Object[] param)
/*     */   {
/* 109 */     if (param == null) {
/* 110 */       return null;
/*     */     }
/* 112 */     String location = (String)param[0];
/* 113 */     Integer shareStatus = (Integer)param[1];
/* 114 */     int ss = 14;
/*     */ 
/* 116 */     if (shareStatus != null)
/*     */     {
/*     */       try
/*     */       {
/* 120 */         if (shareStatus.intValue() == 13)
/* 121 */           ss = 13;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 125 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 127 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedActionStore_1", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 133 */     return new HashedActionStore(location, ss);
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(ObjectName param)
/*     */   {
/* 138 */     if (param == null) {
/* 139 */       return null;
/*     */     }
/* 141 */     return new HashedActionStore(param);
/*     */   }
/*     */ 
/*     */   protected HashedActionStore()
/*     */   {
/* 150 */     this(14);
/*     */   }
/*     */ 
/*     */   protected HashedActionStore(int shareStatus)
/*     */   {
/* 155 */     super(shareStatus);
/*     */ 
/* 157 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 159 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore( " + shareStatus + " )");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected HashedActionStore(String locationOfStore)
/*     */   {
/* 167 */     this(locationOfStore, 14);
/*     */   }
/*     */ 
/*     */   protected HashedActionStore(String locationOfStore, int shareStatus)
/*     */   {
/* 172 */     super(shareStatus);
/*     */ 
/* 174 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 176 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore(" + locationOfStore + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 183 */       setupStore(locationOfStore);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 187 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 189 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected HashedActionStore(ObjectName objName)
/*     */   {
/* 195 */     super(objName);
/*     */ 
/* 197 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 199 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore( " + objName + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 205 */       setupStore("");
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 209 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 211 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized boolean setupStore(String location) throws ObjectStoreException
/*     */   {
/* 217 */     if (!checkSync)
/*     */     {
/* 219 */       String syncOpt = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.transactionSync");
/*     */ 
/* 221 */       if (syncOpt != null)
/*     */       {
/* 223 */         if (syncOpt.equals("OFF"))
/* 224 */           syncOff();
/*     */         else
/* 226 */           syncOn();
/*     */       }
/*     */       else {
/* 229 */         syncOn();
/*     */       }
/* 231 */       checkSync = true;
/*     */     }
/*     */ 
/* 234 */     return super.setupStore(location);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.HashedActionStore
 * JD-Core Version:    0.6.0
 */