/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.util.LinkedList;
/*     */ import java.util.NoSuchElementException;
/*     */ 
/*     */ class AsyncStore extends Thread
/*     */ {
/*     */   public static final int NO_WORK = -1;
/*     */   public static final int COMMIT = 0;
/*     */   public static final int REMOVE = 1;
/*     */   public static final int WRITE = 2;
/*     */   public static final int IN_USE = 0;
/*     */   public static final int REMOVED = 1;
/*     */   public static final int NOT_PRESENT = 2;
/* 891 */   public Object _activeLock = new Object();
/*     */ 
/* 893 */   private LinkedList[] _workList = null;
/* 894 */   private int _numberOfEntries = 0;
/* 895 */   private boolean _terminated = false;
/* 896 */   private int _currentCacheSize = 0;
/* 897 */   private int _maximumCacheSize = 0;
/* 898 */   private int _maximumWorkItems = 0;
/* 899 */   private int _maximumRemovedItems = 0;
/* 900 */   private int _scanPeriod = 0;
/* 901 */   private Object _overflowLock = new Object();
/* 902 */   private StoreElement _work = null;
/* 903 */   private int _removedItems = 0;
/*     */ 
/* 905 */   private static int HASH_SIZE = 128;
/*     */ 
/* 907 */   private static int _defaultCacheSize = 10240;
/* 908 */   private static int _defaultRemovedItems = 2 * HASH_SIZE;
/* 909 */   private static int _defaultWorkItems = 100;
/* 910 */   private static int _defaultScanPeriod = 120000;
/*     */ 
/*     */   public AsyncStore()
/*     */   {
/* 381 */     super("AsyncStoreThread");
/*     */ 
/* 383 */     this._maximumCacheSize = _defaultCacheSize;
/* 384 */     this._maximumWorkItems = _defaultWorkItems;
/* 385 */     this._maximumRemovedItems = _defaultRemovedItems;
/* 386 */     this._scanPeriod = _defaultScanPeriod;
/*     */ 
/* 388 */     this._workList = new LinkedList[HASH_SIZE];
/*     */ 
/* 390 */     setDaemon(true);
/*     */ 
/* 392 */     Runtime.getRuntime().addShutdownHook(new ShutdownThread());
/*     */ 
/* 394 */     start();
/*     */   }
/*     */ 
/*     */   public final void flush()
/*     */   {
/* 404 */     boolean stop = false;
/*     */     do
/*     */     {
/* 408 */       synchronized (this._workList)
/*     */       {
/* 410 */         stop = this._numberOfEntries <= 0;
/*     */       }
/*     */ 
/* 413 */       if (stop)
/*     */         continue;
/* 415 */       doWork();
/*     */     }
/*     */ 
/* 418 */     while (!stop);
/*     */ 
/* 420 */     this._terminated = true;
/*     */   }
/*     */ 
/*     */   public final boolean addWork(CacheStore store, int workType, Uid objUid, String tName, OutputObjectState state, int ft)
/*     */   {
/* 434 */     boolean stop = false;
/*     */     do
/*     */     {
/* 438 */       synchronized (this._overflowLock)
/*     */       {
/* 440 */         if (cacheIsFull())
/*     */         {
/*     */           try
/*     */           {
/* 444 */             this._overflowLock.wait();
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*     */           }
/*     */         }
/*     */         else
/* 451 */           stop = true;
/*     */       }
/*     */     }
/* 454 */     while (!stop);
/*     */ 
/* 456 */     StoreElement toAdd = new StoreElement(store, workType, objUid, tName, state, ft);
/*     */ 
/* 458 */     getList(objUid).addFirst(toAdd);
/*     */ 
/* 460 */     synchronized (this._workList)
/*     */     {
/* 462 */       if (state != null) {
/* 463 */         this._currentCacheSize += state.size();
/*     */       }
/* 465 */       this._numberOfEntries += 1;
/*     */     }
/*     */ 
/* 468 */     return true;
/*     */   }
/*     */ 
/*     */   public final int removeState(Uid objUid, int ft)
/*     */   {
/* 482 */     Object[] elements = null;
/*     */     try
/*     */     {
/* 490 */       elements = getList(objUid).toArray();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 494 */       elements = null;
/*     */     }
/*     */ 
/* 497 */     if (elements == null) {
/* 498 */       return 2;
/*     */     }
/* 500 */     int status = 2;
/*     */ 
/* 502 */     for (int i = 0; i < elements.length; i++)
/*     */     {
/* 504 */       StoreElement element = (StoreElement)elements[i];
/*     */ 
/* 506 */       if ((element == null) || (element.removed) || (!element.objUid.equals(objUid)))
/*     */         continue;
/* 508 */       switch (element.typeOfWork)
/*     */       {
/*     */       case 1:
/* 511 */         element.remove();
/*     */ 
/* 513 */         synchronized (this._workList)
/*     */         {
/* 515 */           this._removedItems += 1;
/*     */         }
/*     */ 
/* 518 */         if (status == 0) continue;
/* 519 */         status = 1; break;
/*     */       case 2:
/* 525 */         synchronized (this._workList)
/*     */         {
/* 527 */           if (element.state != null) {
/* 528 */             this._currentCacheSize -= element.state.size();
/*     */           }
/* 530 */           this._removedItems += 1;
/*     */         }
/*     */ 
/* 533 */         element.remove();
/*     */ 
/* 535 */         if (status == 0) continue;
/* 536 */         status = 1;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 550 */     if (CacheStore._storeManager.currentWork(objUid, ft))
/*     */     {
/* 552 */       status = 0;
/*     */     }
/*     */ 
/* 555 */     return status;
/*     */   }
/*     */ 
/*     */   public final int removeWriteState(Uid objUid, int ft)
/*     */   {
/* 560 */     int status = 2;
/* 561 */     Object[] elements = null;
/*     */     try
/*     */     {
/* 565 */       elements = getList(objUid).toArray();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 569 */       elements = null;
/*     */     }
/*     */ 
/* 572 */     if (elements == null) {
/* 573 */       return status;
/*     */     }
/* 575 */     for (int i = 0; i < elements.length; i++)
/*     */     {
/* 577 */       StoreElement element = (StoreElement)elements[i];
/*     */ 
/* 579 */       if ((element == null) || (element.removed) || (!element.objUid.equals(objUid)))
/*     */         continue;
/* 581 */       switch (element.typeOfWork)
/*     */       {
/*     */       case 2:
/* 584 */         if (ft == element.fileType)
/*     */         {
/* 586 */           synchronized (this._workList)
/*     */           {
/* 588 */             if (element.state != null) {
/* 589 */               this._currentCacheSize -= element.state.size();
/*     */             }
/* 591 */             this._removedItems += 1;
/*     */           }
/*     */ 
/* 594 */           element.remove();
/*     */ 
/* 596 */           status = 1;
/*     */         }
/*     */         else
/*     */         {
/* 600 */           if (ft != 11)
/*     */             continue;
/* 602 */           if (element.fileType != 10)
/*     */             continue;
/* 604 */           synchronized (this._workList)
/*     */           {
/* 606 */             if (element.state != null) {
/* 607 */               this._currentCacheSize -= element.state.size();
/*     */             }
/* 609 */             this._removedItems += 1;
/*     */           }
/*     */ 
/* 612 */           element.remove();
/*     */ 
/* 614 */           status = 1; } break;
/*     */       case 0:
/* 621 */         if (ft != 11)
/*     */           continue;
/* 623 */         synchronized (this._workList)
/*     */         {
/* 625 */           if (element.state != null) {
/* 626 */             this._currentCacheSize -= element.state.size();
/*     */           }
/* 628 */           this._removedItems += 1;
/*     */         }
/*     */ 
/* 631 */         element.remove();
/*     */ 
/* 633 */         status = 1;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 643 */     return status;
/*     */   }
/*     */ 
/*     */   public final OutputObjectState getState(Uid objUid, int ft)
/*     */   {
/* 648 */     LinkedList list = getList(objUid);
/*     */ 
/* 650 */     synchronized (list)
/*     */     {
/* 652 */       for (int i = 0; i < list.size(); i++)
/*     */       {
/* 654 */         StoreElement element = (StoreElement)list.get(i);
/*     */ 
/* 656 */         if (((element == null) || (element.removed) || (!element.objUid.equals(objUid))) || 
/* 658 */           (element.fileType == ft)) {
/* 659 */           return element.state;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 664 */     return null;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 669 */     synchronized (this._workList)
/*     */     {
/*     */       try
/*     */       {
/* 673 */         this._workList.wait();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 680 */     while (!this._terminated)
/*     */     {
/* 682 */       synchronized (this._activeLock)
/*     */       {
/* 684 */         while (!queueIsEmpty())
/*     */         {
/* 686 */           doWork();
/*     */         }
/*     */ 
/* 695 */         synchronized (this._overflowLock)
/*     */         {
/* 697 */           this._overflowLock.notifyAll();
/*     */         }
/*     */       }
/*     */ 
/* 701 */       synchronized (this._workList)
/*     */       {
/* 703 */         if (!cacheIsFull())
/*     */         {
/*     */           try
/*     */           {
/* 707 */             this._workList.wait(this._scanPeriod);
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean currentWork(Uid objUid, int ft)
/*     */   {
/*     */     try
/*     */     {
/* 721 */       if (this._work != null)
/*     */       {
/* 723 */         if ((this._work.objUid.equals(objUid)) && (this._work.fileType == ft))
/*     */         {
/* 725 */           return true;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */ 
/* 733 */     return false;
/*     */   }
/*     */ 
/*     */   private final void doWork()
/*     */   {
/* 745 */     synchronized (this._workList)
/*     */     {
/* 747 */       LinkedList list = getList();
/*     */ 
/* 749 */       if (list != null)
/*     */       {
/*     */         try
/*     */         {
/* 753 */           this._work = ((StoreElement)list.removeLast());
/*     */ 
/* 755 */           this._numberOfEntries -= 1;
/*     */ 
/* 757 */           if ((this._work.state != null) && (!this._work.removed)) {
/* 758 */             this._currentCacheSize -= this._work.state.size();
/*     */           }
/* 760 */           if (this._work.removed)
/*     */           {
/* 762 */             this._removedItems -= 1;
/*     */           }
/*     */         }
/*     */         catch (NoSuchElementException ex)
/*     */         {
/* 767 */           this._work = null;
/*     */         }
/*     */       }
/*     */       else {
/* 771 */         this._work = null;
/*     */       }
/*     */     }
/* 774 */     if ((this._work != null) && (!this._work.removed))
/*     */     {
/*     */       try
/*     */       {
/* 783 */         switch (this._work.typeOfWork)
/*     */         {
/*     */         case 0:
/* 787 */           if (this._work.store.commitState(this._work.objUid, this._work.tName))
/*     */             break;
/* 789 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_1", new Object[] { this._work.objUid, this._work.tName }); break;
/*     */         case 1:
/* 796 */           if (this._work.store.removeState(this._work.objUid, this._work.tName, this._work.fileType))
/*     */             break;
/* 798 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_2", new Object[] { this._work.objUid, this._work.tName, new Integer(this._work.fileType) }); break;
/*     */         case 2:
/* 805 */           if (this._work.store.writeState(this._work.objUid, this._work.tName, this._work.state, this._work.fileType))
/*     */             break;
/* 807 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_3", new Object[] { this._work.objUid, this._work.tName, this._work.state, new Integer(this._work.fileType) }); break;
/*     */         default:
/* 813 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_3", new Object[] { new Integer(this._work.typeOfWork) });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ObjectStoreException ex)
/*     */       {
/* 820 */         ex.printStackTrace();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 824 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 828 */     this._work = null;
/*     */   }
/*     */ 
/*     */   private final boolean queueIsEmpty()
/*     */   {
/* 837 */     synchronized (this._workList)
/*     */     {
/* 840 */       return this._numberOfEntries == 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final boolean cacheIsFull()
/*     */   {
/* 852 */     synchronized (this._workList)
/*     */     {
/* 854 */       if ((this._currentCacheSize >= this._maximumCacheSize) || (this._removedItems >= this._maximumRemovedItems) || (this._numberOfEntries - this._removedItems >= this._maximumWorkItems))
/*     */       {
/* 858 */         this._workList.notify();
/*     */ 
/* 860 */         return true;
/*     */       }
/*     */ 
/* 863 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final LinkedList getList()
/*     */   {
/* 869 */     for (int i = 0; i < HASH_SIZE; i++)
/*     */     {
/* 871 */       if ((this._workList[i] != null) && (this._workList[i].size() > 0)) {
/* 872 */         return this._workList[i];
/*     */       }
/*     */     }
/* 875 */     return null;
/*     */   }
/*     */ 
/*     */   private final LinkedList getList(Uid objUid)
/*     */   {
/* 880 */     int index = objUid.hashCode() % HASH_SIZE;
/*     */ 
/* 882 */     synchronized (this._workList)
/*     */     {
/* 884 */       if (this._workList[index] == null) {
/* 885 */         this._workList[index] = new LinkedList();
/*     */       }
/* 887 */       return this._workList[index];
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 914 */     String hashSize = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.hash");
/*     */ 
/* 916 */     if (hashSize != null)
/*     */     {
/*     */       try
/*     */       {
/* 920 */         HASH_SIZE = Integer.parseInt(hashSize);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 924 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 928 */     if (HASH_SIZE <= 0) {
/* 929 */       HASH_SIZE = 128;
/*     */     }
/* 931 */     String cacheSize = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.size");
/*     */ 
/* 933 */     if (cacheSize != null)
/*     */     {
/*     */       try
/*     */       {
/* 937 */         _defaultCacheSize = Integer.parseInt(cacheSize);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 941 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 945 */     if (_defaultCacheSize < 0) {
/* 946 */       _defaultCacheSize = 0;
/*     */     }
/* 948 */     String removedItems = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.removedItems");
/*     */ 
/* 950 */     if (removedItems != null)
/*     */     {
/*     */       try
/*     */       {
/* 954 */         _defaultRemovedItems = Integer.parseInt(removedItems);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 958 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 962 */     if (_defaultRemovedItems < 0) {
/* 963 */       _defaultRemovedItems = 0;
/*     */     }
/* 965 */     String workItems = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.workItems");
/*     */ 
/* 967 */     if (workItems != null)
/*     */     {
/*     */       try
/*     */       {
/* 971 */         _defaultWorkItems = Integer.parseInt(workItems);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 975 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 979 */     if (_defaultWorkItems < 0) {
/* 980 */       _defaultWorkItems = 0;
/*     */     }
/* 982 */     String scanPeriod = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.scanPeriod");
/*     */ 
/* 984 */     if (scanPeriod != null)
/*     */     {
/*     */       try
/*     */       {
/* 988 */         _defaultScanPeriod = Integer.parseInt(scanPeriod);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 992 */         ex.printStackTrace();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.AsyncStore
 * JD-Core Version:    0.6.0
 */