/*     */ package com.arjuna.ats.internal.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.StateManager;
/*     */ import com.arjuna.ats.arjuna.StateManagerAttribute;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class LogWriteStateManager extends StateManager
/*     */ {
/*     */   public boolean writeOptimisation()
/*     */   {
/*  67 */     return true;
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(Uid objUid)
/*     */   {
/*  72 */     super(objUid);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(Uid objUid, ObjectName attr)
/*     */   {
/*  77 */     super(objUid, 1, attr);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(Uid objUid, int ot)
/*     */   {
/*  82 */     super(objUid, ot, null);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(Uid objUid, int ot, ObjectName objName)
/*     */   {
/*  87 */     super(objUid, ot, objName);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager()
/*     */   {
/*  92 */     super(0, null);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(int ot)
/*     */   {
/*  97 */     super(ot, null);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(int ot, ObjectName objName)
/*     */   {
/* 102 */     super(ot, objName);
/*     */   }
/*     */ 
/*     */   protected LogWriteStateManager(ObjectName objName)
/*     */   {
/* 107 */     super(objName);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean modified()
/*     */   {
/* 112 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 114 */       tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::modified() for object-id " + get_uid());
/*     */     }
/*     */ 
/* 118 */     if ((super.ObjectType() == 0) && (this.smAttributes.objectModel == 0)) {
/* 119 */       return super.modified();
/*     */     }
/* 121 */     BasicAction action = BasicAction.Current();
/*     */ 
/* 123 */     if ((super.ObjectType() == 2) || (super.status() == 4))
/*     */     {
/* 125 */       return true;
/*     */     }
/*     */ 
/* 128 */     if (super.status() == 0)
/*     */     {
/* 130 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 131 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_10");
/*     */       }
/* 133 */       activate();
/*     */     }
/*     */ 
/* 140 */     if (status() == 1) {
/* 141 */       setStatus(3);
/*     */     }
/* 143 */     if (action != null)
/*     */     {
/* 151 */       synchronized (this.modifyingActions)
/*     */       {
/* 153 */         if ((this.modifyingActions.size() > 0) && (this.modifyingActions.get(action.get_uid()) != null))
/*     */         {
/* 156 */           return true;
/*     */         }
/*     */ 
/* 159 */         this.modifyingActions.put(action.get_uid(), action);
/*     */       }
/*     */ 
/* 164 */       OutputObjectState state = new OutputObjectState(this.objectUid, type());
/* 165 */       int rStatus = 2;
/*     */ 
/* 167 */       if (save_state(state, 0))
/*     */       {
/* 169 */         TxLogWritePersistenceRecord record = new TxLogWritePersistenceRecord(state, super.getStore(), this);
/*     */ 
/* 171 */         if ((rStatus = action.add(record)) != 2)
/*     */         {
/* 173 */           synchronized (this.modifyingActions)
/*     */           {
/* 175 */             this.modifyingActions.remove(action.get_uid());
/*     */           }
/*     */ 
/* 178 */           record = null;
/*     */ 
/* 180 */           return false;
/*     */         }
/*     */       }
/*     */       else {
/* 184 */         return false;
/*     */       }
/*     */     }
/* 187 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.LogWriteStateManager
 * JD-Core Version:    0.6.0
 */