/*     */ package com.arjuna.ats.arjuna.utils;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class FileLock
/*     */ {
/*     */   public static final int F_RDLCK = 0;
/*     */   public static final int F_WRLCK = 1;
/*     */   public static final int defaultTimeout = 10;
/*     */   public static final int defaultRetry = 10;
/*     */   private File _theFile;
/*     */   private File _lockFile;
/*     */   private File _lockFileLock;
/*     */   private long _timeout;
/*     */   private long _retry;
/*     */ 
/*     */   public FileLock(File name)
/*     */   {
/*  84 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  86 */       tsLogger.arjLogger.debug(1L, 4L, 128L, "FileLock ( " + name + " )");
/*     */     }
/*     */ 
/*  91 */     this._theFile = name;
/*  92 */     this._lockFile = new File(name.toString() + "_lock");
/*  93 */     this._lockFileLock = new File(name.toString() + "_lock.lock");
/*  94 */     this._timeout = 10L;
/*  95 */     this._retry = 10L;
/*     */   }
/*     */ 
/*     */   public FileLock(File name, long timeout, long retry)
/*     */   {
/* 100 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 102 */       tsLogger.arjLogger.debug(1L, 4L, 128L, "FileLock ( " + name + ", " + timeout + ", " + retry + " )");
/*     */     }
/*     */ 
/* 107 */     this._theFile = name;
/* 108 */     this._lockFile = new File(name.toString() + "_lock");
/* 109 */     this._lockFileLock = new File(name.toString() + "_lock.lock");
/* 110 */     this._timeout = timeout;
/* 111 */     this._retry = retry;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 116 */     this._theFile = null;
/*     */   }
/*     */ 
/*     */   public boolean lock(int lmode)
/*     */   {
/* 125 */     return lock(lmode, false);
/*     */   }
/*     */ 
/*     */   public boolean lock(int lmode, boolean create)
/*     */   {
/* 130 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 132 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 128L, "com.arjuna.ats.arjuna.utils.FileLock_1", new Object[] { this._lockFile });
/*     */     }
/*     */ 
/* 137 */     if ((create) && (!this._theFile.exists()))
/*     */     {
/* 139 */       createFile();
/*     */     }
/*     */ 
/* 150 */     if ((this._lockFile.exists()) && (lmode == 1)) {
/* 151 */       return false;
/*     */     }
/* 153 */     int number = 0;
/*     */ 
/* 155 */     if (lockFile())
/*     */     {
/*     */       try
/*     */       {
/* 159 */         DataInputStream ifile = new DataInputStream(new FileInputStream(this._lockFile));
/* 160 */         int value = ifile.readInt();
/*     */ 
/* 166 */         if (value == 1)
/*     */         {
/* 168 */           ifile.close();
/* 169 */           unlockFile();
/*     */ 
/* 171 */           return false;
/*     */         }
/*     */ 
/* 174 */         number = ifile.readInt();
/*     */ 
/* 176 */         ifile.close();
/*     */       }
/*     */       catch (FileNotFoundException e)
/*     */       {
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 187 */         unlockFile();
/*     */ 
/* 189 */         return false;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 194 */         DataOutputStream ofile = new DataOutputStream(new FileOutputStream(this._lockFile));
/*     */ 
/* 196 */         number++;
/*     */ 
/* 198 */         ofile.writeInt(lmode);
/* 199 */         ofile.writeInt(number);
/*     */ 
/* 201 */         ofile.close();
/*     */ 
/* 203 */         unlockFile();
/*     */ 
/* 205 */         return true;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 214 */         unlockFile();
/*     */ 
/* 216 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 220 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean unlock()
/*     */   {
/* 225 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 227 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 128L, "com.arjuna.ats.arjuna.utils.FileLock_2", new Object[] { this._lockFile });
/*     */     }
/*     */ 
/* 232 */     if (!this._lockFile.exists()) {
/* 233 */       return false;
/*     */     }
/* 235 */     if (lockFile())
/*     */     {
/* 237 */       int number = 0; int mode = 0;
/*     */       try
/*     */       {
/* 241 */         DataInputStream ifile = new DataInputStream(new FileInputStream(this._lockFile));
/*     */ 
/* 243 */         mode = ifile.readInt();
/* 244 */         number = ifile.readInt();
/* 245 */         ifile.close();
/*     */ 
/* 247 */         number--;
/*     */ 
/* 249 */         if (number == 0)
/*     */         {
/* 251 */           this._lockFile.delete();
/*     */ 
/* 253 */           unlockFile();
/*     */ 
/* 255 */           return true;
/*     */         }
/*     */       }
/*     */       catch (FileNotFoundException e)
/*     */       {
/* 260 */         unlockFile();
/*     */ 
/* 262 */         return false;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 266 */         unlockFile();
/*     */ 
/* 268 */         return false;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 273 */         DataOutputStream ofile = new DataOutputStream(new FileOutputStream(this._lockFile));
/*     */ 
/* 275 */         ofile.writeInt(mode);
/* 276 */         ofile.writeInt(number);
/* 277 */         ofile.close();
/*     */ 
/* 279 */         unlockFile();
/*     */ 
/* 281 */         return true;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 285 */         unlockFile();
/*     */ 
/* 287 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 291 */     return false;
/*     */   }
/*     */ 
/*     */   public static String modeString(int mode)
/*     */   {
/* 296 */     switch (mode)
/*     */     {
/*     */     case 0:
/* 299 */       return "FileLock.F_RDLCK";
/*     */     case 1:
/* 301 */       return "FileLock.F_WRLCK";
/*     */     }
/* 303 */     return "Unknown";
/*     */   }
/*     */ 
/*     */   private final boolean createFile()
/*     */   {
/* 309 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 311 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 128L, "com.arjuna.ats.arjuna.utils.FileLock_3", new Object[] { this._lockFile });
/*     */     }
/*     */ 
/* 316 */     byte[] b = new byte[1];
/*     */     try
/*     */     {
/* 320 */       if (!this._theFile.exists())
/*     */       {
/* 322 */         this._theFile.createNewFile();
/*     */ 
/* 324 */         return true;
/*     */       }
/*     */ 
/* 327 */       return false;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 332 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 334 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.utils.FileLock_4", new Object[] { this._lockFile });
/*     */       }
/*     */     }
/* 337 */     return false;
/*     */   }
/*     */ 
/*     */   private final boolean lockFile()
/*     */   {
/* 343 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 345 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 128L, "com.arjuna.ats.arjuna.utils.FileLock_5", new Object[] { this._lockFile });
/*     */     }
/*     */ 
/* 350 */     for (int i = 0; i < this._retry; i++)
/*     */     {
/*     */       try
/*     */       {
/* 354 */         if (this._lockFileLock.createNewFile()) {
/* 355 */           return true;
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 360 */           Thread.sleep(this._timeout);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 373 */     return false;
/*     */   }
/*     */ 
/*     */   private final boolean unlockFile()
/*     */   {
/* 378 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 380 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 128L, "com.arjuna.ats.arjuna.utils.FileLock_6", new Object[] { this._lockFile });
/*     */     }
/*     */ 
/* 384 */     return this._lockFileLock.delete();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.utils.FileLock
 * JD-Core Version:    0.6.0
 */