/*     */ package com.arjuna.ats.arjuna.tools;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class TransactionMonitor
/*     */ {
/*     */   public static void main(String[] args)
/*     */   {
/*  48 */     String root = null;
/*     */ 
/*  50 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  52 */       if (args[i].compareTo("-help") == 0)
/*     */       {
/*  54 */         usage();
/*  55 */         System.exit(0);
/*     */       }
/*  59 */       else if (args[i].compareTo("-root") == 0)
/*     */       {
/*  61 */         root = args[(i + 1)];
/*  62 */         i++;
/*     */       }
/*     */       else
/*     */       {
/*  66 */         System.out.println("Unknown option " + args[i]);
/*  67 */         usage();
/*     */ 
/*  69 */         System.exit(0);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  75 */     BasicAction ba = new BasicAction();
/*  76 */     String baType = ba.type();
/*  77 */     if (baType.charAt(0) == '/')
/*  78 */       baType = baType.substring(1);
/*     */     try
/*     */     {
/*  81 */       TxControl txc = new TxControl();
/*  82 */       ObjectStore imple = TxControl.getStore();
/*     */ 
/*  84 */       InputObjectState types = new InputObjectState();
/*     */ 
/*  86 */       if (imple.allTypes(types))
/*     */       {
/*  88 */         String theName = null;
/*  89 */         int count = 0;
/*     */         try
/*     */         {
/*  93 */           boolean endOfList = false;
/*     */ 
/*  95 */           while (!endOfList)
/*     */           {
/*  97 */             theName = types.unpackString();
/*     */ 
/*  99 */             if (theName.compareTo("") == 0) {
/* 100 */               endOfList = true; continue;
/* 101 */             }if (!theName.startsWith(baType))
/*     */               continue;
/* 103 */             count++;
/*     */ 
/* 105 */             System.out.println(count + ": " + theName);
/*     */ 
/* 107 */             InputObjectState uids = new InputObjectState();
/*     */ 
/* 109 */             if (imple.allObjUids(theName, uids))
/*     */             {
/* 111 */               Uid theUid = new Uid(Uid.nullUid());
/*     */               try
/*     */               {
/* 115 */                 boolean endOfUids = false;
/*     */ 
/* 117 */                 while (!endOfUids)
/*     */                 {
/* 119 */                   theUid.unpack(uids);
/*     */ 
/* 121 */                   if (theUid.equals(Uid.nullUid())) {
/* 122 */                     endOfUids = true; continue;
/*     */                   }
/*     */ 
/* 125 */                   System.out.print("\t" + theUid + " state is ");
/* 126 */                   System.out.print(ObjectStore.stateStatusString(imple.currentState(theUid, theName)));
/* 127 */                   System.out.println();
/*     */                 }
/*     */ 
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 137 */             System.out.println();
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 143 */           System.err.println(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 151 */       System.err.println("Caught unexpected exception: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void usage()
/*     */   {
/* 157 */     System.out.println("Usage: TransactionMonitor [-root <store root>] [-help]");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.tools.TransactionMonitor
 * JD-Core Version:    0.6.0
 */