/*     */ package com.arjuna.ats.arjuna.tools;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.net.ConnectException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ 
/*     */ public class RecoveryMonitor
/*     */ {
/*     */   public static void main(String[] args)
/*     */   {
/*  42 */     String host = null;
/*  43 */     int port = 0;
/*  44 */     boolean asyncScan = false;
/*  45 */     int timeout = 20000;
/*  46 */     boolean test = false;
/*     */ 
/*  48 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  50 */       if (args[i].compareTo("-help") == 0)
/*     */       {
/*  52 */         usage();
/*  53 */         System.exit(0);
/*     */       }
/*  57 */       else if (args[i].compareTo("-host") == 0)
/*     */       {
/*  59 */         host = args[(i + 1)];
/*  60 */         i++;
/*     */       }
/*  64 */       else if (args[i].compareTo("-port") == 0)
/*     */       {
/*     */         try
/*     */         {
/*  68 */           port = Integer.parseInt(args[(i + 1)]);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/*  72 */           System.err.println("Invalid port: " + args[(i + 1)]);
/*     */         }
/*     */ 
/*  75 */         i++;
/*     */       }
/*  79 */       else if (args[i].compareTo("-timeout") == 0)
/*     */       {
/*     */         try
/*     */         {
/*  83 */           timeout = Integer.parseInt(args[(i + 1)]);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/*  87 */           System.err.println("Invalid timeout: " + args[(i + 1)]);
/*     */         }
/*     */ 
/*  90 */         i++;
/*     */       }
/*  94 */       else if (args[i].compareTo("-async") == 0)
/*     */       {
/*  96 */         asyncScan = true;
/*     */       }
/* 100 */       else if (args[i].compareTo("-test") == 0)
/*     */       {
/* 102 */         test = true;
/*     */       }
/*     */       else
/*     */       {
/* 106 */         System.out.println("Unknown option " + args[i]);
/* 107 */         usage();
/*     */ 
/* 109 */         System.exit(0);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 120 */       if (host == null) {
/* 121 */         host = InetAddress.getLocalHost().getHostName();
/*     */       }
/* 123 */       Socket connectorSocket = new Socket(host, port);
/*     */ 
/* 125 */       connectorSocket.setSoTimeout(timeout);
/*     */ 
/* 129 */       BufferedReader fromServer = new BufferedReader(new InputStreamReader(connectorSocket.getInputStream()));
/*     */ 
/* 131 */       PrintWriter toServer = new PrintWriter(new OutputStreamWriter(connectorSocket.getOutputStream()));
/*     */ 
/* 133 */       if (asyncScan)
/* 134 */         toServer.println("ASYNC_SCAN");
/*     */       else {
/* 136 */         toServer.println("SCAN");
/*     */       }
/* 138 */       toServer.flush();
/*     */ 
/* 140 */       String response = fromServer.readLine();
/*     */ 
/* 142 */       if (response.equals("DONE"))
/* 143 */         System.out.println("RecoveryManager scan begun.");
/*     */       else {
/* 145 */         System.err.println("RecoveryManager did not understand request: " + response);
/*     */       }
/* 147 */       connectorSocket.close();
/*     */     }
/*     */     catch (ConnectException e)
/*     */     {
/* 151 */       System.err.println("Connection refused - check the host/port information is correct.");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 155 */       System.err.println("Caught unexpected exception: " + e);
/*     */     }
/*     */ 
/* 158 */     if (test)
/* 159 */       System.out.println("Ready");
/*     */   }
/*     */ 
/*     */   private static void usage()
/*     */   {
/* 164 */     System.out.println("Usage: RecoveryMonitor -port <port number> [-host <host name>] [-async] [-timeout <wait time>] [-help]");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.tools.RecoveryMonitor
 * JD-Core Version:    0.6.0
 */