/*     */ package com.arjuna.ats.arjuna.tools;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class ObjectStoreMonitor
/*     */ {
/*     */   public static void main(String[] args)
/*     */   {
/*  47 */     String storeImple = null;
/*  48 */     String root = null;
/*     */ 
/*  50 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  52 */       if (args[i].compareTo("-help") == 0)
/*     */       {
/*  54 */         usage();
/*  55 */         System.exit(0);
/*     */       }
/*  59 */       else if (args[i].compareTo("-store") == 0)
/*     */       {
/*  61 */         storeImple = args[(i + 1)];
/*  62 */         i++;
/*     */       }
/*  66 */       else if (args[i].compareTo("-root") == 0)
/*     */       {
/*  68 */         root = args[(i + 1)];
/*  69 */         i++;
/*     */       }
/*     */       else
/*     */       {
/*  73 */         System.out.println("Unknown option " + args[i]);
/*  74 */         usage();
/*     */ 
/*  76 */         System.exit(0);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  84 */       ObjectStore imple = null;
/*     */ 
/*  86 */       if (storeImple != null)
/*  87 */         imple = new ObjectStore(new ClassName(storeImple), root);
/*     */       else {
/*  89 */         imple = new ObjectStore(root);
/*     */       }
/*  91 */       InputObjectState types = new InputObjectState();
/*     */ 
/*  93 */       if (imple.allTypes(types))
/*     */       {
/*  95 */         String theName = null;
/*  96 */         int count = 0;
/*     */         try
/*     */         {
/* 100 */           boolean endOfList = false;
/*     */ 
/* 102 */           while (!endOfList)
/*     */           {
/* 104 */             theName = types.unpackString();
/*     */ 
/* 106 */             if (theName.compareTo("") == 0) {
/* 107 */               endOfList = true; continue;
/*     */             }
/*     */ 
/* 110 */             count++;
/*     */ 
/* 112 */             System.out.println(count + ": " + theName);
/*     */ 
/* 114 */             InputObjectState uids = new InputObjectState();
/*     */ 
/* 116 */             if (imple.allObjUids(theName, uids))
/*     */             {
/* 118 */               Uid theUid = new Uid(Uid.nullUid());
/*     */               try
/*     */               {
/* 122 */                 boolean endOfUids = false;
/*     */ 
/* 124 */                 while (!endOfUids)
/*     */                 {
/* 126 */                   theUid.unpack(uids);
/*     */ 
/* 128 */                   if (theUid.equals(Uid.nullUid())) {
/* 129 */                     endOfUids = true; continue;
/*     */                   }
/*     */ 
/* 132 */                   System.out.print("\t" + theUid + " state is ");
/* 133 */                   System.out.print(ObjectStore.stateStatusString(imple.currentState(theUid, theName)));
/*     */ 
/* 135 */                   System.out.println();
/*     */                 }
/*     */ 
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 145 */             System.out.println();
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 151 */           System.err.println(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 159 */       System.err.println("Caught unexpected exception: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void usage()
/*     */   {
/* 165 */     System.out.println("Usage: ActionMonitor [-store <object store>] [-root <store root>] [-help]");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.tools.ObjectStoreMonitor
 * JD-Core Version:    0.6.0
 */