/*     */ package com.arjuna.ats.arjuna.tools;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.event.MouseAdapter;
/*     */ import java.awt.event.MouseEvent;
/*     */ import java.awt.event.MouseListener;
/*     */ import java.awt.event.WindowAdapter;
/*     */ import java.awt.event.WindowEvent;
/*     */ import java.awt.event.WindowListener;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Vector;
/*     */ import javax.swing.JFrame;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JSplitPane;
/*     */ import javax.swing.JTree;
/*     */ import javax.swing.tree.DefaultMutableTreeNode;
/*     */ import javax.swing.tree.DefaultTreeModel;
/*     */ import javax.swing.tree.TreePath;
/*     */ import javax.swing.tree.TreeSelectionModel;
/*     */ 
/*     */ public class OTM extends JSplitPane
/*     */ {
/* 835 */   private static Vector _machines = new Vector();
/* 836 */   private static Vector _dirs = new Vector();
/* 837 */   private static DefaultMutableTreeNode topMachine = null;
/* 838 */   private static DefaultMutableTreeNode topTran = null;
/* 839 */   private static DefaultMutableTreeNode scanningNode = null;
/* 840 */   private static DefaultMutableTreeNode emptyTx = new DefaultMutableTreeNode("No transactions.");
/* 841 */   private static JTree tree = null;
/* 842 */   private static JTree transactions = null;
/* 843 */   private static String pollingTimeout = "MONITORING_TIMEOUT";
/* 844 */   private static long sleepTime = -1L;
/*     */ 
/*     */   public OTM()
/*     */   {
/* 117 */     super(1);
/*     */ 
/* 119 */     String localHost = null;
/*     */     try
/*     */     {
/* 123 */       InetAddress myAddress = InetAddress.getLocalHost();
/* 124 */       localHost = myAddress.getHostName();
/*     */     }
/*     */     catch (UnknownHostException e)
/*     */     {
/* 128 */       localHost = "LocalHostUnknown";
/*     */     }
/*     */ 
/* 131 */     _machines.addElement(localHost);
/* 132 */     localHost = null;
/*     */ 
/* 136 */     topMachine = new DefaultMutableTreeNode("Registered machines.");
/* 137 */     topTran = new DefaultMutableTreeNode("Running transactions.");
/*     */ 
/* 139 */     createNodes(topMachine);
/*     */ 
/* 143 */     tree = new JTree(topMachine);
/* 144 */     transactions = new JTree(topTran);
/*     */ 
/* 146 */     tree.getSelectionModel().setSelectionMode(1);
/*     */ 
/* 150 */     MouseListener ml = new MouseAdapter() {
/*     */       public void mouseClicked(MouseEvent e) {
/* 152 */         int selRow = OTM.tree.getRowForLocation(e.getX(), e.getY());
/* 153 */         TreePath selPath = OTM.tree.getPathForLocation(e.getX(), e.getY());
/*     */ 
/* 155 */         if (selRow != -1)
/*     */         {
/* 157 */           if (e.getClickCount() == 2)
/*     */           {
/* 159 */             if ((e.getModifiers() & 0x10) == 16)
/*     */             {
/* 161 */               DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selRow);
/*     */ 
/* 163 */               if (node.isLeaf())
/*     */               {
/* 165 */                 OTM.this.getTransactions(node);
/*     */               }
/*     */               else
/* 168 */                 OTM.this.removeTransactions();
/*     */             }
/*     */           }
/* 171 */           if (e.getClickCount() == 1)
/*     */           {
/* 173 */             if ((e.getModifiers() & 0x4) == 4)
/* 174 */               OTM.this.removeTransactions();
/*     */           }
/*     */         }
/*     */       }
/*     */     };
/* 180 */     tree.addMouseListener(ml);
/*     */ 
/* 184 */     JScrollPane treeView = new JScrollPane(tree);
/* 185 */     JScrollPane tranView = new JScrollPane(transactions);
/*     */ 
/* 189 */     add(treeView);
/* 190 */     add(tranView);
/*     */ 
/* 192 */     Dimension minimumSize = new Dimension(100, 100);
/*     */ 
/* 194 */     treeView.setMinimumSize(minimumSize);
/* 195 */     tranView.setMinimumSize(minimumSize);
/*     */ 
/* 202 */     treeView.setPreferredSize(new Dimension(200, 200));
/*     */ 
/* 204 */     setPreferredSize(new Dimension(500, 300));
/*     */   }
/*     */ 
/*     */   public synchronized void updateTransactions()
/*     */   {
/* 209 */     if (scanningNode != null)
/*     */     {
/* 211 */       String root = null;
/* 212 */       String storeImple = null;
/* 213 */       DefaultMutableTreeNode top = (DefaultMutableTreeNode)topTran.getFirstChild();
/* 214 */       DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
/*     */       try
/*     */       {
/* 218 */         ClassName actionStoreType = new ClassName(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.actionStore", ArjunaNames.Implementation_ObjectStore_defaultActionStore().stringForm()));
/*     */ 
/* 221 */         ObjectStore imple = new ObjectStore(actionStoreType, root);
/* 222 */         InputObjectState types = new InputObjectState();
/*     */ 
/* 224 */         startSweep();
/*     */ 
/* 226 */         if (imple.allTypes(types))
/*     */         {
/* 228 */           String fullPathName = null;
/* 229 */           boolean found = false;
/*     */           try
/*     */           {
/* 233 */             boolean endOfList = false;
/* 234 */             DefaultMutableTreeNode currentNode = null;
/* 235 */             DefaultMutableTreeNode currentRoot = top;
/*     */ 
/* 237 */             while (!endOfList)
/*     */             {
/* 239 */               fullPathName = types.unpackString();
/*     */ 
/* 241 */               if (fullPathName.compareTo("") == 0) {
/* 242 */                 endOfList = true;
/*     */               }
/*     */               else {
/* 245 */                 found = true;
/*     */ 
/* 247 */                 InputObjectState uids = new InputObjectState();
/* 248 */                 String nodeName = stripName(fullPathName);
/* 249 */                 boolean added = false;
/*     */ 
/* 251 */                 currentNode = findNode(fullPathName);
/*     */ 
/* 253 */                 if (currentNode == null)
/*     */                 {
/* 255 */                   currentNode = new DefaultMutableTreeNode(nodeName);
/* 256 */                   addDirectory(currentNode, fullPathName);
/* 257 */                   currentRoot.add(currentNode);
/*     */ 
/* 263 */                   int[] i = new int[1];
/*     */ 
/* 265 */                   i[0] = (currentRoot.getChildCount() - 1);
/*     */ 
/* 267 */                   model.nodesWereInserted(currentRoot, i);
/*     */ 
/* 269 */                   added = true;
/*     */                 }
/*     */ 
/* 272 */                 currentRoot = findRoot(top, currentNode);
/*     */ 
/* 274 */                 if (added) {
/* 275 */                   currentRoot.add(currentNode);
/*     */                 }
/* 277 */                 if (imple.allObjUids(fullPathName, uids))
/*     */                 {
/* 279 */                   Uid theUid = new Uid(Uid.nullUid());
/*     */                   try
/*     */                   {
/* 283 */                     boolean endOfUids = false;
/* 284 */                     boolean first = true;
/* 285 */                     boolean haveUids = false;
/*     */ 
/* 287 */                     while (!endOfUids)
/*     */                     {
/* 289 */                       theUid.unpack(uids);
/*     */ 
/* 291 */                       if (theUid.equals(Uid.nullUid()))
/*     */                       {
/* 293 */                         if (!haveUids)
/*     */                         {
/* 295 */                           if (emptyDirectory(currentNode))
/*     */                           {
/* 297 */                             currentNode.removeAllChildren();
/* 298 */                             model.nodeChanged(currentNode);
/*     */                           }
/*     */                         }
/*     */ 
/* 302 */                         endOfUids = true; continue;
/*     */                       }
/*     */ 
/* 306 */                       haveUids = true;
/*     */ 
/* 308 */                       if (first)
/*     */                       {
/* 310 */                         currentNode.removeAllChildren();
/*     */ 
/* 312 */                         first = false;
/*     */                       }
/*     */ 
/* 315 */                       DefaultMutableTreeNode tranID = new DefaultMutableTreeNode(theUid.stringForm());
/*     */ 
/* 317 */                       tranID.add(new DefaultMutableTreeNode(new String("status: " + statusToString(imple.currentState(theUid, fullPathName)))));
/*     */ 
/* 319 */                       currentNode.add(tranID);
/*     */ 
/* 321 */                       added = true;
/*     */                     }
/*     */ 
/*     */                   }
/*     */                   catch (Exception e)
/*     */                   {
/*     */                   }
/*     */ 
/* 330 */                   if (added) {
/* 331 */                     model.nodeChanged(currentNode);
/*     */                   }
/*     */ 
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/* 339 */               if (!found) {
/* 340 */                 currentRoot.add(emptyTx);
/*     */               }
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*     */           }
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 351 */           endSweep();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 355 */           e.printStackTrace();
/* 356 */           System.exit(0);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 361 */         System.err.println(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean emptyDirectory(DefaultMutableTreeNode node)
/*     */   {
/* 368 */     DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
/*     */ 
/* 370 */     if (child != null)
/*     */     {
/* 372 */       DefaultMutableTreeNode status = (DefaultMutableTreeNode)child.getFirstChild();
/*     */ 
/* 374 */       if (status != null) {
/* 375 */         return status.isLeaf();
/*     */       }
/*     */     }
/* 378 */     return true;
/*     */   }
/*     */ 
/*     */   private void createNodes(DefaultMutableTreeNode topMachine)
/*     */   {
/* 383 */     int number = _machines.size();
/* 384 */     DefaultMutableTreeNode machine = null;
/*     */ 
/* 386 */     if (number == 0)
/*     */     {
/* 388 */       topMachine.add(new DefaultMutableTreeNode("No machines registered."));
/*     */     }
/*     */     else
/*     */     {
/* 392 */       String machineName = null;
/*     */ 
/* 394 */       for (int i = 0; i < number; i++)
/*     */       {
/* 396 */         machineName = (String)_machines.elementAt(i);
/* 397 */         machine = new DefaultMutableTreeNode(machineName);
/* 398 */         topMachine.add(machine);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void modifyTransactionView()
/*     */   {
/* 405 */     if (transactions.isCollapsed(1))
/* 406 */       transactions.expandRow(1);
/*     */     else
/* 408 */       transactions.collapseRow(1);
/*     */   }
/*     */ 
/*     */   private void removeTransactions()
/*     */   {
/* 413 */     int count = transactions.getRowCount();
/*     */ 
/* 415 */     for (int i = count; i > 0; i--)
/*     */     {
/* 417 */       transactions.collapseRow(i);
/* 418 */       transactions.removeSelectionRow(i);
/*     */     }
/*     */ 
/* 421 */     topTran.removeAllChildren();
/* 422 */     transactions.repaint();
/* 423 */     _dirs = new Vector();
/*     */ 
/* 425 */     DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
/*     */ 
/* 427 */     model.reload();
/*     */ 
/* 429 */     transactions.repaint();
/*     */ 
/* 431 */     scanningNode = null;
/*     */   }
/*     */ 
/*     */   private synchronized void getTransactions(DefaultMutableTreeNode machineName)
/*     */   {
/* 436 */     removeTransactions();
/*     */ 
/* 438 */     scanningNode = machineName;
/*     */ 
/* 440 */     String root = null;
/* 441 */     String storeImple = null;
/* 442 */     DefaultMutableTreeNode top = new DefaultMutableTreeNode(scanningNode);
/*     */     try
/*     */     {
/* 446 */       ClassName actionStoreType = new ClassName(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.actionStore", ArjunaNames.Implementation_ObjectStore_defaultActionStore().stringForm()));
/*     */ 
/* 449 */       ObjectStore imple = new ObjectStore(actionStoreType, root);
/* 450 */       InputObjectState types = new InputObjectState();
/*     */ 
/* 452 */       if (imple.allTypes(types))
/*     */       {
/* 454 */         String fullPathName = null;
/* 455 */         boolean found = false;
/*     */         try
/*     */         {
/* 459 */           boolean endOfList = false;
/* 460 */           DefaultMutableTreeNode currentNode = null;
/* 461 */           DefaultMutableTreeNode currentRoot = top;
/*     */ 
/* 463 */           topTran.add(currentRoot);
/*     */ 
/* 465 */           while (!endOfList)
/*     */           {
/* 467 */             fullPathName = types.unpackString();
/*     */ 
/* 469 */             if (fullPathName.compareTo("") == 0) {
/* 470 */               endOfList = true;
/*     */             }
/*     */             else {
/* 473 */               found = true;
/*     */ 
/* 475 */               InputObjectState uids = new InputObjectState();
/* 476 */               String nodeName = stripName(fullPathName);
/*     */ 
/* 478 */               currentNode = new DefaultMutableTreeNode(nodeName);
/* 479 */               addDirectory(currentNode, fullPathName);
/*     */ 
/* 481 */               currentRoot = findRoot(top, currentNode);
/* 482 */               currentRoot.add(currentNode);
/*     */ 
/* 484 */               if (imple.allObjUids(fullPathName, uids))
/*     */               {
/* 486 */                 Uid theUid = new Uid(Uid.nullUid());
/*     */                 try
/*     */                 {
/* 490 */                   boolean endOfUids = false;
/*     */ 
/* 492 */                   while (!endOfUids)
/*     */                   {
/* 494 */                     theUid.unpack(uids);
/*     */ 
/* 496 */                     if (theUid.equals(Uid.nullUid())) {
/* 497 */                       endOfUids = true; continue;
/*     */                     }
/*     */ 
/* 500 */                     DefaultMutableTreeNode tranID = new DefaultMutableTreeNode(theUid.stringForm());
/*     */ 
/* 502 */                     tranID.add(new DefaultMutableTreeNode(new String("status: " + statusToString(imple.currentState(theUid, fullPathName)))));
/*     */ 
/* 504 */                     currentNode.add(tranID);
/*     */                   }
/*     */ 
/*     */                 }
/*     */                 catch (Exception e)
/*     */                 {
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 519 */             if (!found) {
/* 520 */               currentRoot.add(emptyTx);
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 531 */       System.err.println(e);
/*     */     }
/*     */ 
/* 534 */     DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
/*     */ 
/* 536 */     model.reload();
/*     */ 
/* 538 */     transactions.repaint();
/*     */   }
/*     */ 
/*     */   private void startSweep()
/*     */   {
/* 543 */     int number = _dirs.size();
/*     */ 
/* 545 */     if (number != 0)
/*     */     {
/* 547 */       for (int i = 0; i < number; i++)
/*     */       {
/* 549 */         DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 551 */         if (dirEntry != null)
/* 552 */           dirEntry.present = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void endSweep()
/*     */   {
/* 559 */     int number = _dirs.size();
/*     */ 
/* 561 */     if (number != 0)
/*     */     {
/* 563 */       for (int i = 0; i < number; i++)
/*     */       {
/* 565 */         DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 567 */         if (dirEntry == null)
/*     */           continue;
/* 569 */         if (dirEntry.present)
/*     */           continue;
/* 571 */         DefaultMutableTreeNode top = (DefaultMutableTreeNode)topTran.getFirstChild();
/* 572 */         DefaultTreeModel model = (DefaultTreeModel)transactions.getModel();
/* 573 */         DefaultMutableTreeNode root = findRoot(top, dirEntry.node);
/*     */ 
/* 575 */         int index = root.getIndex(dirEntry.node);
/* 576 */         int[] j = new int[1];
/* 577 */         Object[] o = new Object[1];
/*     */ 
/* 579 */         j[0] = root.getIndex(dirEntry.node);
/* 580 */         o[0] = dirEntry.node;
/*     */ 
/* 582 */         root.remove(dirEntry.node);
/*     */ 
/* 584 */         model.nodesWereRemoved(root, j, o);
/*     */ 
/* 586 */         _dirs.removeElement(dirEntry);
/*     */ 
/* 588 */         dirEntry.node = null;
/* 589 */         j = null;
/* 590 */         o = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized DefaultMutableTreeNode findNode(String fullPathName)
/*     */   {
/* 599 */     if (fullPathName != null)
/*     */     {
/* 601 */       int number = _dirs.size();
/*     */ 
/* 603 */       if (number != 0)
/*     */       {
/* 605 */         for (int i = 0; i < number; i++)
/*     */         {
/* 607 */           DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 609 */           if (dirEntry == null)
/*     */             continue;
/* 611 */           if (dirEntry.fullPathName.compareTo(fullPathName) != 0)
/*     */           {
/*     */             continue;
/*     */           }
/*     */ 
/* 617 */           dirEntry.present = true;
/*     */ 
/* 619 */           return dirEntry.node;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 626 */     return null;
/*     */   }
/*     */ 
/*     */   private synchronized DefaultMutableTreeNode findRoot(DefaultMutableTreeNode top, DefaultMutableTreeNode curr)
/*     */   {
/* 632 */     DefaultMutableTreeNode root = top;
/*     */ 
/* 634 */     if (curr != null)
/*     */     {
/* 636 */       int number = _dirs.size();
/* 637 */       String name = fullNodeName(curr);
/*     */ 
/* 639 */       if (number != 0)
/*     */       {
/* 641 */         for (int i = 0; i < number; i++)
/*     */         {
/* 643 */           DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 645 */           if (dirEntry == null)
/*     */             continue;
/* 647 */           DefaultMutableTreeNode node = dirEntry.node;
/* 648 */           String dirName = dirEntry.fullPathName;
/*     */ 
/* 650 */           if ((name.indexOf(dirName) != -1) && (node != curr)) {
/* 651 */             root = node;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 657 */     return root;
/*     */   }
/*     */ 
/*     */   private void addDirectory(DefaultMutableTreeNode node, String path)
/*     */   {
/* 662 */     _dirs.addElement(new DirEntry(node, path));
/*     */   }
/*     */ 
/*     */   private void removeDirectory(String path)
/*     */   {
/* 667 */     Enumeration elements = _dirs.elements();
/*     */ 
/* 669 */     while (elements.hasMoreElements())
/*     */     {
/* 671 */       DirEntry e = (DirEntry)elements.nextElement();
/*     */ 
/* 673 */       if (e.fullPathName.compareTo(path) == 0)
/*     */       {
/* 675 */         _dirs.removeElement(e);
/* 676 */         return;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String fullNodeName(DefaultMutableTreeNode curr)
/*     */   {
/* 683 */     String root = "StateManager";
/*     */ 
/* 685 */     if (curr != null)
/*     */     {
/* 687 */       int number = _dirs.size();
/*     */ 
/* 689 */       if (number != 0)
/*     */       {
/* 691 */         for (int i = 0; i < number; i++)
/*     */         {
/* 693 */           DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 695 */           if (dirEntry == null)
/*     */             continue;
/* 697 */           if (dirEntry.node == curr) {
/* 698 */             return dirEntry.fullPathName;
/*     */           }
/*     */         }
/*     */ 
/* 702 */         root = (String)curr.getUserObject();
/*     */       }
/*     */     }
/*     */ 
/* 706 */     return root;
/*     */   }
/*     */ 
/*     */   private String stripName(String name)
/*     */   {
/* 711 */     String root = null;
/*     */ 
/* 713 */     if (name != null)
/*     */     {
/* 715 */       int number = _dirs.size();
/*     */ 
/* 717 */       if (number != 0)
/*     */       {
/* 719 */         for (int i = 0; i < number; i++)
/*     */         {
/* 721 */           DirEntry dirEntry = (DirEntry)_dirs.elementAt(i);
/*     */ 
/* 723 */           if (dirEntry == null)
/*     */             continue;
/* 725 */           DefaultMutableTreeNode node = dirEntry.node;
/* 726 */           String dirName = dirEntry.fullPathName;
/* 727 */           int subString = name.indexOf(dirName);
/*     */ 
/* 729 */           if ((subString == -1) || (name.compareTo(dirName) == 0))
/*     */             continue;
/* 731 */           root = name.substring(subString + dirName.length() + 1);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 737 */       if (root == null)
/* 738 */         root = name;
/*     */     }
/*     */     else {
/* 741 */       root = "StateManager";
/*     */     }
/* 743 */     return root;
/*     */   }
/*     */ 
/*     */   private void printChildren(DefaultMutableTreeNode currentNode)
/*     */   {
/* 748 */     if (currentNode != null)
/*     */     {
/* 750 */       Enumeration children = currentNode.children();
/*     */ 
/* 752 */       if (children != null)
/*     */       {
/* 754 */         String name = (String)currentNode.getUserObject();
/*     */ 
/* 756 */         System.out.println("Node: " + name);
/*     */ 
/* 758 */         while (children.hasMoreElements())
/*     */         {
/* 760 */           DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
/*     */ 
/* 762 */           name = (String)node.getUserObject();
/*     */ 
/* 764 */           System.out.println("\tChild: " + name);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String statusToString(int status)
/*     */   {
/* 772 */     switch (status)
/*     */     {
/*     */     case 1:
/* 775 */       return "ObjectStore.OS_COMMITTED";
/*     */     case 2:
/* 777 */       return "ObjectStore.OS_UNCOMMITTED";
/*     */     case 4:
/* 779 */       return "ObjectStore.OS_HIDDEN";
/*     */     case 5:
/* 781 */       return "ObjectStore.OS_COMMITTED_HIDDEN";
/*     */     case 6:
/* 783 */       return "ObjectStore.OS_UNCOMMITTED_HIDDEN";
/*     */     case 0:
/*     */     case 3:
/* 786 */     }return "ObjectStore.OS_UNKNOWN";
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 792 */     Uid u = new Uid();
/* 793 */     String timeout = arjPropertyManager.propertyManager.getProperty(pollingTimeout);
/*     */ 
/* 795 */     if (timeout != null)
/*     */     {
/*     */       try
/*     */       {
/* 799 */         sleepTime = Long.parseLong(timeout);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 803 */         System.err.println("Error - specified timeout " + timeout + " is invalid!");
/* 804 */         System.exit(0);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 813 */     JFrame frame = new JFrame("OTM Transaction Monitor");
/*     */ 
/* 815 */     WindowListener l = new WindowAdapter() {
/* 816 */       public void windowClosing(WindowEvent e) { System.exit(0);
/*     */       }
/*     */     };
/* 819 */     frame.addWindowListener(l);
/*     */ 
/* 821 */     OTM otm = new OTM();
/*     */ 
/* 823 */     frame.getContentPane().add("Center", otm);
/* 824 */     frame.pack();
/* 825 */     frame.show();
/*     */ 
/* 827 */     if (sleepTime != -1L)
/*     */     {
/* 829 */       MonitorThread thread = new MonitorThread(otm, sleepTime);
/*     */ 
/* 831 */       thread.start();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.tools.OTM
 * JD-Core Version:    0.6.0
 */