/*     */ package com.arjuna.ats.arjuna.state;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class OutputObjectState extends OutputBuffer
/*     */ {
/*     */   private Uid bufferUid;
/*     */   private String imageType;
/*     */ 
/*     */   public OutputObjectState()
/*     */   {
/*  58 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  60 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "OutputObjectState::OutputObjectState()");
/*     */     }
/*     */ 
/*  64 */     this.bufferUid = new Uid();
/*  65 */     this._valid = this.bufferUid.valid();
/*     */ 
/*  67 */     this.imageType = null;
/*     */   }
/*     */ 
/*     */   public OutputObjectState(OutputObjectState copyFrom)
/*     */   {
/*  77 */     super(copyFrom);
/*     */ 
/*  79 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  81 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "OutputObjectState::OutputObjectState(" + copyFrom + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  88 */       this.bufferUid = new Uid(copyFrom.bufferUid);
/*  89 */       this._valid = this.bufferUid.valid();
/*     */ 
/*  91 */       this.imageType = new String(copyFrom.imageType);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  95 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputObjectState(InputObjectState copyFrom)
/*     */   {
/* 101 */     super(copyFrom.buffer());
/*     */ 
/* 103 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 105 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "OutputObjectState::OutputObjectState(" + copyFrom + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 112 */       this.bufferUid = new Uid(copyFrom.stateUid());
/* 113 */       this._valid = this.bufferUid.valid();
/*     */ 
/* 115 */       this.imageType = new String(copyFrom.type());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 119 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputObjectState(Uid newUid, String tName)
/*     */   {
/* 125 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 127 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "OutputObjectState::OutputObjectState(" + newUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 132 */     this.bufferUid = new Uid(newUid);
/* 133 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 135 */     this.imageType = new String(tName);
/*     */   }
/*     */ 
/*     */   public OutputObjectState(Uid newUid, String tName, byte[] buffer)
/*     */   {
/* 140 */     super(buffer);
/*     */ 
/* 142 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 144 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "OutputObjectState::OutputObjectState(" + newUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 149 */     this.bufferUid = new Uid(newUid);
/* 150 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 152 */     this.imageType = new String(tName);
/*     */   }
/*     */ 
/*     */   public final boolean notempty()
/*     */   {
/* 157 */     return length() > 0;
/*     */   }
/*     */ 
/*     */   public final int size()
/*     */   {
/* 162 */     return length();
/*     */   }
/*     */ 
/*     */   public final Uid stateUid()
/*     */   {
/* 167 */     return this.bufferUid;
/*     */   }
/*     */ 
/*     */   public final String type()
/*     */   {
/* 172 */     return this.imageType;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 177 */     strm.println("OutputObjectState Uid   : " + this.bufferUid + "\n");
/*     */ 
/* 179 */     if (this.imageType != null)
/* 180 */       strm.println("OutputObjectState Type  : " + this.imageType + "\n");
/*     */     else {
/* 182 */       strm.println("OutputObjectState Type  : null\n");
/*     */     }
/* 184 */     strm.println("OutputObjectState Size  : " + size() + "\n");
/* 185 */     strm.println("OutputObjectState Buffer: ");
/*     */ 
/* 187 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 192 */     String val = "OutputObjectState Uid   : " + this.bufferUid + "\n";
/*     */ 
/* 194 */     if (this.imageType != null)
/* 195 */       val = val + "OutputObjectState Type  : " + this.imageType + "\n";
/*     */     else {
/* 197 */       val = val + "OutputObjectState Type  : null\n";
/*     */     }
/* 199 */     val = val + "OutputObjectState Size  : " + size() + "\n";
/* 200 */     val = val + "OutputObjectState Buffer: ";
/*     */ 
/* 202 */     return val;
/*     */   }
/*     */ 
/*     */   public synchronized void copy(OutputObjectState objstate)
/*     */   {
/* 207 */     if (tsLogger.arjLogger.debugAllowed()) {
/* 208 */       tsLogger.arjLogger.debug(32L, 4L, 4L, "OutputObjectState::copy for " + this.bufferUid);
/*     */     }
/*     */ 
/* 211 */     super.copy(objstate);
/*     */ 
/* 213 */     this.bufferUid = new Uid(objstate.bufferUid);
/* 214 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 216 */     this.imageType = new String(objstate.imageType);
/*     */   }
/*     */ 
/*     */   public synchronized void packInto(OutputBuffer buff) throws IOException
/*     */   {
/* 221 */     buff.packString(this.imageType);
/* 222 */     this.bufferUid.pack(buff);
/*     */ 
/* 224 */     super.packInto(buff);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.state.OutputObjectState
 * JD-Core Version:    0.6.0
 */