/*     */ package com.arjuna.ats.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.ats.internal.arjuna.recovery.Listener;
/*     */ import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
/*     */ import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.net.ServerSocket;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class TransactionStatusManager
/*     */ {
/*     */   private Listener _listener;
/*     */   private static final String _defaultTsmService = "com.arjuna.ats.arjuna.recovery.ActionStatusService";
/*     */   private static final int _defaultTsmPort = 0;
/* 275 */   private boolean _finalizeCalled = false;
/*     */ 
/*     */   public TransactionStatusManager()
/*     */   {
/*  76 */     int port = getTsmPort();
/*     */ 
/*  78 */     start("com.arjuna.ats.arjuna.recovery.ActionStatusService", port);
/*     */   }
/*     */ 
/*     */   public TransactionStatusManager(int port)
/*     */   {
/*  83 */     start("com.arjuna.ats.arjuna.recovery.ActionStatusService", port);
/*     */   }
/*     */ 
/*     */   public TransactionStatusManager(String serviceName)
/*     */   {
/*  88 */     int port = getTsmPort();
/*     */ 
/*  90 */     start(serviceName, port);
/*     */   }
/*     */ 
/*     */   public TransactionStatusManager(String serviceName, int port)
/*     */   {
/*  95 */     start(serviceName, port);
/*     */   }
/*     */ 
/*     */   public void addService(Service service, ServerSocket serverSocket)
/*     */   {
/*     */     try
/*     */     {
/* 105 */       this._listener = new Listener(serverSocket, service);
/* 106 */       this._listener.setDaemon(true);
/*     */ 
/* 108 */       if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */       {
/* 110 */         tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_1", new Object[] { service.getClass().getName(), Integer.toString(serverSocket.getLocalPort()) });
/*     */       }
/*     */ 
/* 115 */       this._listener.start();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 119 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_2");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 129 */     if (!this._finalizeCalled)
/*     */     {
/* 131 */       this._finalizeCalled = true;
/*     */ 
/* 133 */       this._listener.stopListener();
/* 134 */       TransactionStatusManagerItem.removeThis(Utility.getProcessUid());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void start(String serviceName, int port)
/*     */   {
/* 143 */     int localPort = 0;
/*     */     try
/*     */     {
/* 147 */       Class serviceClass = Thread.currentThread().getContextClassLoader().loadClass(serviceName);
/*     */ 
/* 149 */       Service service = (Service)serviceClass.newInstance();
/*     */ 
/* 151 */       ServerSocket socketServer = getTsmServerSocket(port);
/*     */ 
/* 153 */       localPort = socketServer.getLocalPort();
/*     */ 
/* 155 */       addService(service, socketServer);
/*     */ 
/* 157 */       TransactionStatusManagerItem.createAndSave(socketServer.getLocalPort());
/*     */ 
/* 159 */       if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */       {
/* 161 */         tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_3", new Object[] { Integer.toString(localPort), serviceName });
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (ClassNotFoundException ex)
/*     */     {
/* 167 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 169 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_4", new Object[] { serviceName });
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (InstantiationException ex)
/*     */     {
/* 175 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 177 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_5", new Object[] { serviceName });
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IllegalAccessException ex)
/*     */     {
/* 183 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 185 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_6", new Object[] { serviceName });
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 191 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 193 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_7", new Object[] { Integer.toString(localPort) });
/*     */       }
/*     */ 
/* 197 */       throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_9"));
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final ServerSocket getTsmServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 211 */     ServerSocket socket = SocketProcessId.getSocket();
/*     */ 
/* 213 */     return socket == null ? new ServerSocket(port) : socket;
/*     */   }
/*     */ 
/*     */   private static final int getTsmPort()
/*     */   {
/* 227 */     if (SocketProcessId.getSocket() == null)
/*     */     {
/* 229 */       int port = 0;
/*     */ 
/* 233 */       String tsmPortStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerPort");
/*     */ 
/* 235 */       if (tsmPortStr != null)
/*     */       {
/*     */         try
/*     */         {
/* 239 */           port = Integer.parseInt(tsmPortStr);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 243 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 245 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_8", new Object[] { ex });
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 251 */       return port;
/*     */     }
/*     */ 
/* 254 */     return SocketProcessId.getSocket().getLocalPort();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.recovery.TransactionStatusManager
 * JD-Core Version:    0.6.0
 */