/*    */ package com.arjuna.ats.arjuna.recovery;
/*    */ 
/*    */ import java.io.BufferedReader;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStreamReader;
/*    */ import java.io.OutputStreamWriter;
/*    */ import java.io.PrintWriter;
/*    */ import java.net.InetAddress;
/*    */ import java.net.Socket;
/*    */ import java.net.SocketException;
/*    */ import java.net.UnknownHostException;
/*    */ 
/*    */ public class RecoveryDriver
/*    */ {
/* 97 */   private String _hostName = null;
/* 98 */   private int _port = 0;
/* 99 */   private int _timeout = 20000;
/*    */ 
/*    */   public RecoveryDriver(int port)
/*    */   {
/* 42 */     this(port, null, 20000);
/*    */   }
/*    */ 
/*    */   public RecoveryDriver(int port, String hostName)
/*    */   {
/* 47 */     this(port, hostName, 20000);
/*    */   }
/*    */ 
/*    */   public RecoveryDriver(int port, String hostName, int timeout)
/*    */   {
/* 52 */     this._port = port;
/* 53 */     this._hostName = hostName;
/* 54 */     this._timeout = timeout;
/*    */   }
/*    */ 
/*    */   public final boolean synchronousScan() throws UnknownHostException, SocketException, IOException
/*    */   {
/* 59 */     return scan("SCAN");
/*    */   }
/*    */ 
/*    */   public final boolean asynchronousScan() throws UnknownHostException, SocketException, IOException
/*    */   {
/* 64 */     return scan("ASYNC_SCAN");
/*    */   }
/*    */ 
/*    */   private final boolean scan(String scanType) throws UnknownHostException, SocketException, IOException
/*    */   {
/* 69 */     if (this._hostName == null) {
/* 70 */       this._hostName = InetAddress.getLocalHost().getHostName();
/*    */     }
/* 72 */     Socket connectorSocket = new Socket(this._hostName, this._port);
/*    */ 
/* 74 */     connectorSocket.setSoTimeout(this._timeout);
/*    */ 
/* 78 */     BufferedReader fromServer = new BufferedReader(new InputStreamReader(connectorSocket.getInputStream()));
/*    */ 
/* 80 */     PrintWriter toServer = new PrintWriter(new OutputStreamWriter(connectorSocket.getOutputStream()));
/*    */ 
/* 82 */     toServer.println(scanType);
/*    */ 
/* 84 */     toServer.flush();
/*    */ 
/* 86 */     String response = fromServer.readLine();
/* 87 */     boolean success = false;
/*    */ 
/* 89 */     if (response.equals("DONE")) {
/* 90 */       success = true;
/*    */     }
/* 92 */     connectorSocket.close();
/*    */ 
/* 94 */     return success;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.recovery.RecoveryDriver
 * JD-Core Version:    0.6.0
 */