/*     */ package com.arjuna.ats.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class ObjectStoreType
/*     */ {
/*     */   public static final int ACTION = 0;
/*     */   public static final int ACTIONLOG = 1;
/*     */   public static final int SHADOWING = 2;
/*     */   public static final int FRAGMENTED = 3;
/*     */   public static final int VOLATILE = 4;
/*     */   public static final int HASHED = 5;
/*     */   public static final int REPLICATED = 6;
/*     */   public static final int MAPPED = 7;
/*     */   public static final int SINGLETYPEMAPPED = 8;
/*     */   public static final int USER_DEF_0 = 9;
/*     */   public static final int USER_DEF_1 = 10;
/*     */   public static final int USER_DEF_2 = 11;
/*     */   public static final int USER_DEF_3 = 12;
/*     */   public static final int USER_DEF_4 = 13;
/*     */   public static final int SHADOWNOFILELOCK = 14;
/*     */   public static final int JDBC = 15;
/*     */   public static final int JDBC_ACTION = 16;
/*     */   public static final int HASHED_ACTION = 17;
/*     */   public static final int CACHED = 18;
/*     */   public static final int NULL_ACTION = 19;
/*     */   public static final int USER_DEF_5 = 30;
/*     */   public static final int USER_DEF_6 = 31;
/*     */   public static final int USER_DEF_7 = 32;
/*     */   public static final int USER_DEF_8 = 33;
/*     */   public static final int USER_DEF_9 = 34;
/*     */ 
/*     */   public static final ClassName typeToClassName(int rt)
/*     */   {
/*  89 */     switch (rt)
/*     */     {
/*     */     case 0:
/*  92 */       return ArjunaNames.Implementation_ObjectStore_ActionStore();
/*     */     case 19:
/*  94 */       return ArjunaNames.Implementation_ObjectStore_NullActionStore();
/*     */     case 1:
/*  96 */       return ArjunaNames.Implementation_ObjectStore_ActionLogStore();
/*     */     case 2:
/*  98 */       return ArjunaNames.Implementation_ObjectStore_ShadowingStore();
/*     */     case 3:
/* 100 */       return ArjunaNames.Implementation_ObjectStore_FragmentedStore();
/*     */     case 4:
/* 102 */       return ArjunaNames.Implementation_ObjectStore_VolatileStore();
/*     */     case 5:
/* 104 */       return ArjunaNames.Implementation_ObjectStore_HashedStore();
/*     */     case 6:
/* 106 */       return ArjunaNames.Implementation_ObjectStore_ReplicatedStore();
/*     */     case 7:
/* 108 */       return ArjunaNames.Implementation_ObjectStore_MappedStore();
/*     */     case 8:
/* 110 */       return ArjunaNames.Implementation_ObjectStore_SingleTypeMappedStore();
/*     */     case 9:
/* 112 */       return ArjunaNames.Implementation_ObjectStore_UserDef0Store();
/*     */     case 10:
/* 114 */       return ArjunaNames.Implementation_ObjectStore_UserDef1Store();
/*     */     case 11:
/* 116 */       return ArjunaNames.Implementation_ObjectStore_UserDef2Store();
/*     */     case 12:
/* 118 */       return ArjunaNames.Implementation_ObjectStore_UserDef3Store();
/*     */     case 13:
/* 120 */       return ArjunaNames.Implementation_ObjectStore_UserDef4Store();
/*     */     case 14:
/* 122 */       return ArjunaNames.Implementation_ObjectStore_ShadowNoFileLockStore();
/*     */     case 15:
/* 124 */       return ArjunaNames.Implementation_ObjectStore_JDBCStore();
/*     */     case 16:
/* 126 */       return ArjunaNames.Implementation_ObjectStore_JDBCActionStore();
/*     */     case 17:
/* 128 */       return ArjunaNames.Implementation_ObjectStore_HashedActionStore();
/*     */     case 18:
/* 130 */       return ArjunaNames.Implementation_ObjectStore_CacheStore();
/*     */     case 30:
/* 132 */       return ArjunaNames.Implementation_ObjectStore_UserDef5Store();
/*     */     case 31:
/* 134 */       return ArjunaNames.Implementation_ObjectStore_UserDef6Store();
/*     */     case 32:
/* 136 */       return ArjunaNames.Implementation_ObjectStore_UserDef7Store();
/*     */     case 33:
/* 138 */       return ArjunaNames.Implementation_ObjectStore_UserDef8Store();
/*     */     case 34:
/* 140 */       return ArjunaNames.Implementation_ObjectStore_UserDef9Store();
/*     */     case 20:
/*     */     case 21:
/*     */     case 22:
/*     */     case 23:
/*     */     case 24:
/*     */     case 25:
/*     */     case 26:
/*     */     case 27:
/*     */     case 28:
/* 142 */     case 29: } return null;
/*     */   }
/*     */ 
/*     */   public static final int classNameToType(ClassName c)
/*     */   {
/* 157 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_ActionStore()))
/* 158 */       return 0;
/* 159 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_NullActionStore()))
/* 160 */       return 19;
/* 161 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_ActionLogStore()))
/* 162 */       return 1;
/* 163 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_ShadowingStore()))
/* 164 */       return 2;
/* 165 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_FragmentedStore()))
/* 166 */       return 3;
/* 167 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_VolatileStore()))
/* 168 */       return 4;
/* 169 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_HashedStore()))
/* 170 */       return 5;
/* 171 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_ReplicatedStore()))
/* 172 */       return 6;
/* 173 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_MappedStore()))
/* 174 */       return 7;
/* 175 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_SingleTypeMappedStore()))
/* 176 */       return 8;
/* 177 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_ShadowNoFileLockStore()))
/* 178 */       return 14;
/* 179 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_JDBCStore()))
/* 180 */       return 15;
/* 181 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_JDBCActionStore()))
/* 182 */       return 16;
/* 183 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_HashedActionStore()))
/* 184 */       return 17;
/* 185 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_CacheStore()))
/* 186 */       return 18;
/* 187 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef0Store()))
/* 188 */       return 9;
/* 189 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef1Store()))
/* 190 */       return 10;
/* 191 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef2Store()))
/* 192 */       return 11;
/* 193 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef3Store()))
/* 194 */       return 12;
/* 195 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef4Store()))
/* 196 */       return 13;
/* 197 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef5Store()))
/* 198 */       return 30;
/* 199 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef6Store()))
/* 200 */       return 31;
/* 201 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef7Store()))
/* 202 */       return 32;
/* 203 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef8Store()))
/* 204 */       return 33;
/* 205 */     if (c.equals(ArjunaNames.Implementation_ObjectStore_UserDef9Store())) {
/* 206 */       return 34;
/*     */     }
/* 208 */     if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */     {
/* 210 */       tsLogger.arjLoggerI18N.warn("ObjectStoreType_1", new Object[] { c });
/*     */     }
/*     */ 
/* 213 */     throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStoreType_2") + c);
/*     */   }
/*     */ 
/*     */   public static final void print(PrintWriter strm, int rt)
/*     */   {
/* 223 */     ClassName c = typeToClassName(rt);
/*     */ 
/* 225 */     strm.print(c);
/*     */ 
/* 227 */     c = null;
/*     */   }
/*     */ 
/*     */   public static final boolean valid(int rt)
/*     */   {
/* 238 */     return typeToClassName(rt) != null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.objectstore.ObjectStoreType
 * JD-Core Version:    0.6.0
 */