/*     */ package com.arjuna.ats.arjuna.gandiva;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.gandiva.nameservice.NameService;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class ObjectName
/*     */ {
/*     */   public static final int SIGNED_NUMBER = 0;
/*     */   public static final int UNSIGNED_NUMBER = 1;
/*     */   public static final int STRING = 2;
/*     */   public static final int OBJECTNAME = 3;
/*     */   public static final int CLASSNAME = 4;
/*     */   public static final int UID = 5;
/*     */   private String _mech;
/*     */   private String _name;
/*     */   private NameService _nameService;
/*     */   private static final String _invalidString = "invalid";
/*     */   private static final String nameServiceString = "NameServiceImple";
/*     */   private static final String nameDelim = ":";
/*     */   private static final String nullString = "";
/* 554 */   private static final ObjectName _invalid = new ObjectName("invalid:invalid");
/*     */ 
/*     */   public ObjectName(String objectName)
/*     */   {
/*  84 */     this._mech = null;
/*  85 */     this._name = null;
/*  86 */     this._nameService = null;
/*     */ 
/*  88 */     if (objectName == null)
/*     */     {
/*  90 */       this._mech = "invalid";
/*  91 */       this._name = "invalid";
/*     */     }
/*     */     else
/*     */     {
/*  95 */       int mechLength = objectName.indexOf(":");
/*     */ 
/*  97 */       if (mechLength != -1)
/*     */       {
/*  99 */         int nameLength = objectName.length() - mechLength - ":".length();
/*     */ 
/* 101 */         this._mech = new String(objectName.substring(0, mechLength));
/*     */ 
/* 103 */         if (nameLength > 0)
/* 104 */           this._name = objectName.substring(mechLength + ":".length(), objectName.length());
/*     */         else {
/* 106 */           this._name = new String("");
/*     */         }
/*     */       }
/*     */     }
/* 110 */     initNameService();
/*     */   }
/*     */ 
/*     */   public ObjectName(ObjectName objectName)
/*     */   {
/* 119 */     this._mech = null;
/* 120 */     this._name = null;
/* 121 */     this._nameService = null;
/*     */ 
/* 123 */     copy(objectName);
/*     */   }
/*     */ 
/*     */   public ObjectName(NameService nameService, String objectName)
/*     */   {
/* 133 */     this._mech = null;
/* 134 */     this._name = null;
/* 135 */     this._nameService = null;
/*     */ 
/* 137 */     if ((nameService != null) && (objectName != null))
/*     */     {
/* 139 */       this._nameService = nameService;
/*     */ 
/* 141 */       String fullMechName = this._nameService.impleClassName().stringForm();
/* 142 */       int appendedString = fullMechName.indexOf("NameServiceImple");
/*     */ 
/* 144 */       this._mech = new String(fullMechName.substring(0, appendedString - fullMechName.length()));
/* 145 */       this._name = new String(objectName);
/*     */     }
/*     */     else
/*     */     {
/* 149 */       if (nameService == null) {
/* 150 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.gandiva.ObjectName_1");
/*     */       }
/* 152 */       if (objectName == null) {
/* 153 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.gandiva.ObjectName_2");
/*     */       }
/* 155 */       this._mech = "invalid";
/* 156 */       this._name = "invalid";
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 162 */     this._mech = null;
/* 163 */     this._name = null;
/* 164 */     this._nameService = null;
/*     */   }
/*     */ 
/*     */   public int attributeType(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 173 */     if (this._nameService != null) {
/* 174 */       return this._nameService.attributeType(this._name, attrName);
/*     */     }
/* 176 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public String firstAttributeName()
/*     */     throws NullPointerException, IOException
/*     */   {
/* 185 */     if (this._nameService != null) {
/* 186 */       return this._nameService.firstAttributeName(this._name);
/*     */     }
/* 188 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public String nextAttributeName(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 197 */     if (this._nameService != null) {
/* 198 */       return this._nameService.nextAttributeName(this._name, attrName);
/*     */     }
/* 200 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public long getLongAttribute(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 211 */     if (this._nameService != null) {
/* 212 */       return this._nameService.getLongAttribute(this._name, attrName);
/*     */     }
/* 214 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public String getStringAttribute(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 225 */     if (this._nameService != null) {
/* 226 */       return this._nameService.getStringAttribute(this._name, attrName);
/*     */     }
/* 228 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectNameAttribute(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 239 */     if (this._nameService != null) {
/* 240 */       return this._nameService.getObjectNameAttribute(this._name, attrName);
/*     */     }
/* 242 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public ClassName getClassNameAttribute(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 253 */     if (this._nameService != null) {
/* 254 */       return this._nameService.getClassNameAttribute(this._name, attrName);
/*     */     }
/* 256 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public Uid getUidAttribute(String attrName)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 267 */     if (this._nameService != null) {
/* 268 */       return this._nameService.getUidAttribute(this._name, attrName);
/*     */     }
/* 270 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public void setLongAttribute(String attrName, long value)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 280 */     if (this._nameService != null)
/* 281 */       this._name = this._nameService.setLongAttribute(this._name, attrName, value);
/*     */     else
/* 283 */       throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public void setStringAttribute(String attrName, String value)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 293 */     if (this._nameService != null)
/* 294 */       this._name = this._nameService.setStringAttribute(this._name, attrName, value);
/*     */     else
/* 296 */       throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public void setObjectNameAttribute(String attrName, ObjectName value)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 306 */     if (this._nameService != null)
/* 307 */       this._name = this._nameService.setObjectNameAttribute(this._name, attrName, value);
/*     */     else
/* 309 */       throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public void setClassNameAttribute(String attrName, ClassName value)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 319 */     if (this._nameService != null)
/* 320 */       this._name = this._nameService.setClassNameAttribute(this._name, attrName, value);
/*     */     else
/* 322 */       throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public void setUidAttribute(String attrName, Uid value)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 332 */     if (this._nameService != null)
/* 333 */       this._name = this._nameService.setUidAttribute(this._name, attrName, value);
/*     */     else
/* 335 */       throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public boolean removeAttribute(String attrName)
/*     */     throws IOException
/*     */   {
/* 345 */     if (this._nameService != null)
/*     */     {
/* 347 */       this._name = this._nameService.removeAttribute(this._name, attrName);
/*     */ 
/* 349 */       if (this._name != null) {
/* 350 */         return true;
/*     */       }
/*     */     }
/* 353 */     return false;
/*     */   }
/*     */ 
/*     */   public String uniqueAttributeName()
/*     */     throws NullPointerException, IOException
/*     */   {
/* 364 */     if (this._nameService != null) {
/* 365 */       return this._nameService.uniqueAttributeName(this._name);
/*     */     }
/* 367 */     throw new NullPointerException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.gandiva.ObjectName_3"));
/*     */   }
/*     */ 
/*     */   public static ObjectName uniqueObjectName(String mech)
/*     */     throws NullPointerException, IOException
/*     */   {
/* 377 */     NameService nameService = null;
/* 378 */     ObjectName objectName = invalid();
/*     */ 
/* 380 */     if ((mech != null) && (mech.compareTo("invalid") != 0))
/*     */     {
/* 382 */       String nameServiceMech = mech + "NameServiceImple";
/* 383 */       ClassName nameServiceMechClassName = new ClassName(nameServiceMech);
/* 384 */       nameService = NameService.create(nameServiceMechClassName);
/*     */ 
/* 386 */       if (nameService != null) {
/* 387 */         objectName = nameService.uniqueObjectName();
/*     */       }
/* 389 */       nameService = null;
/*     */     }
/*     */ 
/* 392 */     return objectName;
/*     */   }
/*     */ 
/*     */   public synchronized void copy(ObjectName objectName)
/*     */   {
/* 401 */     if (objectName == this) {
/* 402 */       return;
/*     */     }
/* 404 */     this._nameService = null;
/* 405 */     this._mech = null;
/* 406 */     this._name = null;
/*     */ 
/* 408 */     if (objectName._mech != null)
/*     */     {
/* 410 */       this._mech = new String(objectName._mech);
/*     */ 
/* 412 */       if (objectName._nameService != null) {
/* 413 */         this._nameService = new NameService(objectName._nameService);
/*     */       }
/*     */     }
/* 416 */     if (objectName._name != null) {
/* 417 */       this._name = new String(objectName._name);
/*     */     }
/* 419 */     initNameService();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 428 */     if ((o instanceof ObjectName)) {
/* 429 */       return equals((ObjectName)o);
/*     */     }
/* 431 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(ObjectName objectName)
/*     */   {
/* 440 */     return ((this._name == objectName._name) || ((this._name != null) && (objectName._name != null) && (this._name.compareTo(objectName._name) == 0))) && ((this._mech == objectName._mech) || ((this._mech != null) && (objectName._mech != null) && (this._mech.compareTo(objectName._mech) == 0)));
/*     */   }
/*     */ 
/*     */   public boolean notEquals(ObjectName objectName)
/*     */   {
/* 452 */     return ((this._name != objectName._name) && ((this._name == null) || (objectName._name == null) || (this._name.compareTo(objectName._name) != 0))) || ((this._mech != objectName._mech) && ((this._mech == null) || (objectName._mech == null) || (this._mech.compareTo(objectName._mech) != 0)));
/*     */   }
/*     */ 
/*     */   public String getMechanismName()
/*     */   {
/* 465 */     return this._mech;
/*     */   }
/*     */ 
/*     */   public String stringForm()
/*     */   {
/* 474 */     return new String(this._mech + ":" + this._name);
/*     */   }
/*     */ 
/*     */   public static ObjectName invalid()
/*     */   {
/* 483 */     return _invalid;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 488 */     strm.print("<ObjectName:" + this._mech + ":" + this._name + ">");
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 493 */     return stringForm();
/*     */   }
/*     */ 
/*     */   public static void print(int t)
/*     */   {
/* 502 */     switch (t)
/*     */     {
/*     */     case 0:
/* 505 */       System.out.print("SIGNED_NUMBER");
/* 506 */       break;
/*     */     case 1:
/* 508 */       System.out.print("UNSIGNED_NUMBER");
/* 509 */       break;
/*     */     case 2:
/* 511 */       System.out.print("STRING");
/* 512 */       break;
/*     */     case 3:
/* 514 */       System.out.print("OBJECTNAME");
/* 515 */       break;
/*     */     case 4:
/* 517 */       System.out.print("CLASSNAME");
/* 518 */       break;
/*     */     case 5:
/* 520 */       System.out.print("UID");
/* 521 */       break;
/*     */     default:
/* 523 */       System.out.print("Unknown");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void initNameService()
/*     */   {
/* 530 */     if (this._nameService != null) {
/* 531 */       return;
/*     */     }
/* 533 */     if ((this._mech != null) && (this._mech.compareTo("invalid") != 0))
/*     */     {
/* 535 */       String nameServiceMech = new String(this._mech + "NameServiceImple");
/* 536 */       ClassName nameServiceMechClassName = new ClassName(nameServiceMech);
/*     */ 
/* 538 */       this._nameService = NameService.create(nameServiceMechClassName);
/*     */ 
/* 540 */       nameServiceMech = null;
/*     */     }
/*     */     else {
/* 543 */       this._nameService = null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.gandiva.ObjectName
 * JD-Core Version:    0.6.0
 */