/*     */ package com.arjuna.ats.arjuna.gandiva;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class ClassName
/*     */ {
/*     */   private String _className;
/* 141 */   private static final ClassName _invalid = new ClassName("$Invalid");
/*     */ 
/*     */   public ClassName()
/*     */   {
/*  54 */     copy(invalid());
/*     */   }
/*     */ 
/*     */   public ClassName(String className)
/*     */   {
/*  59 */     this._className = null;
/*     */ 
/*  61 */     if (className != null)
/*  62 */       this._className = new String(className);
/*     */     else
/*  64 */       copy(invalid());
/*     */   }
/*     */ 
/*     */   public ClassName(ClassName name)
/*     */   {
/*  69 */     this._className = null;
/*     */ 
/*  71 */     copy(name);
/*     */   }
/*     */ 
/*     */   public static ClassName invalid()
/*     */   {
/*  76 */     return _invalid;
/*     */   }
/*     */ 
/*     */   public String stringForm()
/*     */   {
/*  81 */     return this._className;
/*     */   }
/*     */ 
/*     */   public void pack(OutputBuffer buff) throws IOException
/*     */   {
/*  86 */     buff.packString(this._className);
/*     */   }
/*     */ 
/*     */   public void unpack(InputBuffer buff) throws IOException
/*     */   {
/*  91 */     this._className = buff.unpackString();
/*     */   }
/*     */ 
/*     */   public void copy(ClassName className)
/*     */   {
/* 100 */     if (this == className) {
/* 101 */       return;
/*     */     }
/* 103 */     if (className._className != null) {
/* 104 */       this._className = new String(className._className);
/*     */     }
/* 107 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 108 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.gandiva.ClassName_1");
/*     */   }
/*     */ 
/*     */   public boolean equals(ClassName className)
/*     */   {
/* 114 */     if ((className == null) && (this._className == null)) {
/* 115 */       return false;
/*     */     }
/* 117 */     if (className == null) {
/* 118 */       return false;
/*     */     }
/* 120 */     if (this._className != className._className) {
/* 121 */       return this._className.compareTo(className._className) == 0;
/*     */     }
/* 123 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean notEquals(ClassName className)
/*     */   {
/* 128 */     if (this._className == className._className) {
/* 129 */       return false;
/*     */     }
/* 131 */     return this._className.compareTo(className._className) != 0;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     return new String("<ClassName:" + this._className + ">");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.gandiva.ClassName
 * JD-Core Version:    0.6.0
 */