/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.util.Calendar;
/*     */ import java.util.Collection;
/*     */ 
/*     */ public class TxStats
/*     */ {
/* 246 */   private static int _numberOfTransactions = 0;
/* 247 */   private static Object _ntxLock = new Object();
/* 248 */   private static int _numberOfNestedTransactions = 0;
/* 249 */   private static Object _nntxLock = new Object();
/* 250 */   private static int _numberOfCommittedTransactions = 0;
/* 251 */   private static Object _ncmLock = new Object();
/* 252 */   private static int _numberOfAbortedTransactions = 0;
/* 253 */   private static Object _nabLock = new Object();
/* 254 */   private static int _numberOfHeuristics = 0;
/* 255 */   private static Object _nhLock = new Object();
/* 256 */   private static int _numberOfTimeouts = 0;
/* 257 */   private static final Object _notLock = new Object();
/* 258 */   private static int _numberOfApplicationAborts = 0;
/* 259 */   private static final Object _noaaLock = new Object();
/* 260 */   private static int _numberOfResourceAborts = 0;
/* 261 */   private static final Object _noraLock = new Object();
/*     */ 
/*     */   public static int numberOfTransactions()
/*     */   {
/*  53 */     synchronized (_ntxLock)
/*     */     {
/*  55 */       return _numberOfTransactions;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfNestedTransactions()
/*     */   {
/*  65 */     synchronized (_nntxLock)
/*     */     {
/*  67 */       return _numberOfNestedTransactions;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfHeuristics()
/*     */   {
/*  78 */     synchronized (_nhLock)
/*     */     {
/*  80 */       return _numberOfHeuristics;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfCommittedTransactions()
/*     */   {
/*  90 */     synchronized (_ncmLock)
/*     */     {
/*  92 */       return _numberOfCommittedTransactions;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfAbortedTransactions()
/*     */   {
/* 102 */     synchronized (_nabLock)
/*     */     {
/* 104 */       return _numberOfAbortedTransactions;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfInflightTransactions()
/*     */   {
/* 114 */     return ActionManager.manager().inflightTransactions().size();
/*     */   }
/*     */ 
/*     */   public static int numberOfTimedOutTransactions()
/*     */   {
/* 123 */     synchronized (_notLock)
/*     */     {
/* 125 */       return _numberOfTimeouts;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfApplicationRollbacks()
/*     */   {
/* 135 */     synchronized (_noaaLock)
/*     */     {
/* 137 */       return _numberOfApplicationAborts;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static int numberOfResourceRollbacks()
/*     */   {
/* 147 */     synchronized (_noraLock)
/*     */     {
/* 149 */       return _numberOfResourceAborts;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void printStatus(PrintWriter pw)
/*     */   {
/* 161 */     pw.println("JBoss Transaction Service statistics.");
/* 162 */     pw.println(Calendar.getInstance().getTime() + "\n");
/*     */ 
/* 164 */     pw.println("Number of created transactions: " + numberOfTransactions());
/* 165 */     pw.println("Number of nested transactions: " + numberOfNestedTransactions());
/*     */ 
/* 167 */     pw.println("Number of heuristics: " + numberOfHeuristics());
/* 168 */     pw.println("Number of committed transactions: " + numberOfCommittedTransactions());
/*     */ 
/* 170 */     pw.println("Number of rolled back transactions: " + numberOfAbortedTransactions());
/*     */ 
/* 172 */     pw.println("Number of inflight transactions: " + numberOfInflightTransactions());
/*     */ 
/* 174 */     pw.println("Number of timed-out transactions: " + numberOfTimedOutTransactions());
/*     */ 
/* 176 */     pw.println("Number of application rolled back transactions: " + numberOfApplicationRollbacks());
/*     */ 
/* 178 */     pw.println("Number of resource rolled back transactions: " + numberOfResourceRollbacks());
/*     */   }
/*     */ 
/*     */   static void incrementTransactions()
/*     */   {
/* 184 */     synchronized (_ntxLock)
/*     */     {
/* 186 */       _numberOfTransactions += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementNestedTransactions()
/*     */   {
/* 192 */     synchronized (_nntxLock)
/*     */     {
/* 194 */       _numberOfNestedTransactions += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementAbortedTransactions()
/*     */   {
/* 200 */     synchronized (_nabLock)
/*     */     {
/* 202 */       _numberOfAbortedTransactions += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementCommittedTransactions()
/*     */   {
/* 208 */     synchronized (_ncmLock)
/*     */     {
/* 210 */       _numberOfCommittedTransactions += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementHeuristics()
/*     */   {
/* 216 */     synchronized (_nhLock)
/*     */     {
/* 218 */       _numberOfHeuristics += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementTimeouts()
/*     */   {
/* 224 */     synchronized (_notLock)
/*     */     {
/* 226 */       _numberOfTimeouts += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementApplicationRollbacks()
/*     */   {
/* 232 */     synchronized (_noaaLock)
/*     */     {
/* 234 */       _numberOfApplicationAborts += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   static void incrementResourceRollbacks()
/*     */   {
/* 240 */     synchronized (_noraLock)
/*     */     {
/* 242 */       _numberOfResourceAborts += 1;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.TxStats
 * JD-Core Version:    0.6.0
 */