/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
/*     */ 
/*     */ class AsyncCommit extends Thread
/*     */ {
/*     */   private BasicAction _theAction;
/*     */   private boolean _commit;
/*     */ 
/*     */   public static AsyncCommit create(BasicAction toControl, boolean commit)
/*     */   {
/*  63 */     AsyncCommit c = new AsyncCommit(toControl, commit);
/*     */ 
/*  65 */     c.start();
/*     */ 
/*  67 */     Thread.yield();
/*     */ 
/*  69 */     return c;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  78 */     if (this._theAction != null)
/*     */     {
/*  89 */       ThreadActionData.pushAction(this._theAction, false);
/*     */ 
/*  91 */       if (this._commit)
/*  92 */         doPhase2Commit();
/*     */       else {
/*  94 */         doPhase2Abort();
/*     */       }
/*  96 */       ThreadActionData.popAction(false);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected AsyncCommit(BasicAction toControl, boolean commit)
/*     */   {
/* 106 */     this._theAction = toControl;
/* 107 */     this._commit = commit;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean doPhase2Commit()
/*     */   {
/* 116 */     if (this._theAction != null)
/*     */     {
/* 123 */       this._theAction.phase2Commit(false);
/*     */ 
/* 125 */       return true;
/*     */     }
/*     */ 
/* 128 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean doPhase2Abort()
/*     */   {
/* 137 */     if (this._theAction != null)
/*     */     {
/* 139 */       this._theAction.phase2Abort(false);
/*     */ 
/* 141 */       return true;
/*     */     }
/*     */ 
/* 144 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.AsyncCommit
 * JD-Core Version:    0.6.0
 */