/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import java.util.Collection;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class ActionManager
/*     */ {
/* 115 */   private static final ActionManager _theManager = new ActionManager();
/*     */ 
/* 117 */   private static final Hashtable _allActions = new Hashtable();
/*     */ 
/*     */   public static final ActionManager manager()
/*     */   {
/*  73 */     return _theManager;
/*     */   }
/*     */ 
/*     */   public void put(BasicAction act)
/*     */   {
/*  78 */     _allActions.put(act.get_uid(), new Lifetime(act));
/*     */   }
/*     */ 
/*     */   public BasicAction get(Uid id)
/*     */   {
/*  83 */     Lifetime lt = (Lifetime)_allActions.get(id);
/*     */ 
/*  85 */     if (lt != null) {
/*  86 */       return lt.getAction();
/*     */     }
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   public long getTimeAdded(Uid id)
/*     */   {
/*  93 */     Lifetime lt = (Lifetime)_allActions.get(id);
/*     */ 
/*  95 */     if (lt != null) {
/*  96 */       return lt.getTimeAdded();
/*     */     }
/*  98 */     return 0L;
/*     */   }
/*     */ 
/*     */   public void remove(Uid id)
/*     */   {
/* 103 */     _allActions.remove(id);
/*     */   }
/*     */ 
/*     */   public Collection inflightTransactions()
/*     */   {
/* 108 */     return _allActions.values();
/*     */   }
/*     */ 
/*     */   class Lifetime
/*     */   {
/*     */     private BasicAction theAction;
/*     */     private long timeAdded;
/*     */ 
/*     */     public Lifetime(BasicAction act)
/*     */     {
/*  53 */       this.theAction = act;
/*  54 */       this.timeAdded = System.currentTimeMillis();
/*     */     }
/*     */ 
/*     */     public BasicAction getAction()
/*     */     {
/*  59 */       return this.theAction;
/*     */     }
/*     */ 
/*     */     public long getTimeAdded()
/*     */     {
/*  64 */       return this.timeAdded;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.ActionManager
 * JD-Core Version:    0.6.0
 */