/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.StateManager;
/*     */ import com.arjuna.ats.arjuna.common.Configuration;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.Inventory;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public abstract class AbstractRecord extends StateManager
/*     */ {
/*     */   private AbstractRecord next;
/*     */   private AbstractRecord previous;
/*     */   private Uid uidOfObject;
/*     */   private String typeOfObject;
/*     */ 
/*     */   public abstract int typeIs();
/*     */ 
/*     */   public abstract Object value();
/*     */ 
/*     */   public abstract void setValue(Object paramObject);
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 104 */     return new ClassName("" + typeIs());
/*     */   }
/*     */ 
/*     */   public abstract int nestedAbort();
/*     */ 
/*     */   public abstract int nestedCommit();
/*     */ 
/*     */   public abstract int nestedPrepare();
/*     */ 
/*     */   public abstract int topLevelAbort();
/*     */ 
/*     */   public abstract int topLevelCommit();
/*     */ 
/*     */   public abstract int topLevelPrepare();
/*     */ 
/*     */   public Uid order()
/*     */   {
/* 182 */     return this.uidOfObject;
/*     */   }
/*     */ 
/*     */   public String getTypeOfObject()
/*     */   {
/* 195 */     return this.typeOfObject;
/*     */   }
/*     */ 
/*     */   public boolean propagateOnAbort()
/*     */   {
/* 209 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean propagateOnCommit()
/*     */   {
/* 223 */     return true;
/*     */   }
/*     */ 
/*     */   public final boolean equals(AbstractRecord ar)
/*     */   {
/* 241 */     return Configuration.useAlternativeOrdering() ? typeEquals(ar) : orderEquals(ar);
/*     */   }
/*     */ 
/*     */   public final boolean lessThan(AbstractRecord ar)
/*     */   {
/* 254 */     return Configuration.useAlternativeOrdering() ? typeLessThan(ar) : orderLessThan(ar);
/*     */   }
/*     */ 
/*     */   public final boolean greaterThan(AbstractRecord ar)
/*     */   {
/* 267 */     return Configuration.useAlternativeOrdering() ? typeGreaterThan(ar) : orderGreaterThan(ar);
/*     */   }
/*     */ 
/*     */   public int topLevelCleanup()
/*     */   {
/* 283 */     return topLevelAbort();
/*     */   }
/*     */ 
/*     */   public int nestedCleanup()
/*     */   {
/* 298 */     return nestedAbort();
/*     */   }
/*     */ 
/*     */   public boolean doSave()
/*     */   {
/* 313 */     return false;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 322 */     return "/StateManager/AbstractRecord";
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 334 */     strm.println("Uid of Managed Object: " + this.uidOfObject);
/* 335 */     strm.println("Type of Managed Object: " + this.typeOfObject);
/* 336 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, int i)
/*     */   {
/*     */     try
/*     */     {
/* 355 */       this.uidOfObject.pack(os);
/* 356 */       os.packString(this.typeOfObject);
/*     */ 
/* 358 */       return true;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 362 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int i)
/*     */   {
/* 380 */     this.typeOfObject = null;
/*     */     try
/*     */     {
/* 384 */       this.uidOfObject.unpack(os);
/* 385 */       this.typeOfObject = os.unpackString();
/*     */ 
/* 387 */       return true;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 391 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean forgetHeuristic()
/*     */   {
/* 407 */     return true;
/*     */   }
/*     */ 
/*     */   public int nestedOnePhaseCommit()
/*     */   {
/* 419 */     int res = nestedPrepare();
/*     */ 
/* 421 */     switch (res)
/*     */     {
/*     */     case 0:
/* 424 */       return nestedCommit();
/*     */     case 2:
/* 426 */       return 7;
/*     */     }
/* 428 */     return 8;
/*     */   }
/*     */ 
/*     */   public int topLevelOnePhaseCommit()
/*     */   {
/* 441 */     int res = topLevelPrepare();
/*     */ 
/* 443 */     switch (res)
/*     */     {
/*     */     case 0:
/* 446 */       return topLevelCommit();
/*     */     case 2:
/* 448 */       return 7;
/*     */     }
/* 450 */     return 8;
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create(ClassName cName)
/*     */   {
/* 468 */     Object ptr = Inventory.inventory().createVoid(cName);
/* 469 */     AbstractRecord record = null;
/*     */ 
/* 471 */     if ((ptr instanceof AbstractRecord))
/* 472 */       record = (AbstractRecord)ptr;
/*     */     else {
/* 474 */       record = null;
/*     */     }
/* 476 */     return record;
/*     */   }
/*     */ 
/*     */   public abstract void merge(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public abstract void alter(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public abstract boolean shouldAdd(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public abstract boolean shouldAlter(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public abstract boolean shouldMerge(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public abstract boolean shouldReplace(AbstractRecord paramAbstractRecord);
/*     */ 
/*     */   public void replace(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected final AbstractRecord getPrevious()
/*     */   {
/* 569 */     return this.previous;
/*     */   }
/*     */ 
/*     */   protected final AbstractRecord getNext()
/*     */   {
/* 578 */     return this.next;
/*     */   }
/*     */ 
/*     */   protected final void setPrevious(AbstractRecord ar)
/*     */   {
/* 590 */     this.previous = ar;
/*     */   }
/*     */ 
/*     */   protected final void setNext(AbstractRecord ar)
/*     */   {
/* 602 */     this.next = ar;
/*     */   }
/*     */ 
/*     */   protected AbstractRecord(Uid storeUid, String objType, int otype)
/*     */   {
/* 619 */     super(otype);
/*     */ 
/* 621 */     this.next = null;
/* 622 */     this.previous = null;
/* 623 */     this.uidOfObject = storeUid;
/* 624 */     this.typeOfObject = objType;
/*     */ 
/* 626 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 628 */       tsLogger.arjLogger.debug(1L, 2L, 8L, "AbstractRecord::AbstractRecord (" + storeUid + ", " + otype + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected AbstractRecord(Uid storeUid)
/*     */   {
/* 642 */     super(storeUid);
/*     */ 
/* 644 */     this.next = null;
/* 645 */     this.previous = null;
/* 646 */     this.uidOfObject = storeUid;
/* 647 */     this.typeOfObject = null;
/*     */ 
/* 649 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 651 */       tsLogger.arjLogger.debug(1L, 2L, 8L, "AbstractRecord::AbstractRecord (" + storeUid + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected AbstractRecord()
/*     */   {
/* 667 */     super(Uid.nullUid());
/*     */ 
/* 669 */     this.next = null;
/* 670 */     this.previous = null;
/* 671 */     this.uidOfObject = new Uid(Uid.nullUid());
/* 672 */     this.typeOfObject = null;
/*     */ 
/* 674 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 676 */       tsLogger.arjLoggerI18N.debug(1L, 2L, 8L, "com.arjuna.ats.arjuna.coordinator.AbstractRecord_1");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final boolean typeEquals(AbstractRecord ar)
/*     */   {
/* 687 */     return (typeIs() == ar.typeIs()) && (order().equals(ar.order()));
/*     */   }
/*     */ 
/*     */   private final boolean typeLessThan(AbstractRecord ar)
/*     */   {
/* 692 */     return (typeIs() < ar.typeIs()) || ((typeIs() == ar.typeIs()) && (order().lessThan(ar.order())));
/*     */   }
/*     */ 
/*     */   private final boolean typeGreaterThan(AbstractRecord ar)
/*     */   {
/* 697 */     return (typeIs() > ar.typeIs()) || ((typeIs() == ar.typeIs()) && (order().greaterThan(ar.order())));
/*     */   }
/*     */ 
/*     */   private final boolean orderEquals(AbstractRecord ar)
/*     */   {
/* 702 */     return (order().equals(ar.order())) && (typeIs() == ar.typeIs());
/*     */   }
/*     */ 
/*     */   private final boolean orderLessThan(AbstractRecord ar)
/*     */   {
/* 707 */     return (order().lessThan(ar.order())) || ((order().equals(ar.order())) && (typeIs() < ar.typeIs()));
/*     */   }
/*     */ 
/*     */   private final boolean orderGreaterThan(AbstractRecord ar)
/*     */   {
/* 712 */     return (order().greaterThan(ar.order())) || ((order().equals(ar.order())) && (typeIs() > ar.typeIs()));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.AbstractRecord
 * JD-Core Version:    0.6.0
 */