/*     */ package com.arjuna.ats.arjuna.common;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.FileLocator;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class Configuration
/*     */ {
/*     */   private static final Properties PROPS;
/*     */   private static String _objectStore;
/*     */   private static boolean _useAltOrder;
/*     */   private static String _propFile;
/*     */ 
/*     */   public static final synchronized String propertiesFile()
/*     */   {
/*  73 */     return _propFile;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setPropertiesFile(String file)
/*     */   {
/*  82 */     _propFile = file;
/*     */   }
/*     */ 
/*     */   public static final synchronized String propertiesDir()
/*     */   {
/*  93 */     String propDir = ".";
/*     */     try
/*     */     {
/*  97 */       propDir = FileLocator.locateFile(propertiesFile());
/*     */     }
/*     */     catch (FileNotFoundException e)
/*     */     {
/* 101 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 102 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Configuration_1", new Object[] { propertiesFile() });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 107 */     return propDir;
/*     */   }
/*     */ 
/*     */   public static final String version()
/*     */   {
/* 116 */     return getBuildTimeProperty("ARJUNA_VERSION");
/*     */   }
/*     */ 
/*     */   public static final synchronized String objectStoreRoot()
/*     */   {
/* 127 */     if (_objectStore == null)
/*     */     {
/* 130 */       _objectStore = System.getProperty("user.dir") + File.separator + "ObjectStore";
/*     */     }
/*     */ 
/* 134 */     return _objectStore;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setObjectStoreRoot(String s)
/*     */   {
/* 145 */     _objectStore = s;
/*     */   }
/*     */ 
/*     */   public static final synchronized boolean useAlternativeOrdering()
/*     */   {
/* 158 */     return _useAltOrder;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setAlternativeOrdering(boolean b)
/*     */   {
/* 168 */     _useAltOrder = b;
/*     */   }
/*     */ 
/*     */   public static String getBuildTimeProperty(String name)
/*     */   {
/* 178 */     if (PROPS == null)
/*     */     {
/* 180 */       return "";
/*     */     }
/*     */ 
/* 184 */     return PROPS.getProperty(name, "");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 192 */     InputStream is = Configuration.class.getResourceAsStream("/arjuna.properties");
/* 193 */     if (is != null)
/*     */     {
/* 195 */       Properties props = new Properties();
/*     */       try
/*     */       {
/* 198 */         props.load(is);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 202 */         props = null;
/*     */       }
/* 204 */       PROPS = props;
/*     */     }
/*     */     else
/*     */     {
/* 208 */       PROPS = null;
/*     */     }
/*     */ 
/* 212 */     _objectStore = null;
/* 213 */     _useAltOrder = false;
/* 214 */     _propFile = getBuildTimeProperty("PROPERTIES_FILE");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.common.Configuration
 * JD-Core Version:    0.6.0
 */