/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ class RecoveryRecord extends AbstractRecord
/*     */ {
/*     */   protected StateManager objectAddr;
/*     */   protected OutputObjectState state;
/*     */   private BasicAction actionHandle;
/*     */ 
/*     */   public RecoveryRecord(OutputObjectState os, StateManager sm)
/*     */   {
/*  56 */     super(sm.get_uid(), sm.type(), 1);
/*     */ 
/*  58 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  60 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "RecoveryRecord::RecoveryRecord(" + os + ", " + sm.get_uid() + ")");
/*     */     }
/*     */ 
/*  65 */     this.objectAddr = sm;
/*  66 */     this.state = os;
/*  67 */     this.actionHandle = BasicAction.Current();
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  72 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  74 */       tsLogger.arjLogger.debug(2L, 4L, 8L, "RecoveryRecord.finalize() for " + order());
/*     */     }
/*     */ 
/*  78 */     this.state = null;
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  83 */     return 101;
/*     */   }
/*     */ 
/*     */   public Object value()
/*     */   {
/*  88 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void setValue(Object newState)
/*     */   {
/*  97 */     if ((newState instanceof OutputObjectState)) {
/*  98 */       this.state = ((OutputObjectState)newState);
/*     */     }
/* 101 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 102 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.RecoveryRecord_1");
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 115 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 117 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 126 */     forgetAction(false);
/*     */ 
/* 128 */     if (this.state != null)
/*     */     {
/* 130 */       if (this.state.notempty())
/*     */       {
/* 132 */         InputObjectState oldState = new InputObjectState(this.state);
/*     */ 
/* 134 */         int result = this.objectAddr.restore_state(oldState, 0) ? 7 : 8;
/*     */ 
/* 136 */         if (result == 8)
/*     */         {
/* 138 */           if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 139 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.RecoveryRecord_2");
/*     */           }
/*     */         }
/* 142 */         return result;
/*     */       }
/*     */     }
/*     */ 
/* 146 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedCommit()
/*     */   {
/* 158 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 160 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::nestedCommit() for " + order());
/*     */     }
/*     */ 
/* 164 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 169 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 171 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 175 */     forgetAction(true);
/*     */ 
/* 177 */     return 2;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 188 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 190 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 195 */     return nestedAbort();
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 206 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 208 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 213 */     forgetAction(true);
/*     */ 
/* 215 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 225 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 227 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "RecoveryRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 232 */     return 2;
/*     */   }
/*     */ 
/*     */   public boolean doSave()
/*     */   {
/* 246 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int ot)
/*     */   {
/* 251 */     return super.restore_state(os, ot);
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, int ot)
/*     */   {
/* 256 */     return super.save_state(os, ot);
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 261 */     super.print(strm);
/* 262 */     strm.println("RecoveryRecord with state:\n" + this.state);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 267 */     return "/StateManager/AbstractRecord/RecoveryRecord";
/*     */   }
/*     */ 
/*     */   public void merge(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void alter(AbstractRecord a)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean shouldAdd(AbstractRecord a)
/*     */   {
/* 291 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldAlter(AbstractRecord a)
/*     */   {
/* 296 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord a)
/*     */   {
/* 301 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord a)
/*     */   {
/* 306 */     return false;
/*     */   }
/*     */ 
/*     */   protected RecoveryRecord()
/*     */   {
/* 318 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 320 */       tsLogger.arjLogger.debug(1L, 2L, 8L, "RecoveryRecord::RecoveryRecord() - crash recovery constructor");
/*     */     }
/*     */ 
/* 325 */     this.objectAddr = null;
/* 326 */     this.state = null;
/* 327 */     this.actionHandle = null;
/*     */   }
/*     */ 
/*     */   protected final void forgetAction(boolean commit)
/*     */   {
/* 337 */     if ((this.actionHandle != null) && (this.objectAddr != null))
/*     */     {
/* 339 */       this.objectAddr.forgetAction(this.actionHandle, commit, 101);
/* 340 */       this.actionHandle = null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.RecoveryRecord
 * JD-Core Version:    0.6.0
 */