/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
/*     */ import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class AtomicAction extends TwoPhaseCoordinator
/*     */ {
/*     */   public static final int NO_TIMEOUT = -1;
/* 417 */   private int _timeout = -1;
/*     */ 
/*     */   public AtomicAction()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AtomicAction(Uid objUid)
/*     */   {
/*  81 */     super(objUid);
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  96 */     ThreadActionData.purgeAction(this);
/*     */ 
/*  98 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public int begin()
/*     */   {
/* 112 */     return begin(-1);
/*     */   }
/*     */ 
/*     */   public int begin(int timeout)
/*     */   {
/* 131 */     int status = super.start();
/*     */ 
/* 133 */     if (status == 0)
/*     */     {
/* 139 */       ThreadActionData.pushAction(this);
/*     */ 
/* 141 */       this._timeout = timeout;
/*     */ 
/* 143 */       if (this._timeout == 0) {
/* 144 */         this._timeout = TxControl.getDefaultTimeout();
/*     */       }
/* 146 */       if (this._timeout > 0) {
/* 147 */         TransactionReaper.transactionReaper(true).insert(this, this._timeout);
/*     */       }
/*     */     }
/* 150 */     return status;
/*     */   }
/*     */ 
/*     */   public int commit()
/*     */   {
/* 162 */     return commit(true);
/*     */   }
/*     */ 
/*     */   public int commit(boolean report_heuristics)
/*     */   {
/* 177 */     int status = super.end(report_heuristics);
/*     */ 
/* 183 */     ThreadActionData.popAction();
/*     */ 
/* 185 */     TransactionReaper.create().remove(this);
/*     */ 
/* 187 */     return status;
/*     */   }
/*     */ 
/*     */   public int abort()
/*     */   {
/* 201 */     int status = super.cancel();
/*     */ 
/* 207 */     ThreadActionData.popAction();
/*     */ 
/* 209 */     TransactionReaper.create().remove(this);
/*     */ 
/* 211 */     return status;
/*     */   }
/*     */ 
/*     */   public int end(boolean report_heuristics)
/*     */   {
/* 216 */     int outcome = super.end(report_heuristics);
/*     */ 
/* 223 */     TransactionReaper.create().remove(this);
/*     */ 
/* 225 */     return outcome;
/*     */   }
/*     */ 
/*     */   public int cancel()
/*     */   {
/* 230 */     int outcome = super.cancel();
/*     */ 
/* 237 */     TransactionReaper.create().remove(this);
/*     */ 
/* 239 */     return outcome;
/*     */   }
/*     */ 
/*     */   public final int getTimeout()
/*     */   {
/* 248 */     return this._timeout;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 263 */     return "/StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction";
/*     */   }
/*     */ 
/*     */   public boolean addThread()
/*     */   {
/* 276 */     return addThread(Thread.currentThread());
/*     */   }
/*     */ 
/*     */   public boolean addThread(Thread t)
/*     */   {
/* 289 */     if (t != null)
/*     */     {
/* 291 */       ThreadActionData.pushAction(this);
/* 292 */       return true;
/*     */     }
/*     */ 
/* 295 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean removeThread()
/*     */   {
/* 308 */     return removeThread(Thread.currentThread());
/*     */   }
/*     */ 
/*     */   public boolean removeThread(Thread t)
/*     */   {
/* 321 */     if (t != null)
/*     */     {
/* 323 */       ThreadActionData.purgeAction(this);
/* 324 */       return true;
/*     */     }
/*     */ 
/* 327 */     return false;
/*     */   }
/*     */ 
/*     */   public static final AtomicAction suspend()
/*     */   {
/* 346 */     BasicAction curr = ThreadActionData.currentAction();
/*     */ 
/* 348 */     if (curr != null)
/*     */     {
/* 350 */       if ((curr instanceof AtomicAction)) {
/* 351 */         ThreadActionData.purgeActions();
/*     */       }
/*     */       else {
/* 354 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 356 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.atomicaction_1", new Object[] { curr.toString() });
/*     */         }
/*     */ 
/* 360 */         curr = null;
/*     */       }
/*     */     }
/*     */ 
/* 364 */     return (AtomicAction)curr;
/*     */   }
/*     */ 
/*     */   public static final boolean resume(AtomicAction act)
/*     */   {
/* 384 */     if (act == null)
/*     */     {
/* 386 */       suspend();
/*     */     }
/*     */     else {
/* 389 */       ThreadActionData.restoreActions(act);
/*     */     }
/* 391 */     return true;
/*     */   }
/*     */ 
/*     */   protected AtomicAction(int at)
/*     */   {
/* 400 */     super(at);
/*     */   }
/*     */ 
/*     */   protected boolean checkForCurrent()
/*     */   {
/* 414 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.AtomicAction
 * JD-Core Version:    0.6.0
 */