/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.annotation.impl;

import java.lang.annotation.Annotation;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.util.Debugger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBindingImpl
implements RemoteBinding {
    private String jndi;
    private String stack;
    private String bindUrl;
    private String invokerName;
    private String proxyFactory;
    private StackTraceElement constructionPoint;

    public RemoteBindingImpl() {
        this.jndi = "";
        this.stack = "";
        this.bindUrl = "";
        this.invokerName = "";
        this.proxyFactory = "RemoteProxyFactory";
        this.constructionPoint = Debugger.constructionPoint();
    }

    public RemoteBindingImpl(String jndi, String stack, String bindUrl, String proxyFactory) {
        this.jndi = jndi;
        this.stack = stack;
        this.bindUrl = bindUrl;
        this.proxyFactory = proxyFactory;
        this.constructionPoint = Debugger.constructionPoint();
    }

    public RemoteBindingImpl(String jndi, String stack, String bindUrl, String invokerName, String proxyFactory) {
        this.jndi = jndi;
        this.stack = stack;
        this.bindUrl = bindUrl;
        this.invokerName = invokerName;
        this.proxyFactory = proxyFactory;
        this.constructionPoint = Debugger.constructionPoint();
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public void setFactory(String factory) {
        this.proxyFactory = factory;
    }

    public void setJndiBinding(String jndi) {
        this.jndi = jndi;
    }

    public void setInvokerName(String invokerName) {
        this.invokerName = invokerName;
    }

    public void setBindUrl(String bindUrl) {
        this.bindUrl = bindUrl;
    }

    public String jndiBinding() {
        return this.jndi;
    }

    public String interceptorStack() {
        return this.stack;
    }

    public String clientBindUrl() {
        return this.bindUrl;
    }

    public String invokerName() {
        return this.invokerName;
    }

    public String factory() {
        return this.proxyFactory;
    }

    public void merge(RemoteBinding annotation) {
        if (this.jndi.length() == 0) {
            this.jndi = annotation.jndiBinding();
        }
        if (this.stack.length() == 0) {
            this.stack = annotation.interceptorStack();
        }
        if (this.bindUrl.length() == 0) {
            this.bindUrl = annotation.clientBindUrl();
        }
        if (this.proxyFactory.equals("RemoteProxyFactory")) {
            this.proxyFactory = annotation.factory();
        }
    }

    public Class<? extends Annotation> annotationType() {
        return RemoteBinding.class;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[RemoteBindingImpl:");
        sb.append(", jndi=" + this.jndi);
        sb.append(", stack=" + this.stack);
        sb.append(", bindUrl=" + this.bindUrl);
        sb.append(", proxyFactory=" + this.proxyFactory);
        sb.append(", constructionPoint=" + this.constructionPoint);
        sb.append(']');
        return sb.toString();
    }
}

