/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.deployers.spi.deployer.helpers.AbstractNameIgnoreMechanism;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class PatternNameIgnoreMechanism
extends AbstractNameIgnoreMechanism {
    private Pattern ignored;
    private boolean match;

    public PatternNameIgnoreMechanism(String regexp) {
        if (regexp == null) {
            throw new IllegalArgumentException("Null regexp");
        }
        this.ignored = Pattern.compile(regexp);
    }

    public boolean ignoreName(DeploymentUnit unit, String name) {
        return this.ignore(unit, name);
    }

    public boolean ignorePath(DeploymentUnit unit, String path) {
        return this.ignore(unit, path);
    }

    protected boolean ignore(DeploymentUnit unit, String input) {
        Matcher matcher = this.ignored.matcher(input);
        return this.match ? matcher.matches() : matcher.find();
    }

    public void setMatch(boolean match) {
        this.match = match;
    }
}

