/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.Module;

public class ClassLoading {
    private Domain EMPTY_DOMAIN = new Domain(this, "DefaultDomain", null, true);
    private Map<String, Domain> domains = new ConcurrentHashMap<String, Domain>();

    public void addModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        String domainName = module.getDeterminedDomainName();
        boolean parentFirst = module.isJ2seClassLoadingCompliance();
        String parentDomainName = module.getDeterminedParentDomainName();
        Domain domain = this.getDomain(domainName, parentDomainName, parentFirst);
        domain.addModule(module);
    }

    public void removeModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        module.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Domain getDomain(String domainName, String parentDomainName, boolean parentFirst) {
        Domain domain;
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            domain = this.getDomain(domainName);
            if (domain == null) {
                domain = this.createDomain(domainName, parentDomainName, parentFirst);
                this.domains.put(domainName, domain);
            }
        }
        return domain;
    }

    protected Domain getDomain(String domainName) {
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        Domain domain = this.domains.get(domainName);
        if (domain == null && "DefaultDomain".equals(domainName)) {
            domain = this.EMPTY_DOMAIN;
        }
        return domain;
    }

    protected Domain createDomain(String domainName, String parentDomainName, boolean parentFirst) {
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        return new Domain(this, domainName, parentDomainName, parentFirst);
    }
}

