/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerConfigUtil {
    private static final String ANY = "0.0.0.0";

    public static String getDefaultBindAddress() {
        return System.getProperty("jboss.bind.address");
    }

    public static String getSpecificBindAddress() {
        String address = System.getProperty("jboss.bind.address");
        if (address == null || address.equals(ANY)) {
            return null;
        }
        return address;
    }

    public static InetAddress fixRemoteAddress(InetAddress address) {
        try {
            if (address == null || InetAddress.getByName(ANY).equals(address)) {
                return InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public static String fixRemoteAddress(String address) {
        try {
            if (address == null || ANY.equals(address)) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public static String getDefaultPartitionName() {
        return System.getProperty("jboss.partition.name", "DefaultPartition");
    }

    public static boolean isLoadNative() {
        return Boolean.getBoolean("jboss.native.load");
    }

    public static String shortUrlFromServerHome(String longUrl) {
        String serverHomeUrl = System.getProperty("jboss.server.home.url");
        if (longUrl == null || serverHomeUrl == null) {
            return longUrl;
        }
        if (longUrl.startsWith(serverHomeUrl)) {
            return ".../" + longUrl.substring(serverHomeUrl.length());
        }
        String jarServerHomeUrl = "jar:" + serverHomeUrl;
        if (longUrl.startsWith(jarServerHomeUrl)) {
            return ".../" + longUrl.substring(jarServerHomeUrl.length());
        }
        return longUrl;
    }
}

