/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.domain;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.jboss.as.plugin.deployment.ConnectionInfo;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.as.plugin.deployment.domain.Domain;
import org.jboss.dmr.ModelNode;

public class DomainDeployment
implements Deployment {
    private final File content;
    private final DomainClient client;
    private final Domain domain;
    private final String name;
    private final Deployment.Type type;

    public DomainDeployment(ConnectionInfo connectionInfo, Domain domain, File content, String name, Deployment.Type type) {
        this.content = content;
        this.client = DomainClient.Factory.create((InetAddress)connectionInfo.getHostAddress(), (int)connectionInfo.getPort(), (CallbackHandler)connectionInfo.getCallbackHandler());
        this.domain = domain;
        this.name = name == null ? content.getName() : name;
        this.type = type;
    }

    public static DomainDeployment create(ConnectionInfo connectionInfo, Domain domain, File content, String name, Deployment.Type type) {
        return new DomainDeployment(connectionInfo, domain, content, name, type);
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException, DuplicateDeploymentNameException, MojoFailureException {
        boolean deploymentExists = this.exists();
        RemoveDeploymentPlanBuilder completeBuilder = null;
        switch (this.type) {
            case DEPLOY: {
                completeBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case FORCE_DEPLOY: {
                if (deploymentExists) {
                    completeBuilder = builder.replace(this.name, this.content);
                    break;
                }
                completeBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case REDEPLOY: {
                completeBuilder = builder.replace(this.name, this.content);
                break;
            }
            case UNDEPLOY: {
                completeBuilder = builder.undeploy(this.name).andRemoveUndeployed();
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                if (deploymentExists) {
                    completeBuilder = builder.undeploy(this.name).andRemoveUndeployed();
                    break;
                }
                return null;
            }
        }
        if (completeBuilder != null) {
            ServerGroupDeploymentPlanBuilder groupDeploymentBuilder = null;
            for (String serverGroupName : this.domain.getServerGroups()) {
                groupDeploymentBuilder = groupDeploymentBuilder == null ? completeBuilder.toServerGroup(serverGroupName) : groupDeploymentBuilder.toServerGroup(serverGroupName);
            }
            if (groupDeploymentBuilder == null) {
                throw new MojoFailureException("No server groups were defined for the deployment.");
            }
            return groupDeploymentBuilder.build();
        }
        throw new IllegalStateException(String.format("Invalid type '%s' for deployment", new Object[]{this.type}));
    }

    @Override
    public Deployment.Status execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validate();
            DomainDeploymentManager manager = this.client.getDeploymentManager();
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null) {
                this.executePlan(manager, plan);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error executing %s", new Object[]{this.type}), e);
        }
        return Deployment.Status.SUCCESS;
    }

    void validate() throws MojoFailureException {
        Map statuses = this.client.getServerStatuses();
        List<String> serverGroups = this.domain.getServerGroups();
        for (String serverGroup : serverGroups) {
            boolean notFound = true;
            for (ServerIdentity serverId : statuses.keySet()) {
                if (!serverGroup.equals(serverId.getServerGroupName())) continue;
                ServerStatus currentStatus = (ServerStatus)statuses.get(serverId);
                if (currentStatus != ServerStatus.STARTED) {
                    throw new MojoFailureException(String.format("Status of server group '%s' is '%s', but is required to be '%s'.", serverGroup, currentStatus, ServerStatus.STARTED));
                }
                notFound = false;
                break;
            }
            if (!notFound) continue;
            throw new MojoFailureException(String.format("Server group '%s' does not exist on the server.", serverGroup));
        }
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private void executePlan(DomainDeploymentManager manager, DeploymentPlan plan) throws MojoExecutionException, ExecutionException, InterruptedException {
        if (plan.getDeploymentActions().size() > 0) {
            DeploymentPlanResult planResult = (DeploymentPlanResult)manager.execute(plan).get();
            Map actionResults = planResult.getDeploymentActionResults();
            for (UUID uuid : actionResults.keySet()) {
                Map groupDeploymentActionResults = ((DeploymentActionResult)actionResults.get(uuid)).getResultsByServerGroup();
                for (String serverGroup2 : groupDeploymentActionResults.keySet()) {
                    Map serverUpdateResults = ((ServerGroupDeploymentActionResult)groupDeploymentActionResults.get(serverGroup2)).getResultByServer();
                    for (String server : serverUpdateResults.keySet()) {
                        Throwable t = ((ServerUpdateResult)serverUpdateResults.get(server)).getFailureResult();
                        if (t == null) continue;
                        throw new MojoExecutionException(String.format("Error executing %s", new Object[]{this.type}), t);
                    }
                }
            }
        }
    }

    private boolean exists() {
        block7: {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-children-names");
            op.get("child-type").set("deployment");
            try {
                ModelNode result = this.client.execute(op);
                String deploymentName = this.name;
                if (result.hasDefined("outcome")) {
                    if (result.get("outcome").asString().equals("success")) {
                        List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                        for (ModelNode n : deployments) {
                            if (!n.asString().equals(deploymentName)) continue;
                            return true;
                        }
                    } else if (result.get("outcome").asString().equals("failed")) {
                        throw new IllegalStateException(String.format("A failure occurred when checking existing deployments. Error: %s", result.hasDefined("failure-description") ? result.get("failure-description").asString() : "Unknown"));
                    }
                    break block7;
                }
                throw new IllegalStateException(String.format("An unexpected response was found checking the deployment. Result: %s", result));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

