/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.ThreadPoolReadAttributeHandler;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;

public class UnboundedQueueThreadPoolReadAttributeHandler
extends ThreadPoolReadAttributeHandler {
    public static final List<String> METRICS = Arrays.asList("active-count", "completed-task-count", "current-thread-count", "largest-thread-count", "largest-pool-size", "rejected-count", "task-count");
    public static final UnboundedQueueThreadPoolReadAttributeHandler INSTANCE = new UnboundedQueueThreadPoolReadAttributeHandler();

    public UnboundedQueueThreadPoolReadAttributeHandler() {
        super(METRICS);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        UnboundedQueueThreadPoolService pool = (UnboundedQueueThreadPoolService)service;
        if (attributeName.equals("active-count")) {
            context.getResult().set(pool.getActiveCount());
        } else if (attributeName.equals("completed-task-count")) {
            context.getResult().set(pool.getCompletedTaskCount());
        } else if (attributeName.equals("current-thread-count")) {
            context.getResult().set(pool.getCurrentThreadCount());
        } else if (attributeName.equals("largest-thread-count")) {
            context.getResult().set(pool.getLargestThreadCount());
        } else if (attributeName.equals("largest-pool-size")) {
            context.getResult().set(pool.getLargestPoolSize());
        } else if (attributeName.equals("rejected-count")) {
            context.getResult().set(pool.getRejectedCount());
        } else if (attributeName.equals("task-count")) {
            context.getResult().set(pool.getTaskCount());
        } else if (METRICS.contains(attributeName)) {
            throw new OperationFailedException(new ModelNode().set("Unsupported attribute '" + attributeName + "'"));
        }
    }
}

