/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.MemoryType;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PlatformMBeanDescriptions {
    static final String RESOURCE_NAME = PlatformMBeanDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private PlatformMBeanDescriptions() {
    }

    public static ModelNode getRootResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("platform-mbeans"));
        node.get("attributes").setEmptyObject();
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "type", "description"}).set(bundle.getString("platform-mbeans.type"));
        node.get(new String[]{"children", "type", "min-occurs"}).set(PlatformMBeanConstants.BASE_TYPES.size());
        node.get(new String[]{"children", "type", "max-occurs"}).set(PlatformMBeanConstants.BASE_TYPES.size());
        node.get(new String[]{"children", "type", "model-description"});
        return node;
    }

    public static ModelNode getClassLoadingResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("class-loading"));
        for (String attr : PlatformMBeanConstants.CLASSLOADING_READ_WRITE_ATTRIBUTES) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("class-loading." + attr));
        }
        for (String attr : PlatformMBeanConstants.CLASSLOADING_METRICS) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("class-loading." + attr));
        }
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        PlatformMBeanDescriptions.populateAttribute(attrs, "verbose", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "total-loaded-class-count", ModelType.LONG, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "loaded-class-count", ModelType.INT, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "unloaded-class-count", ModelType.LONG, true, MeasurementUnit.NONE);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getCompilationResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("compilation"));
        for (String attr : PlatformMBeanConstants.COMPILATION_READ_ATTRIBUTES) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("compilation." + attr));
        }
        for (String attr : PlatformMBeanConstants.COMPILATION_METRICS) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("compilation." + attr));
        }
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "compilation-time-monitoring-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "total-compilation-time", ModelType.LONG, false, MeasurementUnit.MILLISECONDS);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getGarbageCollectorResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("garbage-collector"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.GARBAGE_COLLECTOR_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("garbage-collector." + attr));
        }
        for (String attr : PlatformMBeanConstants.GARBAGE_COLLECTOR_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("garbage-collector." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "valid", ModelType.BOOLEAN, true, null);
        ModelNode names = PlatformMBeanDescriptions.populateAttribute(attrs, "memory-pool-names", ModelType.LIST, true, null);
        names.get("value-type").set(ModelType.STRING);
        PlatformMBeanDescriptions.populateAttribute(attrs, "collection-count", ModelType.LONG, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "collection-time", ModelType.LONG, true, MeasurementUnit.MILLISECONDS);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getGarbageCollectorRootResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("garbage-collectors"));
        node.get("attributes").setEmptyObject();
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "name", "description"}).set(bundle.getString("garbage-collectors.name"));
        node.get(new String[]{"children", "name", "min-occurs"}).set(0);
        node.get(new String[]{"children", "name", "model-description"});
        return node;
    }

    public static ModelNode getMemoryResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("memory"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.MEMORY_READ_WRITE_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory." + attr));
        }
        for (String attr : PlatformMBeanConstants.MEMORY_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "object-pending-finalization-count", ModelType.INT, true, MeasurementUnit.NONE);
        ModelNode heapUsage = PlatformMBeanDescriptions.populateAttribute(attrs, "heap-memory-usage", ModelType.OBJECT, true, null);
        PlatformMBeanDescriptions.populateMemoryUsage(heapUsage.get("value-type"), bundle);
        ModelNode nonHeapUsage = PlatformMBeanDescriptions.populateAttribute(attrs, "non-heap-memory-usage", ModelType.OBJECT, true, null);
        PlatformMBeanDescriptions.populateMemoryUsage(nonHeapUsage.get("value-type"), bundle);
        PlatformMBeanDescriptions.populateAttribute(attrs, "verbose", ModelType.BOOLEAN, true, null);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    private static void populateMemoryUsage(ModelNode toPopulate, ResourceBundle bundle) {
        toPopulate.get(new String[]{"init", "description"}).set(bundle.getString("memory.usage.init"));
        toPopulate.get(new String[]{"init", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"init", "nillable"}).set(true);
        toPopulate.get(new String[]{"init", "unit"}).set(MeasurementUnit.BYTES.getName());
        toPopulate.get(new String[]{"used", "description"}).set(bundle.getString("memory.usage.used"));
        toPopulate.get(new String[]{"used", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"used", "nillable"}).set(true);
        toPopulate.get(new String[]{"used", "unit"}).set(MeasurementUnit.BYTES.getName());
        toPopulate.get(new String[]{"committed", "description"}).set(bundle.getString("memory.usage.committed"));
        toPopulate.get(new String[]{"committed", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"committed", "nillable"}).set(true);
        toPopulate.get(new String[]{"committed", "unit"}).set(MeasurementUnit.BYTES.getName());
        toPopulate.get(new String[]{"max", "description"}).set(bundle.getString("memory.usage.max"));
        toPopulate.get(new String[]{"max", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"max", "nillable"}).set(true);
        toPopulate.get(new String[]{"max", "unit"}).set(MeasurementUnit.BYTES.getName());
    }

    public static ModelNode getMemoryManagerResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("memory-manager"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.MEMORY_MANAGER_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory-manager." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "valid", ModelType.BOOLEAN, true, null);
        ModelNode names = PlatformMBeanDescriptions.populateAttribute(attrs, "memory-pool-names", ModelType.LIST, true, null);
        names.get("value-type").set(ModelType.STRING);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getMemoryManagerRootResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("memory-managers"));
        node.get("attributes").setEmptyObject();
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "name", "description"}).set(bundle.getString("memory-managers.name"));
        node.get(new String[]{"children", "name", "min-occurs"}).set(0);
        node.get(new String[]{"children", "name", "model-description"});
        return node;
    }

    public static ModelNode getMemoryPoolResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("memory-pool"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory-pool." + attr));
        }
        for (String attr : PlatformMBeanConstants.MEMORY_POOL_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory-pool." + attr));
        }
        for (String attr : PlatformMBeanConstants.MEMORY_POOL_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("memory-pool." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        ModelNode types = PlatformMBeanDescriptions.populateAttribute(attrs, "type", ModelType.STRING, true, null).get("allowed");
        for (MemoryType memType : MemoryType.values()) {
            types.add(memType.name());
        }
        ModelNode usage = PlatformMBeanDescriptions.populateAttribute(attrs, "usage", ModelType.OBJECT, true, null);
        PlatformMBeanDescriptions.populateMemoryUsage(usage.get("value-type"), bundle);
        ModelNode peakUsage = PlatformMBeanDescriptions.populateAttribute(attrs, "peak-usage", ModelType.OBJECT, true, null);
        PlatformMBeanDescriptions.populateMemoryUsage(peakUsage.get("value-type"), bundle);
        PlatformMBeanDescriptions.populateAttribute(attrs, "valid", ModelType.BOOLEAN, true, null);
        ModelNode names = PlatformMBeanDescriptions.populateAttribute(attrs, "memory-manager-names", ModelType.LIST, true, null);
        names.get("value-type").set(ModelType.STRING);
        ModelNode usageThresh = PlatformMBeanDescriptions.populateAttribute(attrs, "usage-threshold", ModelType.LONG, false, MeasurementUnit.BYTES);
        usageThresh.get("min").set(0);
        PlatformMBeanDescriptions.populateAttribute(attrs, "usage-threshold-exceeded", ModelType.BOOLEAN, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "usage-threshold-count", ModelType.LONG, false, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "usage-threshold-supported", ModelType.BOOLEAN, true, null);
        ModelNode collUsageThresh = PlatformMBeanDescriptions.populateAttribute(attrs, "collection-usage-threshold", ModelType.LONG, false, MeasurementUnit.BYTES);
        collUsageThresh.get("min").set(0);
        PlatformMBeanDescriptions.populateAttribute(attrs, "collection-usage-threshold-exceeded", ModelType.BOOLEAN, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "collection-usage-threshold-count", ModelType.LONG, false, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "collection-usage-threshold-supported", ModelType.BOOLEAN, true, null);
        ModelNode collUsage = PlatformMBeanDescriptions.populateAttribute(attrs, "collection-usage", ModelType.OBJECT, false, null);
        PlatformMBeanDescriptions.populateMemoryUsage(collUsage.get("value-type"), bundle);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getMemoryPoolRootResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("memory-pools"));
        node.get("attributes").setEmptyObject();
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "name", "description"}).set(bundle.getString("memory-pools.name"));
        node.get(new String[]{"children", "name", "min-occurs"}).set(0);
        node.get(new String[]{"children", "name", "model-description"});
        return node;
    }

    public static ModelNode getOperatingSystemResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("operating-system"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.OPERATING_SYSTEM_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("operating-system." + attr));
        }
        for (String attr : PlatformMBeanConstants.OPERATING_SYSTEM_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("operating-system." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "arch", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "version", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "available-processors", ModelType.INT, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "system-load-average", ModelType.DOUBLE, true, MeasurementUnit.PERCENTAGE);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getRuntimeResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("runtime"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.RUNTIME_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("runtime." + attr));
        }
        for (String attr : PlatformMBeanConstants.RUNTIME_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("runtime." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "vm-name", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "vm-vendor", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "vm-version", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "spec-name", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "spec-vendor", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "spec-version", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "management-spec-version", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "class-path", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "library-path", ModelType.STRING, false, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "boot-class-path-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "boot-class-path", ModelType.STRING, false, null);
        ModelNode inputArgs = PlatformMBeanDescriptions.populateAttribute(attrs, "input-arguments", ModelType.LIST, false, null);
        inputArgs.get("value-type").set(ModelType.STRING);
        PlatformMBeanDescriptions.populateAttribute(attrs, "uptime", ModelType.LONG, true, MeasurementUnit.MILLISECONDS);
        PlatformMBeanDescriptions.populateAttribute(attrs, "start-time", ModelType.LONG, true, MeasurementUnit.MILLISECONDS);
        ModelNode sysProps = PlatformMBeanDescriptions.populateAttribute(attrs, "system-properties", ModelType.OBJECT, false, null);
        sysProps.get("value-type").set(ModelType.STRING);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getThreadingResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("threading"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        for (String attr : PlatformMBeanConstants.THREADING_READ_WRITE_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("threading." + attr));
        }
        for (String attr : PlatformMBeanConstants.THREADING_READ_ATTRIBUTES) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("threading." + attr));
        }
        for (String attr : PlatformMBeanConstants.THREADING_METRICS) {
            attrs.get(new String[]{attr, "description"}).set(bundle.getString("threading." + attr));
        }
        PlatformMBeanDescriptions.populateAttribute(attrs, "thread-count", ModelType.INT, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "peak-thread-count", ModelType.INT, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "total-started-thread-count", ModelType.LONG, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "daemon-thread-count", ModelType.INT, true, MeasurementUnit.NONE);
        ModelNode allIds = PlatformMBeanDescriptions.populateAttribute(attrs, "all-thread-ids", ModelType.LIST, true, null);
        allIds.get("value-type").set(ModelType.LONG);
        PlatformMBeanDescriptions.populateAttribute(attrs, "thread-contention-monitoring-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "thread-contention-monitoring-enabled", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "current-thread-cpu-time", ModelType.LONG, true, MeasurementUnit.NANOSECONDS);
        PlatformMBeanDescriptions.populateAttribute(attrs, "current-thread-user-time", ModelType.LONG, true, MeasurementUnit.NANOSECONDS);
        PlatformMBeanDescriptions.populateAttribute(attrs, "thread-cpu-time-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "current-thread-cpu-time-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "thread-cpu-time-enabled", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "object-monitor-usage-supported", ModelType.BOOLEAN, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "synchronizer-usage-supported", ModelType.BOOLEAN, true, null);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getGetThreadInfoDescripton(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle, "get-thread-info", "threading");
        node.get(new String[]{"request-properties", "max-depth", "description"}).set(bundle.getString("threading.max-depth"));
        node.get(new String[]{"request-properties", "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "max-depth", "min"}).set(1);
        node.get(new String[]{"request-properties", "max-depth", "required"}).set(false);
        node.get(new String[]{"request-properties", "max-depth", "default"}).set(0);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle.getString("threading.get-thread-info.reply"));
        reply.get("type").set(ModelType.OBJECT);
        reply.get("nillable").set(true);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle);
        return node;
    }

    public static ModelNode getGetThreadInfosDescripton(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-thread-infos");
        node.get("description").set(bundle.getString("threading.get-thread-infos"));
        node.get(new String[]{"request-properties", "ids", "description"}).set(bundle.getString("threading.ids"));
        node.get(new String[]{"request-properties", "ids", "type"}).set(ModelType.LIST);
        node.get(new String[]{"request-properties", "ids", "value-type"}).set(ModelType.LONG);
        node.get(new String[]{"request-properties", "ids", "required"}).set(true);
        node.get(new String[]{"request-properties", "max-depth", "description"}).set(bundle.getString("threading.max-depth"));
        node.get(new String[]{"request-properties", "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "max-depth", "min"}).set(1);
        node.get(new String[]{"request-properties", "max-depth", "required"}).set(false);
        node.get(new String[]{"request-properties", "max-depth", "default"}).set(0);
        node.get(new String[]{"request-properties", "locked-monitors", "description"}).set(bundle.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-monitors", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-monitors", "required"}).set(false);
        node.get(new String[]{"request-properties", "locked-monitors", "default"}).set(false);
        node.get(new String[]{"request-properties", "locked-synchronizers", "description"}).set(bundle.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-synchronizers", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-synchronizers", "required"}).set(false);
        node.get(new String[]{"request-properties", "locked-synchronizers", "default"}).set(false);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle.getString("threading.get-thread-infos.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("nillable").set(false);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle);
        return node;
    }

    public static ModelNode getDumpThreadsDescripton(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("dump-all-threads");
        node.get("description").set(bundle.getString("threading.dump-all-threads"));
        node.get(new String[]{"request-properties", "locked-monitors", "description"}).set(bundle.getString("threading.locked-monitors"));
        node.get(new String[]{"request-properties", "locked-monitors", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-monitors", "required"}).set(true);
        node.get(new String[]{"request-properties", "locked-synchronizers", "description"}).set(bundle.getString("threading.locked-synchronizers"));
        node.get(new String[]{"request-properties", "locked-synchronizers", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "locked-synchronizers", "required"}).set(true);
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle.getString("threading.dump-threads.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("nillable").set(false);
        PlatformMBeanDescriptions.populateThreadInfo(reply.get("value-type"), bundle);
        return node;
    }

    public static ModelNode getThreadCpuTimeOperation(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle, "get-thread-cpu-time", "threading");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return node;
    }

    public static ModelNode getThreadUserTimeOperation(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = PlatformMBeanDescriptions.getThreadInfoOperation(bundle, "get-thread-user-time", "threading");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return node;
    }

    public static ModelNode getFindThreadsOperation(Locale locale, String name, String descriptionKeyBase) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle.getString(descriptionKeyBase + "." + name));
        node.get("request-properties").setEmptyObject();
        ModelNode reply = node.get("reply-properties");
        reply.get("description").set(bundle.getString("threading.find-threads.reply"));
        reply.get("type").set(ModelType.LIST);
        reply.get("value-type").set(ModelType.LONG);
        reply.get("nillable").set(true);
        return node;
    }

    private static ModelNode getThreadInfoOperation(ResourceBundle bundle, String name, String descriptionKeyBase) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle.getString(descriptionKeyBase + "." + name));
        node.get(new String[]{"request-properties", "id", "description"}).set(bundle.getString("threading.id"));
        node.get(new String[]{"request-properties", "id", "type"}).set(ModelType.LONG);
        node.get(new String[]{"request-properties", "id", "min"}).set(1);
        node.get(new String[]{"request-properties", "id", "required"}).set(true);
        return node;
    }

    private static void populateThreadInfo(ModelNode toPopulate, ResourceBundle bundle) {
        toPopulate.get(new String[]{"thread-id", "description"}).set(bundle.getString("threading.thread-info.thread-id"));
        toPopulate.get(new String[]{"thread-id", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"thread-id", "nillable"}).set(true);
        toPopulate.get(new String[]{"thread-name", "description"}).set(bundle.getString("threading.thread-info.thread-name"));
        toPopulate.get(new String[]{"thread-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"thread-name", "nillable"}).set(true);
        ModelNode threadState = toPopulate.get("thread-state");
        threadState.get("description").set(bundle.getString("threading.thread-info.thread-state"));
        threadState.get("type").set(ModelType.STRING);
        threadState.get("nillable").set(true);
        ModelNode allowed = threadState.get("allowed");
        for (Thread.State state : Thread.State.values()) {
            allowed.add(state.name());
        }
        toPopulate.get(new String[]{"blocked-time", "description"}).set(bundle.getString("threading.thread-info.blocked-time"));
        toPopulate.get(new String[]{"blocked-time", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"blocked-time", "nillable"}).set(false);
        toPopulate.get(new String[]{"blocked-time", "unit"}).set(MeasurementUnit.MILLISECONDS.getName());
        toPopulate.get(new String[]{"blocked-count", "description"}).set(bundle.getString("threading.thread-info.blocked-count"));
        toPopulate.get(new String[]{"blocked-count", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"blocked-count", "nillable"}).set(true);
        toPopulate.get(new String[]{"waited-time", "description"}).set(bundle.getString("threading.thread-info.waited-time"));
        toPopulate.get(new String[]{"waited-time", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"waited-time", "nillable"}).set(false);
        toPopulate.get(new String[]{"waited-time", "unit"}).set(MeasurementUnit.MILLISECONDS.getName());
        toPopulate.get(new String[]{"waited-count", "description"}).set(bundle.getString("threading.thread-info.waited-count"));
        toPopulate.get(new String[]{"waited-count", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"waited-count", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-info", "description"}).set(bundle.getString("threading.thread-info.lock-info"));
        toPopulate.get(new String[]{"lock-info", "type"}).set(ModelType.OBJECT);
        toPopulate.get(new String[]{"lock-info", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateLockInfo(toPopulate.get(new String[]{"lock-info", "value-type"}), bundle);
        toPopulate.get(new String[]{"lock-name", "description"}).set(bundle.getString("threading.thread-info.lock-name"));
        toPopulate.get(new String[]{"lock-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"lock-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-owner-id", "description"}).set(bundle.getString("threading.thread-info.lock-owner-id"));
        toPopulate.get(new String[]{"lock-owner-id", "type"}).set(ModelType.LONG);
        toPopulate.get(new String[]{"lock-owner-id", "nillable"}).set(true);
        toPopulate.get(new String[]{"lock-owner-name", "description"}).set(bundle.getString("threading.thread-info.lock-owner-name"));
        toPopulate.get(new String[]{"lock-owner-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"lock-owner-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"stack-trace", "description"}).set(bundle.getString("threading.thread-info.stack-trace"));
        toPopulate.get(new String[]{"stack-trace", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"stack-trace", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateStackTraceElement(toPopulate.get(new String[]{"stack-trace", "value-type"}), bundle);
        toPopulate.get(new String[]{"suspended", "description"}).set(bundle.getString("threading.thread-info.suspended"));
        toPopulate.get(new String[]{"suspended", "type"}).set(ModelType.BOOLEAN);
        toPopulate.get(new String[]{"suspended", "nillable"}).set(true);
        toPopulate.get(new String[]{"in-native", "description"}).set(bundle.getString("threading.thread-info.in-native"));
        toPopulate.get(new String[]{"in-native", "type"}).set(ModelType.BOOLEAN);
        toPopulate.get(new String[]{"in-native", "nillable"}).set(true);
        toPopulate.get(new String[]{"locked-monitors", "description"}).set(bundle.getString("threading.thread-info.locked-monitors"));
        toPopulate.get(new String[]{"locked-monitors", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"locked-monitors", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateMonitorInfo(toPopulate.get(new String[]{"locked-monitors", "value-type"}), bundle);
        toPopulate.get(new String[]{"locked-synchronizers", "description"}).set(bundle.getString("threading.thread-info.locked-synchronizers"));
        toPopulate.get(new String[]{"locked-synchronizers", "type"}).set(ModelType.LIST);
        toPopulate.get(new String[]{"locked-synchronizers", "nillable"}).set(true);
        PlatformMBeanDescriptions.populateLockInfo(toPopulate.get(new String[]{"locked-synchronizers", "value-type"}), bundle);
    }

    private static void populateLockInfo(ModelNode toPopulate, ResourceBundle bundle) {
        toPopulate.get(new String[]{"class-name", "description"}).set(bundle.getString("threading.lock.class-name"));
        toPopulate.get(new String[]{"class-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"class-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"identity-hash-code", "description"}).set(bundle.getString("threading.lock.identity-hash-code"));
        toPopulate.get(new String[]{"identity-hash-code", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"identity-hash-code", "nillable"}).set(true);
    }

    private static void populateMonitorInfo(ModelNode toPopulate, ResourceBundle bundle) {
        PlatformMBeanDescriptions.populateLockInfo(toPopulate, bundle);
        toPopulate.get(new String[]{"locked-stack-depth", "description"}).set(bundle.getString("threading.monitor.locked-stack-depth"));
        toPopulate.get(new String[]{"locked-stack-depth", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"locked-stack-depth", "nillable"}).set(true);
        toPopulate.get(new String[]{"locked-stack-frame", "description"}).set(bundle.getString("threading.monitor.locked-stack-frame"));
        toPopulate.get(new String[]{"locked-stack-frame", "type"}).set(ModelType.OBJECT);
        toPopulate.get(new String[]{"locked-stack-frame", "nillable"}).set(true);
        ModelNode valType = toPopulate.get(new String[]{"locked-stack-frame", "value-type"});
        PlatformMBeanDescriptions.populateStackTraceElement(valType, bundle);
    }

    private static void populateStackTraceElement(ModelNode toPopulate, ResourceBundle bundle) {
        toPopulate.get(new String[]{"file-name", "description"}).set(bundle.getString("threading.stack.file-name"));
        toPopulate.get(new String[]{"file-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"file-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"line-number", "description"}).set(bundle.getString("threading.stack.line-number"));
        toPopulate.get(new String[]{"line-number", "type"}).set(ModelType.INT);
        toPopulate.get(new String[]{"line-number", "nillable"}).set(true);
        toPopulate.get(new String[]{"class-name", "description"}).set(bundle.getString("threading.stack.class-name"));
        toPopulate.get(new String[]{"class-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"class-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"method-name", "description"}).set(bundle.getString("threading.stack.method-name"));
        toPopulate.get(new String[]{"method-name", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"method-name", "nillable"}).set(true);
        toPopulate.get(new String[]{"native-method", "description"}).set(bundle.getString("threading.stack.native-method"));
        toPopulate.get(new String[]{"native-method", "type"}).set(ModelType.STRING);
        toPopulate.get(new String[]{"native-method", "nillable"}).set(true);
    }

    public static ModelNode getBufferPoolResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("buffer-pool"));
        for (String attr : PlatformMBeanConstants.BUFFER_POOL_READ_ATTRIBUTES) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("buffer-pool." + attr));
        }
        for (String attr : PlatformMBeanConstants.BUFFER_POOL_METRICS) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("buffer-pool." + attr));
        }
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, true, null);
        PlatformMBeanDescriptions.populateAttribute(attrs, "count", ModelType.LONG, true, MeasurementUnit.NONE);
        PlatformMBeanDescriptions.populateAttribute(attrs, "memory-used", ModelType.LONG, true, MeasurementUnit.BYTES);
        PlatformMBeanDescriptions.populateAttribute(attrs, "total-capacity", ModelType.LONG, true, MeasurementUnit.BYTES);
        attrs.get(new String[]{"name", "description"}).set(bundle.getString("buffer-pools.name"));
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getBufferPoolRootResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("buffer-pools"));
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.populateAttribute(attrs, "name", ModelType.STRING, false, null);
        attrs.get(new String[]{"name", "description"}).set(bundle.getString("buffer-pools.name"));
        node.get("operations").setEmptyObject();
        node.get(new String[]{"children", "name", "description"}).set(bundle.getString("buffer-pools.name"));
        node.get(new String[]{"children", "name", "min-occurs"}).set(0);
        node.get(new String[]{"children", "name", "model-description"});
        return node;
    }

    public static ModelNode getPlatformLoggingResource(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("logging"));
        for (String attr : PlatformMBeanConstants.LOGGING_READ_ATTRIBUTES) {
            node.get(new String[]{"attributes", attr, "description"}).set(bundle.getString("logging." + attr));
        }
        ModelNode attrs = node.get("attributes");
        PlatformMBeanDescriptions.addObjectNameAttribute(attrs, bundle);
        ModelNode loggers = PlatformMBeanDescriptions.populateAttribute(attrs, "logger-names", ModelType.LIST, true, null);
        loggers.get("value-type").set(ModelType.STRING);
        node.get("operations").setEmptyObject();
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getGetLoggerLevelDescription(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-logger-level");
        node.get("description").set(bundle.getString("logging.get-logger-level"));
        PlatformMBeanDescriptions.addLoggerNameParam(node.get("request-properties"), bundle);
        node.get("reply-properties");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        node.get(new String[]{"reply-properties", "nillable"}).set(true);
        return node;
    }

    public static ModelNode getSetLoggerLevelDescription(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("set-logger-level");
        node.get("description").set(bundle.getString("logging.set-logger-level"));
        ModelNode reqProps = node.get("request-properties");
        PlatformMBeanDescriptions.addLoggerNameParam(reqProps, bundle);
        ModelNode level = reqProps.get("level-name");
        level.get("description").set(bundle.getString("logging.level-name"));
        level.get("type").set(ModelType.STRING);
        level.get("required").set(false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getGetParentLoggerNameDescription(Locale locale) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("get-parent-logger-name");
        node.get("description").set(bundle.getString("logging.get-parent-logger-name"));
        PlatformMBeanDescriptions.addLoggerNameParam(node.get("request-properties"), bundle);
        node.get("reply-properties");
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        node.get(new String[]{"reply-properties", "nillable"}).set(true);
        return node;
    }

    private static void addLoggerNameParam(ModelNode requestProperties, ResourceBundle bundle) {
        ModelNode param = requestProperties.get("logger-name");
        param.get("description").set(bundle.getString("logging.logger-name"));
        param.get("type").set(ModelType.STRING);
        param.get("min-length").set(0);
        param.get("required").set(true);
    }

    public static ModelNode getDescriptionOnlyOperation(Locale locale, String name, String descriptionKeyBase) {
        ResourceBundle bundle = PlatformMBeanDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set(name);
        node.get("description").set(bundle.getString(descriptionKeyBase + "." + name));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ModelNode populateAttribute(ModelNode attributes, String name, ModelType type, boolean required, MeasurementUnit measurementUnit) {
        ModelNode attr = attributes.get(name);
        attr.get("type").set(type);
        attr.get("nillable").set(!required);
        if (measurementUnit != null) {
            attr.get("unit").set(measurementUnit.getName());
        }
        return attr;
    }

    private static void addObjectNameAttribute(ModelNode attributes, ResourceBundle bundle) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            ModelNode attr = attributes.get("object-name");
            attr.get("description").set(bundle.getString("object-name"));
            attr.get("type").set(ModelType.STRING);
            attr.get("nillable").set(true);
        }
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

