/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ear.spec.Ear6xMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;

public class EarApplicationNameProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String earApplicationName = this.getApplicationName(deploymentUnit);
        deploymentUnit.putAttachment(Attachments.EAR_APPLICATION_NAME, (Object)earApplicationName);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private String getApplicationName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            EarMetaData earMetaData = (EarMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA);
            if (earMetaData != null && earMetaData instanceof Ear6xMetaData) {
                String overriddenAppName = ((Ear6xMetaData)earMetaData).getApplicationName();
                if (overriddenAppName == null) {
                    return this.getEarName(deploymentUnit);
                }
                return overriddenAppName;
            }
            return this.getEarName(deploymentUnit);
        }
        return this.getApplicationName(parentDU);
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        String duName = deploymentUnit.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }
}

