/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.Locale;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.State;

public class ConfirmationChoice
implements State {
    private ConsoleWrapper theConsole;
    private final String message;
    private final String prompt;
    private final State yesState;
    private final State noState;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int INVALID = 2;

    public ConfirmationChoice(ConsoleWrapper theConsole, String message, String prompt, State yesState, State noState) {
        this.theConsole = theConsole;
        this.message = message;
        this.prompt = prompt;
        this.yesState = yesState;
        this.noState = noState;
        if (theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        if (this.message != null) {
            this.theConsole.printf(this.message, new Object[0]);
            this.theConsole.printf("\n", new Object[0]);
        }
        this.theConsole.printf(this.prompt, new Object[0]);
        String temp = this.theConsole.readLine(" ", new Object[0]);
        switch (this.convertResponse(temp)) {
            case 0: {
                return this.yesState;
            }
            case 1: {
                return this.noState;
            }
        }
        return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.invalidConfirmationResponse(), this);
    }

    private int convertResponse(String response) {
        if (response != null) {
            String temp = response.toLowerCase(Locale.ENGLISH);
            if ("yes".equals(temp) || "y".equals(temp)) {
                return 0;
            }
            if ("no".equals(temp) || "n".equals(temp)) {
                return 1;
            }
        }
        return 2;
    }
}

