/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.Serializable;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.ExtendedEntityManager;

public class ReferenceCountedEntityManager
implements Serializable {
    private static final long serialVersionUID = 456457893L;
    private final ExtendedEntityManager entityManager;
    private volatile int referenceCount = 1;

    public ReferenceCountedEntityManager(ExtendedEntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void increaseReferenceCount() {
        ++this.referenceCount;
    }

    public void close() {
        if (--this.referenceCount == 0) {
            this.entityManager.containerClose();
        }
        if (this.referenceCount < 0) {
            throw JpaMessages.MESSAGES.referenceCountedEntityManagerNegativeCount(this.referenceCount, this.entityManager.getScopedPuName());
        }
    }

    public ExtendedEntityManager getEntityManager() {
        return this.entityManager;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }
}

